/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ElementHolder;
import com.antgroup.antchain.myjava.model.FieldHolder;
import com.antgroup.antchain.myjava.model.GenericTypeParameter;
import com.antgroup.antchain.myjava.model.GenericValueType;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassHolder
extends ElementHolder
implements ClassReader {
    private GenericTypeParameter[] genericParameters;
    private String parent = Object.class.getName();
    private GenericValueType.Object genericParent;
    private Set<String> interfaces = new LinkedHashSet<String>();
    private Set<GenericValueType.Object> genericInterfaces = new LinkedHashSet<GenericValueType.Object>();
    private Map<MethodDescriptor, MethodHolder> methods = new LinkedHashMap<MethodDescriptor, MethodHolder>();
    private Map<String, FieldHolder> fields = new LinkedHashMap<String, FieldHolder>();
    private String ownerName;
    private String simpleName;
    private String declaringClassName;

    public ClassHolder(String name) {
        super(name);
    }

    @Override
    public GenericTypeParameter[] getGenericParameters() {
        return this.genericParameters != null ? (GenericTypeParameter[])this.genericParameters.clone() : null;
    }

    public void setGenericParameters(GenericTypeParameter[] genericParameters) {
        this.genericParameters = genericParameters != null ? (GenericTypeParameter[])genericParameters.clone() : null;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    @Override
    public GenericValueType.Object getGenericParent() {
        return this.genericParent;
    }

    public void setGenericParent(GenericValueType.Object genericParent) {
        this.genericParent = genericParent;
    }

    @Override
    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public Set<GenericValueType.Object> getGenericInterfaces() {
        return this.genericInterfaces;
    }

    public void setGenericInterfaces(Set<GenericValueType.Object> genericInterfaces) {
        this.genericInterfaces = genericInterfaces;
    }

    @Override
    public MethodHolder getMethod(MethodDescriptor method) {
        return this.methods.get(method);
    }

    public Collection<MethodHolder> getMethods() {
        return this.methods.values();
    }

    @Override
    public Collection<? extends MethodReader> getConstructors() {
        return this.methods.values().stream().filter(m -> "<init>".equals(m.getName())).collect(Collectors.toList());
    }

    public void addMethod(MethodHolder method) {
        if (method.getOwner() != null) {
            throw new IllegalArgumentException("Method " + method.getDescriptor() + " is already in another class (" + method.getOwner().getName() + ")");
        }
        method.setOwner(this);
        MethodHolder oldMethod = this.methods.put(method.getDescriptor(), method);
        if (oldMethod != null) {
            oldMethod.setOwner(null);
        }
    }

    public void removeMethod(MethodHolder method) {
        if (method.getOwner() != this) {
            throw new IllegalArgumentException("Method " + method.getOwner().getName() + "." + method.getDescriptor() + " is not a member of " + this.getName());
        }
        this.methods.remove(method.getDescriptor());
        method.setOwner(null);
    }

    @Override
    public FieldHolder getField(String name) {
        return this.fields.get(name);
    }

    public Collection<FieldHolder> getFields() {
        return this.fields.values();
    }

    public void addField(FieldHolder field) {
        if (field.getOwner() != null) {
            throw new IllegalArgumentException("Field " + field.getName() + " is already in another class (" + field.getOwner().getName() + ")");
        }
        field.setOwner(this);
        FieldHolder oldField = this.fields.put(field.getName(), field);
        if (oldField != null) {
            oldField.setOwner(null);
        }
    }

    public void removeField(FieldHolder field) {
        if (field.getOwner() != this) {
            throw new IllegalArgumentException("Field " + field.getOwner().getName() + "." + field.getName() + " is not a member of " + this.getName());
        }
        this.fields.remove(field.getName());
        field.setOwner(null);
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    @Override
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    public void setDeclaringClassName(String declaringClassName) {
        this.declaringClassName = declaringClassName;
    }
}

