/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.AnnotationContainerReader;
import com.antgroup.antchain.myjava.model.AnnotationHolder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class AnnotationContainer
implements AnnotationContainerReader {
    private Map<String, AnnotationHolder> annotations;

    public void add(AnnotationHolder annotation) {
        if (this.annotations == null) {
            this.annotations = new LinkedHashMap<String, AnnotationHolder>();
        }
        if (this.annotations.containsKey(annotation.getType())) {
            throw new IllegalArgumentException("Annotation of type " + annotation.getType() + " is already there");
        }
        this.annotations.put(annotation.getType(), annotation);
    }

    @Override
    public AnnotationHolder get(String type) {
        return this.annotations != null ? this.annotations.get(type) : null;
    }

    public void remove(AnnotationHolder annotation) {
        AnnotationHolder existingAnnot = this.get(annotation.getType());
        if (existingAnnot != annotation) {
            throw new IllegalArgumentException("There is no such annotation");
        }
        this.annotations.remove(annotation.getType());
    }

    public void remove(String type) {
        if (this.annotations != null) {
            this.annotations.remove(type);
        }
    }

    public Iterable<AnnotationHolder> all() {
        return this.annotations != null ? this.annotations.values() : Collections.emptyList();
    }
}

