/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyType;
import com.antgroup.antchain.myjava.dependency.DependencyTypeFilter;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.BitSet;

class SuperArrayFilter
implements DependencyTypeFilter {
    private DependencyAnalyzer analyzer;
    private DependencyTypeFilter itemTypeFilter;
    private BitSet knownTypes = new BitSet();
    private BitSet cache = new BitSet();

    SuperArrayFilter(DependencyAnalyzer analyzer, DependencyTypeFilter itemTypeFilter) {
        this.analyzer = analyzer;
        this.itemTypeFilter = itemTypeFilter;
    }

    @Override
    public boolean match(DependencyType type) {
        if (this.knownTypes.get(type.index)) {
            return this.cache.get(type.index);
        }
        boolean result = this.matchCacheMiss(type);
        this.knownTypes.set(type.index);
        this.cache.set(type.index, result);
        return result;
    }

    private boolean matchCacheMiss(DependencyType type) {
        if (!type.getName().startsWith("[")) {
            return false;
        }
        String typeName = type.getName().substring(1);
        ValueType valueType = ValueType.parseIfPossible(typeName);
        if (valueType == null || valueType instanceof ValueType.Primitive) {
            return false;
        }
        if (valueType instanceof ValueType.Object) {
            typeName = ((ValueType.Object)valueType).getClassName();
        }
        return this.itemTypeFilter.match(this.analyzer.getType(typeName));
    }

    @Override
    public int[] tryExtract(BitSet types) {
        int[] result = this.itemTypeFilter.tryExtract(types);
        if (result == null) {
            return null;
        }
        for (int i = 0; i < result.length; ++i) {
            String name = this.analyzer.types.get(i).getName();
            int mapped = name.startsWith("[") ? this.analyzer.getType((String)new StringBuilder().append((String)"[").append((String)name).toString()).index : (name.startsWith("~") ? this.analyzer.getType((String)new StringBuilder().append((String)"[").append((String)name.substring((int)1)).toString()).index : this.analyzer.getType((String)ValueType.arrayOf((ValueType)ValueType.object((String)name)).toString()).index);
            result[i] = mapped;
        }
        return result;
    }
}

