/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.common.ServiceRepository;
import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyGraphBuilder;
import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ReferenceCache;
import com.antgroup.antchain.myjava.model.ValueType;

public class PreciseDependencyAnalyzer
extends DependencyAnalyzer {
    public PreciseDependencyAnalyzer(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Diagnostics diagnostics, ReferenceCache referenceCache) {
        super(classSource, classLoader, services, diagnostics, referenceCache);
    }

    @Override
    protected void processMethod(MethodDependency methodDep) {
        DependencyGraphBuilder graphBuilder = new DependencyGraphBuilder(this);
        graphBuilder.buildGraph(methodDep, this.getClassSource());
    }

    @Override
    DependencyNode createParameterNode(MethodReference method, ValueType type, int index) {
        DependencyNode node = this.createNode(type);
        node.method = method;
        if (shouldTag) {
            node.setTag(method + ":" + index);
        }
        return node;
    }

    @Override
    DependencyNode createResultNode(MethodReference method) {
        DependencyNode node = this.createNode(method.getReturnType());
        node.method = method;
        if (shouldTag) {
            node.setTag(method + ":RESULT");
        }
        return node;
    }

    @Override
    DependencyNode createThrownNode(MethodReference method) {
        DependencyNode node = this.createNode();
        node.method = method;
        if (shouldTag) {
            node.setTag(method + ":THROWN");
        }
        return node;
    }

    @Override
    DependencyNode createFieldNode(FieldReference field, ValueType type) {
        DependencyNode node = this.createNode(type);
        if (shouldTag) {
            node.setTag(field.getClassName() + "#" + field.getFieldName());
        }
        return node;
    }

    @Override
    DependencyNode createArrayItemNode(DependencyNode parent) {
        ValueType itemTypeFilter = parent.typeFilter instanceof ValueType.Array ? ((ValueType.Array)parent.typeFilter).getItemType() : null;
        DependencyNode node = this.createNode(itemTypeFilter);
        node.degree = parent.degree + 1;
        node.method = parent.method;
        if (DependencyAnalyzer.shouldTag) {
            node.tag = parent.tag + "[";
        }
        return node;
    }

    @Override
    DependencyNode createClassValueNode(int degree, DependencyNode parent) {
        DependencyNode node = this.createNode();
        node.degree = degree;
        node.classValueNode = node;
        node.classNodeParent = parent;
        if (DependencyAnalyzer.shouldTag) {
            node.tag = parent.tag + "@";
        }
        return node;
    }

    @Override
    boolean domainOptimizationEnabled() {
        return true;
    }
}

