/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.common.ServiceRepository;
import com.antgroup.antchain.myjava.dependency.AbstractInstructionAnalyzer;
import com.antgroup.antchain.myjava.dependency.ClassSourcePacker;
import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.FastInstructionAnalyzer;
import com.antgroup.antchain.myjava.dependency.FastVirtualCallConsumer;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.model.BasicBlockReader;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ProgramReader;
import com.antgroup.antchain.myjava.model.ReferenceCache;
import com.antgroup.antchain.myjava.model.TryCatchBlockReader;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.HashMap;
import java.util.Map;

public class FastDependencyAnalyzer
extends DependencyAnalyzer {
    DependencyNode instancesNode;
    DependencyNode classesNode;
    private Map<MethodReference, FastVirtualCallConsumer> virtualCallConsumers = new HashMap<MethodReference, FastVirtualCallConsumer>();
    private Map<String, DependencyNode> subtypeNodes = new HashMap<String, DependencyNode>();

    public FastDependencyAnalyzer(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Diagnostics diagnostics, ReferenceCache referenceCache) {
        super(classSource, classLoader, services, diagnostics, referenceCache);
        this.instancesNode = new DependencyNode(this, null);
        this.classesNode = new DependencyNode(this, null);
        this.instancesNode.addConsumer(type -> this.getSubtypeNode(type.getName()).propagate(type));
    }

    @Override
    protected void processMethod(MethodDependency methodDep) {
        MethodReader method = methodDep.getMethod();
        ProgramReader program = method.getProgram();
        if (program != null) {
            FastInstructionAnalyzer instructionAnalyzer = new FastInstructionAnalyzer(this);
            instructionAnalyzer.setCaller(method.getReference());
            for (BasicBlockReader basicBlockReader : program.getBasicBlocks()) {
                basicBlockReader.readAllInstructions(instructionAnalyzer);
                for (TryCatchBlockReader tryCatchBlockReader : basicBlockReader.readTryCatchBlocks()) {
                    if (tryCatchBlockReader.getExceptionType() == null) continue;
                    this.linkClass(tryCatchBlockReader.getExceptionType());
                }
            }
            methodDep.variableNodes = new DependencyNode[program.variableCount()];
            for (int i = 0; i < methodDep.variableNodes.length; ++i) {
                methodDep.variableNodes[i] = this.instancesNode;
            }
        }
        if (method.hasModifier(ElementModifier.SYNCHRONIZED)) {
            this.processAsyncMethod();
        }
    }

    private void processAsyncMethod() {
        if (this.asyncSupported) {
            this.linkMethod(AbstractInstructionAnalyzer.MONITOR_ENTER_METHOD).use();
        }
        this.linkMethod(AbstractInstructionAnalyzer.MONITOR_ENTER_SYNC_METHOD).use();
        if (this.asyncSupported) {
            this.linkMethod(AbstractInstructionAnalyzer.MONITOR_EXIT_METHOD).use();
        }
        this.linkMethod(AbstractInstructionAnalyzer.MONITOR_EXIT_SYNC_METHOD).use();
    }

    @Override
    DependencyNode createParameterNode(MethodReference method, ValueType type, int index) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createResultNode(MethodReference method) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createThrownNode(MethodReference method) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createFieldNode(FieldReference field, ValueType type) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createArrayItemNode(DependencyNode parent) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createClassValueNode(int degree, DependencyNode parent) {
        return this.classesNode;
    }

    private DependencyNode getSubtypeNode(String type) {
        if (type.equals("java.lang.Object")) {
            return this.instancesNode;
        }
        return this.subtypeNodes.computeIfAbsent(type, key -> {
            DependencyNode node = this.createNode();
            this.defer(() -> {
                block9: {
                    block7: {
                        block8: {
                            int degree;
                            for (degree = 0; degree < key.length() && key.charAt(degree) == '['; ++degree) {
                            }
                            if (degree <= 0) break block7;
                            ValueType fullType = ValueType.parse(key);
                            if (!(fullType instanceof ValueType.Object)) break block8;
                            String prefix = key.substring(0, degree) + "L";
                            String className = ((ValueType.Object)fullType).getClassName();
                            ClassReader cls = this.getClassSource().get(className);
                            if (cls == null) break block9;
                            if (cls.getParent() != null) {
                                node.connect(this.getSubtypeNode(prefix + cls.getParent().replace('.', '/') + ";"));
                            } else {
                                node.connect(this.getSubtypeNode("java.lang.Object"));
                            }
                            for (String itf : cls.getInterfaces()) {
                                node.connect(this.getSubtypeNode(prefix + itf.replace('.', '/') + ";"));
                            }
                            break block9;
                        }
                        node.connect(this.getSubtypeNode("java.lang.Object"));
                        break block9;
                    }
                    ClassReader cls = this.getClassSource().get((String)key);
                    if (cls != null) {
                        if (cls.getParent() != null) {
                            node.connect(this.getSubtypeNode(cls.getParent()));
                        }
                        for (String itf : cls.getInterfaces()) {
                            node.connect(this.getSubtypeNode(itf));
                        }
                    }
                }
            });
            return node;
        });
    }

    FastVirtualCallConsumer getVirtualCallConsumer(MethodReference method) {
        return this.virtualCallConsumers.computeIfAbsent(method, key -> {
            FastVirtualCallConsumer consumer = new FastVirtualCallConsumer(this.instancesNode, (MethodReference)key, this);
            this.defer(() -> this.getSubtypeNode(method.getClassName()).addConsumer(consumer));
            return consumer;
        });
    }

    @Override
    boolean domainOptimizationEnabled() {
        return false;
    }

    @Override
    public void cleanup(ClassSourcePacker classSourcePacker) {
        this.virtualCallConsumers.clear();
        this.subtypeNodes.clear();
        super.cleanup(classSourcePacker);
    }
}

