/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.dependency.DependencyAgent;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodHandle;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.RuntimeConstant;
import com.antgroup.antchain.myjava.model.emit.ValueEmitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DynamicCallSite {
    private MethodReference caller;
    private MethodDescriptor calledMethod;
    private ValueEmitter instance;
    private List<ValueEmitter> arguments;
    private MethodHandle bootstrapMethod;
    private List<RuntimeConstant> bootstrapArguments;
    private DependencyAgent agent;

    DynamicCallSite(MethodReference caller, MethodDescriptor calledMethod, ValueEmitter instance, List<ValueEmitter> arguments, MethodHandle bootstrapMethod, List<RuntimeConstant> bootstrapArguments, DependencyAgent agent) {
        this.caller = caller;
        this.calledMethod = calledMethod;
        this.instance = instance;
        this.arguments = Collections.unmodifiableList(new ArrayList<ValueEmitter>(arguments));
        this.bootstrapMethod = bootstrapMethod;
        this.bootstrapArguments = Collections.unmodifiableList(new ArrayList<RuntimeConstant>(bootstrapArguments));
        this.agent = agent;
    }

    public MethodReference getCaller() {
        return this.caller;
    }

    public MethodDescriptor getCalledMethod() {
        return this.calledMethod;
    }

    public MethodHandle getBootstrapMethod() {
        return this.bootstrapMethod;
    }

    public List<ValueEmitter> getArguments() {
        return this.arguments;
    }

    public List<RuntimeConstant> getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    public DependencyAgent getAgent() {
        return this.agent;
    }

    public ValueEmitter getInstance() {
        return this.instance;
    }
}

