/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class CachedFunction<T, R>
implements Function<T, R> {
    private Function<T, R> innerFunction;
    private Map<T, Wrapper<R>> cache = new LinkedHashMap<T, Wrapper<R>>();
    private List<KeyListener<T>> keyListeners = new ArrayList<KeyListener<T>>();

    public CachedFunction(Function<T, R> innerFunction) {
        this.innerFunction = innerFunction;
    }

    public R getKnown(T preimage) {
        Wrapper<R> wrapper = this.cache.get(preimage);
        return wrapper != null ? (R)wrapper.value : null;
    }

    @Override
    public R apply(T t) {
        Wrapper<Object> wrapper = this.cache.get(t);
        if (wrapper == null) {
            wrapper = new Wrapper();
            this.cache.put(t, wrapper);
            wrapper.value = this.innerFunction.apply(t);
            wrapper.computed = true;
            for (KeyListener<T> listener : this.keyListeners) {
                listener.keyAdded(t);
            }
        }
        if (!wrapper.computed) {
            throw new IllegalStateException("Recursive calls are not allowed");
        }
        return (R)wrapper.value;
    }

    public void replace(T preimage, R value) {
        this.cache.get(preimage).value = value;
    }

    public void invalidate(T preimage) {
        this.cache.remove(preimage);
    }

    public boolean caches(T preimage) {
        return this.cache.get(preimage) != null;
    }

    public Collection<T> getCachedPreimages() {
        return new LinkedHashSet<T>(this.cache.keySet());
    }

    public void addKeyListener(KeyListener<T> listener) {
        this.keyListeners.add(listener);
    }

    public static interface KeyListener<S> {
        public void keyAdded(S var1);
    }

    private static class Wrapper<S> {
        S value;
        boolean computed;

        private Wrapper() {
        }
    }
}

