/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.stream.impl;

import com.antgroup.antchain.myjava.classlib.java.util.TCollection;
import com.antgroup.antchain.myjava.classlib.java.util.TIterator;
import com.antgroup.antchain.myjava.classlib.java.util.TSpliterator;
import java.util.function.Consumer;

public class TSpliteratorOverCollection<T>
implements TSpliterator<T> {
    private TCollection<T> collection;
    private TIterator<T> iterator;

    public TSpliteratorOverCollection(TCollection<T> collection) {
        this.collection = collection;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        this.ensureIterator();
        if (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.ensureIterator();
        while (this.iterator.hasNext()) {
            action.accept(this.iterator.next());
        }
    }

    private void ensureIterator() {
        if (this.iterator == null) {
            this.iterator = this.collection.iterator();
        }
    }

    @Override
    public TSpliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.collection.size();
    }

    @Override
    public int characteristics() {
        return 64;
    }
}

