/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.jar;

import com.antgroup.antchain.myjava.classlib.java.util.jar.TAttributes;
import com.antgroup.antchain.myjava.classlib.java.util.jar.TJarEntry;
import com.antgroup.antchain.myjava.classlib.java.util.jar.TManifest;
import com.antgroup.antchain.myjava.classlib.java.util.zip.TZipEntry;
import com.antgroup.antchain.myjava.classlib.java.util.zip.TZipInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TJarInputStream
extends TZipInputStream {
    private TManifest manifest;
    private TJarEntry mEntry = this.getNextJarEntry();
    private TJarEntry jarEntry;

    public TJarInputStream(InputStream stream, boolean verify) throws IOException {
        super(stream);
        if (this.mEntry == null) {
            return;
        }
        String name = this.mEntry.getName().toUpperCase();
        if (name.equals("META-INF/")) {
            this.mEntry = null;
            this.closeEntry();
            this.mEntry = this.getNextJarEntry();
            name = this.mEntry.getName().toUpperCase();
        }
        if (name.equals("META-INF/MANIFEST.MF")) {
            this.mEntry = null;
            this.manifest = new TManifest(this, verify);
            this.closeEntry();
        } else {
            TAttributes temp = new TAttributes(3);
            temp.map.put("hidden", null);
            this.mEntry.setAttributes(temp);
        }
    }

    public TJarInputStream(InputStream stream) throws IOException {
        this(stream, true);
    }

    public TManifest getManifest() {
        return this.manifest;
    }

    public TJarEntry getNextJarEntry() throws IOException {
        return (TJarEntry)this.getNextEntry();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.mEntry != null) {
            return -1;
        }
        return super.read(buffer, offset, length);
    }

    @Override
    public TZipEntry getNextEntry() throws IOException {
        if (this.mEntry != null) {
            this.jarEntry = this.mEntry;
            this.mEntry = null;
            this.jarEntry.setAttributes(null);
        } else {
            this.jarEntry = (TJarEntry)super.getNextEntry();
            if (this.jarEntry == null) {
                return null;
            }
        }
        return this.jarEntry;
    }

    @Override
    protected TZipEntry createZipEntry(String name) {
        TJarEntry entry = new TJarEntry(name);
        if (this.manifest != null) {
            entry.setAttributes(this.manifest.getAttributes(name));
        }
        return entry;
    }
}

