/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.util.TGenericEnumSet;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

@NoMetadata
public class TEnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private Class<K> keyType;
    private Object[] data;
    private boolean[] provided;
    private int size;
    private Set<Map.Entry<K, V>> entrySet;

    public TEnumMap(Class<K> keyType) {
        this.initFromKeyType(keyType);
    }

    public TEnumMap(TEnumMap<K, V> m) {
        this.initFromOtherEnumMap(m);
    }

    public TEnumMap(Map<K, V> m) {
        if (m instanceof TEnumMap) {
            this.initFromOtherEnumMap((TEnumMap)m);
        } else {
            if (m.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.initFromKeyType(((Enum)m.keySet().iterator().next()).getDeclaringClass());
            for (Map.Entry<K, V> entry : m.entrySet()) {
                int index = ((Enum)entry.getKey()).ordinal();
                this.provided[index] = true;
                this.data[index] = entry.getValue();
            }
            this.size = m.size();
        }
    }

    private void initFromKeyType(Class<K> keyType) {
        this.keyType = keyType;
        this.data = new Object[TGenericEnumSet.getConstants(keyType).length];
        this.provided = new boolean[this.data.length];
    }

    private void initFromOtherEnumMap(TEnumMap<K, V> m) {
        this.keyType = m.keyType;
        this.data = Arrays.copyOf(m.data, m.data.length);
        this.provided = Arrays.copyOf(m.provided, m.provided.length);
        this.size = m.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.provided[i] || !Objects.equals(value, this.data[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.keyType.isInstance(key)) {
            return false;
        }
        int index = ((Enum)key).ordinal();
        return this.provided[index];
    }

    @Override
    public V get(Object key) {
        if (!this.keyType.isInstance(key)) {
            return null;
        }
        int index = ((Enum)key).ordinal();
        Object value = this.data[index];
        return (V)value;
    }

    @Override
    public V put(K key, V value) {
        int index = ((Enum)key).ordinal();
        Object old = this.data[index];
        if (!this.provided[index]) {
            this.provided[index] = true;
            ++this.size;
        }
        this.data[index] = value;
        return (V)old;
    }

    @Override
    public V remove(Object key) {
        if (!this.keyType.isInstance(key)) {
            return null;
        }
        int index = ((Enum)key).ordinal();
        Object old = this.data[index];
        if (this.provided[index]) {
            this.provided[index] = false;
            this.data[index] = null;
            --this.size;
        }
        return (V)old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            int index = ((Enum)entry.getKey()).ordinal();
            if (!this.provided[index]) {
                this.provided[index] = true;
                ++this.size;
            }
            this.data[index] = entry.getValue();
        }
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            this.size = 0;
            Arrays.fill(this.provided, false);
            Arrays.fill(this.data, null);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        int index;
                        int removeIndex = -1;
                        {
                            this.find();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.index < TEnumMap.this.data.length;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.index >= TEnumMap.this.data.length) {
                                throw new NoSuchElementException();
                            }
                            this.removeIndex = this.index;
                            EntryImpl result = new EntryImpl(this.index++);
                            this.find();
                            return result;
                        }

                        private void find() {
                            while (this.index < TEnumMap.this.provided.length && !TEnumMap.this.provided[this.index]) {
                                ++this.index;
                            }
                        }

                        @Override
                        public void remove() {
                            if (this.removeIndex < 0) {
                                throw new IllegalStateException();
                            }
                            ((TEnumMap)TEnumMap.this).data[this.removeIndex] = null;
                            ((TEnumMap)TEnumMap.this).provided[this.removeIndex] = false;
                            TEnumMap.this.size--;
                            this.removeIndex = -1;
                        }
                    };
                }

                @Override
                public int size() {
                    return TEnumMap.this.size;
                }

                @Override
                public boolean remove(Object o) {
                    if (!TEnumMap.this.keyType.isInstance(o)) {
                        return false;
                    }
                    int index = ((Enum)o).ordinal();
                    if (TEnumMap.this.provided[index]) {
                        ((TEnumMap)TEnumMap.this).provided[index] = false;
                        ((TEnumMap)TEnumMap.this).data[index] = null;
                        TEnumMap.this.size--;
                        return true;
                    }
                    return false;
                }

                @Override
                public void clear() {
                    TEnumMap.this.clear();
                }

                class EntryImpl
                implements Map.Entry<K, V> {
                    int index;

                    EntryImpl(int index) {
                        this.index = index;
                    }

                    @Override
                    public K getKey() {
                        return TGenericEnumSet.getConstants(TEnumMap.this.keyType)[this.index];
                    }

                    @Override
                    public V getValue() {
                        return TEnumMap.this.data[this.index];
                    }

                    @Override
                    public V setValue(V value) {
                        Object old = TEnumMap.this.data[this.index];
                        ((TEnumMap)TEnumMap.this).data[this.index] = value;
                        return old;
                    }
                }
            };
        }
        return this.entrySet;
    }
}

