/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.io.TSerializable;
import com.antgroup.antchain.myjava.classlib.java.util.TLocale;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class TCurrency
implements TSerializable {
    private static Map<String, TCurrency> currencies;
    private String currencyCode;
    private String symbol;
    private int defaultFractionDigits;
    private int numericCode;
    private String displayName;

    private TCurrency(String currencyCode, String symbol, int defaultFractionDigits, int numericCode, String displayName) {
        this.currencyCode = currencyCode;
        this.symbol = symbol;
        this.defaultFractionDigits = defaultFractionDigits;
        this.numericCode = numericCode;
        this.displayName = displayName;
    }

    private static void initCurrencies() {
        if (currencies != null) {
            return;
        }
        currencies = new HashMap<String, TCurrency>();
        TCurrency usd = new TCurrency("USD", "$", 2, 840, "US Dollar");
        currencies.put(usd.currencyCode, usd);
    }

    public static TCurrency getInstance(String currencyCode) {
        if (currencyCode == null) {
            throw new NullPointerException();
        }
        TCurrency.initCurrencies();
        TCurrency currency = currencies.get(currencyCode);
        if (currency == null) {
            throw new IllegalArgumentException("Currency not found: " + currencyCode);
        }
        return currency;
    }

    public static TCurrency getInstance(TLocale locale) {
        if (Locale.US.equals(locale)) {
            return TCurrency.getInstance("USD");
        }
        throw new RuntimeException("can't get currency in WASM(only en_US locale currency support)");
    }

    public static Set<TCurrency> getAvailableCurrencies() {
        TCurrency.initCurrencies();
        return new HashSet<TCurrency>(currencies.values());
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getSymbol(TLocale locale) {
        return this.symbol;
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayName(TLocale locale) {
        return this.displayName;
    }

    public String toString() {
        return this.currencyCode;
    }
}

