/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio.charset.impl;

import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharset;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCoderResult;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.impl.TBufferedDecoder;

public class TUTF16Decoder
extends TBufferedDecoder {
    private boolean bom;
    private boolean littleEndian;

    public TUTF16Decoder(TCharset cs, boolean bom, boolean littleEndian) {
        super(cs, 0.5f, 0.5f);
        this.bom = bom;
        this.littleEndian = littleEndian;
    }

    @Override
    protected TCoderResult arrayDecode(byte[] inArray, int inPos, int inSize, char[] outArray, int outPos, int outSize, TBufferedDecoder.Controller controller) {
        if (this.bom) {
            byte b;
            if (inPos + 2 > inSize) {
                return controller.hasMoreInput() ? null : TCoderResult.UNDERFLOW;
            }
            this.bom = false;
            if ((b = inArray[inPos++]) == -1) {
                if (inArray[inPos] == -2) {
                    ++inPos;
                    this.littleEndian = true;
                } else {
                    --inPos;
                }
            } else if (b == -2) {
                if (inArray[inPos] == -1) {
                    ++inPos;
                    this.littleEndian = false;
                } else {
                    --inPos;
                }
            } else {
                --inPos;
            }
        }
        return this.littleEndian ? this.decodeLE(inArray, inPos, inSize, outArray, outPos, outSize, controller) : this.decodeBE(inArray, inPos, inSize, outArray, outPos, outSize, controller);
    }

    private TCoderResult decodeLE(byte[] inArray, int inPos, int inSize, char[] outArray, int outPos, int outSize, TBufferedDecoder.Controller controller) {
        TCoderResult result = null;
        while (inPos < inSize && outPos < outSize) {
            int b2;
            int b1;
            char c;
            if (inPos + 2 > inSize) {
                if (controller.hasMoreInput(2)) break;
                result = TCoderResult.UNDERFLOW;
                break;
            }
            if (Character.isHighSurrogate(c = (char)((b1 = inArray[inPos++] & 0xFF) | (b2 = inArray[inPos++] & 0xFF) << 8))) {
                char next;
                if (inPos + 2 >= inSize) {
                    if (!controller.hasMoreInput(4)) {
                        result = TCoderResult.UNDERFLOW;
                    }
                    inPos -= 2;
                    break;
                }
                if (!Character.isLowSurrogate(next = (char)((b1 = inArray[inPos++] & 0xFF) | (b2 = inArray[inPos++] & 0xFF) << 8))) {
                    inPos -= 4;
                    result = TCoderResult.malformedForLength(4);
                    break;
                }
                if (outPos + 2 > outSize) {
                    if (controller.hasMoreOutput(2)) break;
                    result = TCoderResult.OVERFLOW;
                    break;
                }
                outArray[outPos++] = c;
                outArray[outPos++] = next;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                inPos -= 2;
                result = TCoderResult.malformedForLength(2);
                break;
            }
            outArray[outPos++] = c;
        }
        controller.setInPosition(inPos);
        controller.setOutPosition(outPos);
        return result;
    }

    private TCoderResult decodeBE(byte[] inArray, int inPos, int inSize, char[] outArray, int outPos, int outSize, TBufferedDecoder.Controller controller) {
        TCoderResult result = null;
        while (inPos < inSize && outPos < outSize) {
            int b1;
            int b2;
            char c;
            if (inPos + 2 > inSize) {
                if (controller.hasMoreInput(2)) break;
                result = TCoderResult.UNDERFLOW;
                break;
            }
            if (Character.isHighSurrogate(c = (char)((b2 = inArray[inPos++] & 0xFF) | (b1 = inArray[inPos++] & 0xFF) << 8))) {
                char next;
                if (inPos + 2 >= inSize) {
                    if (!controller.hasMoreInput(4)) {
                        result = TCoderResult.UNDERFLOW;
                    }
                    inPos -= 2;
                    break;
                }
                if (!Character.isLowSurrogate(next = (char)((b2 = inArray[inPos++] & 0xFF) | (b1 = inArray[inPos++] & 0xFF) << 8))) {
                    inPos -= 4;
                    result = TCoderResult.malformedForLength(4);
                    break;
                }
                if (outPos + 2 > outSize) {
                    if (controller.hasMoreOutput(2)) break;
                    result = TCoderResult.OVERFLOW;
                    break;
                }
                outArray[outPos++] = c;
                outArray[outPos++] = next;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                inPos -= 2;
                result = TCoderResult.malformedForLength(2);
                break;
            }
            outArray[outPos++] = c;
        }
        controller.setInPosition(inPos);
        controller.setOutPosition(outPos);
        return result;
    }
}

