/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio.charset.impl;

import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharset;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCoderResult;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.impl.TBufferedEncoder;
import com.antgroup.antchain.myjava.interop.NoMetadata;

@NoMetadata
public class TIso8859Encoder
extends TBufferedEncoder {
    public TIso8859Encoder(TCharset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected TCoderResult arrayEncode(char[] inArray, int inPos, int inSize, byte[] outArray, int outPos, int outSize, TBufferedEncoder.Controller controller) {
        TCoderResult result = null;
        while (inPos < inSize && outPos < outSize) {
            char c;
            if (Character.isHighSurrogate(c = inArray[inPos++])) {
                if (inPos == inSize) {
                    if (!controller.hasMoreInput(2)) {
                        result = TCoderResult.UNDERFLOW;
                        break;
                    }
                    --inPos;
                    break;
                }
                char next = inArray[inPos];
                if (!Character.isLowSurrogate(next)) {
                    result = TCoderResult.malformedForLength(1);
                    break;
                }
                --inPos;
                result = TCoderResult.unmappableForLength(2);
                break;
            }
            if (Character.isLowSurrogate(c)) {
                result = TCoderResult.malformedForLength(1);
            }
            if (c < '\u0100') {
                outArray[outPos++] = (byte)c;
                continue;
            }
            --inPos;
            result = TCoderResult.unmappableForLength(1);
            break;
        }
        controller.setInPosition(inPos);
        controller.setOutPosition(outPos);
        return result;
    }
}

