/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio;

import com.antgroup.antchain.myjava.classlib.java.nio.TBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TBufferOverflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TBufferUnderflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TByteOrder;
import com.antgroup.antchain.myjava.classlib.java.nio.TReadOnlyBufferException;
import com.antgroup.antchain.myjava.classlib.java.nio.TShortBufferOverArray;
import com.antgroup.antchain.myjava.interop.NoMetadata;

@NoMetadata
public abstract class TShortBuffer
extends TBuffer
implements Comparable<TShortBuffer> {
    TShortBuffer(int capacity, int position, int limit) {
        super(capacity);
        this.position = position;
        this.limit = limit;
    }

    public static TShortBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        return new TShortBufferOverArray(capacity);
    }

    public static TShortBuffer wrap(short[] array, int offset, int length) {
        return new TShortBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TShortBuffer wrap(short[] array) {
        return TShortBuffer.wrap(array, 0, array.length);
    }

    public abstract TShortBuffer slice();

    public abstract TShortBuffer duplicate();

    public abstract TShortBuffer asReadOnlyBuffer();

    public abstract short get();

    public abstract TShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract TShortBuffer put(int var1, short var2);

    abstract short getElement(int var1);

    abstract void putElement(int var1, short var2);

    public TShortBuffer get(short[] dst, int offset, int length) {
        if (offset < 0 || offset >= dst.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + dst.length + ")");
        }
        if (offset + length > dst.length) {
            throw new IndexOutOfBoundsException("The last short in dst " + (offset + length) + " is outside of array of size " + dst.length);
        }
        if (this.remaining() < length) {
            throw new TBufferUnderflowException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            dst[offset++] = this.getElement(pos++);
        }
        this.position += length;
        return this;
    }

    public TShortBuffer get(short[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TShortBuffer put(TShortBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < src.remaining()) {
            throw new TBufferOverflowException();
        }
        int length = src.remaining();
        int pos = this.position;
        int offset = src.position;
        for (int i = 0; i < length; ++i) {
            this.putElement(pos++, src.getElement(offset++));
        }
        this.position += length;
        return this;
    }

    public TShortBuffer put(short[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (offset < 0 || offset >= src.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + src.length + ")");
        }
        if (offset + length > src.length) {
            throw new IndexOutOfBoundsException("The last short in src " + (offset + length) + " is outside of array of size " + src.length);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            this.putElement(pos++, src[offset++]);
        }
        this.position += length;
        return this;
    }

    public final TShortBuffer put(short[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final short[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract short[] getArray();

    abstract int getArrayOffset();

    public abstract TShortBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[ShortBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity + ", mark " + (this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            hashCode = 31 * hashCode + this.getElement(pos++);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TShortBuffer)) {
            return false;
        }
        TShortBuffer other = (TShortBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getElement(a++) == other.getElement(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TShortBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Short.compare(this.getElement(a++), other.getElement(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public abstract TByteOrder order();

    @Override
    public final TShortBuffer mark() {
        super.mark();
        return this;
    }

    @Override
    public final TShortBuffer reset() {
        super.reset();
        return this;
    }

    @Override
    public final TShortBuffer clear() {
        super.clear();
        return this;
    }

    @Override
    public final TShortBuffer flip() {
        super.flip();
        return this;
    }

    @Override
    public final TShortBuffer rewind() {
        super.rewind();
        return this;
    }

    @Override
    public TShortBuffer limit(int newLimit) {
        super.limit(newLimit);
        return this;
    }

    @Override
    public TShortBuffer position(int newPosition) {
        super.position(newPosition);
        return this;
    }
}

