/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.net;

import com.antgroup.antchain.myjava.classlib.java.net.TProtocolException;
import com.antgroup.antchain.myjava.classlib.java.net.TURL;
import com.antgroup.antchain.myjava.classlib.java.net.TURLConnection;
import java.io.IOException;
import java.io.InputStream;

public abstract class THttpURLConnection
extends TURLConnection {
    private String[] methodTokens = new String[]{"GET", "DELETE", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
    protected String method = "GET";
    protected int responseCode = -1;
    protected String responseMessage;
    protected boolean instanceFollowRedirects = followRedirects;
    private static boolean followRedirects = true;
    protected int chunkLength = -1;
    protected int fixedContentLength = -1;
    private static final int DEFAULT_CHUNK_LENGTH = 1024;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_OK = 200;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_SEE_OTHER = 303;
    @Deprecated
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_VERSION = 505;

    protected THttpURLConnection(TURL url) {
        super(url);
    }

    public abstract void disconnect();

    public InputStream getErrorStream() {
        return null;
    }

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        this.connect();
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        this.connect();
        return this.responseMessage;
    }

    public static void setFollowRedirects(boolean auto) {
        followRedirects = auto;
    }

    public void setRequestMethod(String method) throws TProtocolException {
        if (this.connected) {
            throw new TProtocolException();
        }
        for (int i = 0; i < this.methodTokens.length; ++i) {
            if (!this.methodTokens[i].equals(method)) continue;
            this.method = this.methodTokens[i];
            return;
        }
        throw new TProtocolException();
    }

    public boolean getInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.instanceFollowRedirects = followRedirects;
    }

    @Override
    public long getHeaderFieldDate(String field, long defaultValue) {
        return super.getHeaderFieldDate(field, defaultValue);
    }

    public void setFixedLengthStreamingMode(int contentLength) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        if (0 < this.chunkLength) {
            throw new IllegalStateException();
        }
        if (0 > contentLength) {
            throw new IllegalArgumentException();
        }
        this.fixedContentLength = contentLength;
    }

    public void setChunkedStreamingMode(int chunklen) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        if (0 <= this.fixedContentLength) {
            throw new IllegalStateException();
        }
        this.chunkLength = 0 >= chunklen ? 1024 : chunklen;
    }
}

