/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.io;

import java.io.IOException;
import java.io.Writer;

public class TStringWriter
extends Writer {
    private StringBuffer buf;

    public TStringWriter() {
        this.buf = new StringBuffer(16);
        this.lock = this.buf;
    }

    public TStringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new StringBuffer(initialSize);
        this.lock = this.buf;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() {
    }

    public StringBuffer getBuffer() {
        return this.buf;
    }

    public String toString() {
        return this.buf.toString();
    }

    @Override
    public void write(char[] cbuf, int offset, int count) {
        if (offset < 0 || offset > cbuf.length || count < 0 || count > cbuf.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.buf.append(cbuf, offset, count);
    }

    @Override
    public void write(int oneChar) {
        this.buf.append((char)oneChar);
    }

    @Override
    public void write(String str) {
        this.buf.append(str);
    }

    @Override
    public void write(String str, int offset, int count) {
        String sub = str.substring(offset, offset + count);
        this.buf.append(sub);
    }

    @Override
    public TStringWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public TStringWriter append(CharSequence csq) {
        if (null == csq) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public TStringWriter append(CharSequence csq, int start, int end) {
        if (null == csq) {
            csq = "null";
        }
        String output = csq.subSequence(start, end).toString();
        this.write(output, 0, output.length());
        return this;
    }
}

