/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.io;

import com.antgroup.antchain.myjava.classlib.java.io.TFileFilter;
import com.antgroup.antchain.myjava.classlib.java.io.TFilenameFilter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class TFile
implements Serializable,
Comparable<TFile> {
    private String path;
    public static final String pathSeparator = ":";
    public static final char pathSeparatorChar = ':';
    public static final char separatorChar = '/';
    public static final String separator = "/";

    public TFile(TFile dir, String name) {
        Objects.requireNonNull(name);
        this.path = dir == null ? TFile.fixSlashes(name) : TFile.calculatePath(dir.getPath(), name);
    }

    public TFile(String path) {
        Objects.requireNonNull(path);
        this.path = TFile.fixSlashes(path);
    }

    public TFile(String dir, String name) {
        Objects.requireNonNull(name);
        this.path = dir == null ? TFile.fixSlashes(name) : TFile.calculatePath(dir, name);
    }

    public TFile(URI uri) {
        this.checkURI(uri);
        String path = uri.getPath();
        this.path = TFile.fixSlashes(path);
    }

    private void checkURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        if (!uri.getRawSchemeSpecificPart().startsWith(separator)) {
            throw new IllegalArgumentException();
        }
        String temp = uri.getScheme();
        if (temp == null || !temp.equals("file")) {
            throw new IllegalArgumentException();
        }
        temp = uri.getRawPath();
        if (temp == null || temp.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (uri.getRawAuthority() != null) {
            throw new IllegalArgumentException();
        }
        if (uri.getRawQuery() != null) {
            throw new IllegalArgumentException();
        }
        if (uri.getRawFragment() != null) {
            throw new IllegalArgumentException();
        }
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    @Override
    public int compareTo(TFile o) {
        return this.path.compareTo(o.path);
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        int separatorIndex = this.path.lastIndexOf(separator);
        return separatorIndex < 0 ? this.path : this.path.substring(separatorIndex + 1, this.path.length());
    }

    public String getAbsolutePath() {
        return this.path;
    }

    public TFile getAbsoluteFile() {
        return new TFile(this.getAbsolutePath());
    }

    public boolean isAbsolute() {
        return this.isAbsolutePath(this.path);
    }

    private boolean isAbsolutePath(String path) {
        return !path.isEmpty() && path.charAt(0) == '/';
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    public boolean isFile() {
        return false;
    }

    public String getCanonicalPath() throws IOException {
        return this.path;
    }

    public TFile getCanonicalFile() throws IOException {
        return new TFile(this.getCanonicalPath());
    }

    public String getParent() {
        int length = this.path.length();
        int index = this.path.lastIndexOf(47);
        if (index == -1 || this.path.charAt(length - 1) == '/') {
            return null;
        }
        if (this.path.indexOf(47) == index && (this.isAbsolutePath(this.path) || index == 0)) {
            return this.path.substring(0, index + 1);
        }
        return this.path.substring(0, index);
    }

    public TFile getParentFile() {
        String path = this.getParent();
        return path != null ? new TFile(this.getParent()) : null;
    }

    public static TFile[] listRoots() {
        return new TFile[]{new TFile(separator)};
    }

    public String[] list() {
        return null;
    }

    public String[] list(TFilenameFilter filter) {
        return null;
    }

    public TFile[] listFiles() {
        return null;
    }

    public TFile[] listFiles(TFileFilter filter) {
        return null;
    }

    public TFile[] listFiles(TFilenameFilter filter) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public boolean setLastModified(long time) {
        return false;
    }

    public boolean setReadOnly() {
        return false;
    }

    public boolean setWritable(boolean writable) {
        return false;
    }

    public long length() {
        return 0L;
    }

    public boolean createNewFile() throws IOException {
        throw new IOException("can't create file in WASM");
    }

    public boolean mkdir() {
        return false;
    }

    public boolean mkdirs() {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public void deleteOnExit() {
    }

    public boolean renameTo(TFile dest) {
        return false;
    }

    public URI toURI() {
        String name = this.getAbsoluteName();
        try {
            if (!name.startsWith(separator)) {
                return new URI("file", null, separator + name, null, null);
            }
            if (name.startsWith("//")) {
                return new URI("file", "", name, null);
            }
            return new URI("file", null, name, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String getAbsoluteName() {
        TFile f = this.getAbsoluteFile();
        String name = f.getPath();
        if (f.isDirectory() && name.charAt(name.length() - 1) != '/') {
            name = new StringBuilder(name.length() + 1).append(name).append('/').toString();
        }
        return name;
    }

    public static TFile createTempFile(String prefix, String suffix) throws IOException {
        return TFile.createTempFile(prefix, suffix, null);
    }

    public static TFile createTempFile(String prefix, String suffix, TFile directory) throws IOException {
        throw new IOException("can't createTempFile in WASM");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TFile)) {
            return false;
        }
        return this.path.equals(((File)obj).getPath());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    private static String fixSlashes(String origPath) {
        int length = origPath.length();
        int newLength = 0;
        boolean foundSlash = false;
        char[] newPath = origPath.toCharArray();
        for (int i = 0; i < length; ++i) {
            char pathChar = newPath[i];
            if (pathChar == '/' || pathChar == '/') {
                if (foundSlash && i != 0) continue;
                newPath[newLength++] = 47;
                foundSlash = true;
                continue;
            }
            newPath[newLength++] = pathChar;
            foundSlash = false;
        }
        if (foundSlash && (newLength > 1 || newPath[0] != '/')) {
            --newLength;
        }
        return new String(newPath, 0, newLength);
    }

    private static String calculatePath(String dirPath, String name) {
        dirPath = TFile.fixSlashes(dirPath);
        if (!name.isEmpty() || dirPath.isEmpty()) {
            int separatorIndex;
            name = TFile.fixSlashes(name);
            for (separatorIndex = 0; separatorIndex < name.length() && name.charAt(separatorIndex) == '/'; ++separatorIndex) {
            }
            if (separatorIndex > 0) {
                name = name.substring(separatorIndex);
            }
            if (!dirPath.isEmpty() && dirPath.charAt(dirPath.length() - 1) == '/') {
                return dirPath + name;
            }
            return dirPath + '/' + name;
        }
        return dirPath;
    }

    private boolean isRoot(String path) {
        return path.equals(separator);
    }
}

