/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

public final class IntegerUtil {
    private IntegerUtil() {
    }

    public static String toUnsignedLogRadixString(int value, int radixLog2) {
        if (value == 0) {
            return "0";
        }
        int radix = 1 << radixLog2;
        int mask = radix - 1;
        int sz = (32 - Integer.numberOfLeadingZeros(value) + radixLog2 - 1) / radixLog2;
        char[] chars = new char[sz];
        int target = 0;
        for (int pos = (sz - 1) * radixLog2; pos >= 0; pos -= radixLog2) {
            chars[target++] = Character.forDigit(value >>> pos & mask, radix);
        }
        return new String(chars);
    }

    public static String toUnsignedLogRadixString(long value, int radixLog2) {
        if (value == 0L) {
            return "0";
        }
        int radix = 1 << radixLog2;
        int mask = radix - 1;
        int sz = (64 - Long.numberOfLeadingZeros(value) + radixLog2 - 1) / radixLog2;
        char[] chars = new char[sz];
        int target = 0;
        for (int pos = (sz - 1) * radixLog2; pos >= 0; pos -= radixLog2) {
            chars[target++] = Character.forDigit((int)(value >>> pos) & mask, radix);
        }
        return new String(chars);
    }
}

