/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl;

import com.antgroup.antchain.myjava.dependency.AbstractDependencyListener;
import com.antgroup.antchain.myjava.dependency.DependencyAgent;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.model.ClassReader;

public class DeclaringClassDependencyListener
extends AbstractDependencyListener {
    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (method.getReference().getClassName().equals("java.lang.Class")) {
            switch (method.getReference().getName()) {
                case "getEnclosingClass": {
                    method.getVariable(0).getClassValueNode().addConsumer(t -> {
                        ClassReader cls = agent.getClassSource().get(t.getName());
                        if (cls != null && cls.getOwnerName() != null) {
                            agent.linkClass(cls.getOwnerName());
                        }
                    });
                    break;
                }
                case "getDeclaringClass": {
                    method.getVariable(0).getClassValueNode().addConsumer(t -> {
                        ClassReader cls = agent.getClassSource().get(t.getName());
                        if (cls != null && cls.getDeclaringClassName() != null) {
                            agent.linkClass(cls.getDeclaringClassName());
                        }
                    });
                }
            }
        }
    }
}

