/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.cache;

import com.antgroup.antchain.myjava.ast.AsyncMethodNode;
import com.antgroup.antchain.myjava.ast.ControlFlowEntry;
import com.antgroup.antchain.myjava.ast.RegularMethodNode;
import com.antgroup.antchain.myjava.cache.AstCacheEntry;
import com.antgroup.antchain.myjava.cache.AstIO;
import com.antgroup.antchain.myjava.cache.CacheStatus;
import com.antgroup.antchain.myjava.cache.FileNameEncoder;
import com.antgroup.antchain.myjava.cache.MethodNodeCache;
import com.antgroup.antchain.myjava.cache.SymbolTable;
import com.antgroup.antchain.myjava.cache.VarDataInput;
import com.antgroup.antchain.myjava.cache.VarDataOutput;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ReferenceCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class DiskMethodNodeCache
implements MethodNodeCache {
    private final File directory;
    private final AstIO astIO;
    private final Map<MethodReference, Item> cache = new HashMap<MethodReference, Item>();
    private final Map<MethodReference, AsyncItem> asyncCache = new HashMap<MethodReference, AsyncItem>();
    private final Set<MethodReference> newMethods = new HashSet<MethodReference>();
    private final Set<MethodReference> newAsyncMethods = new HashSet<MethodReference>();

    public DiskMethodNodeCache(File directory, ReferenceCache referenceCache, SymbolTable symbolTable, SymbolTable fileTable, SymbolTable variableTable) {
        this.directory = directory;
        this.astIO = new AstIO(referenceCache, symbolTable, fileTable, variableTable);
    }

    @Override
    public AstCacheEntry get(MethodReference methodReference, CacheStatus cacheStatus) {
        Item item = this.cache.get(methodReference);
        if (item == null) {
            item = new Item();
            this.cache.put(methodReference, item);
            File file = this.getMethodFile(methodReference, false);
            if (file.exists()) {
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    VarDataInput input = new VarDataInput(stream);
                    if (!this.checkIfDependenciesChanged(input, cacheStatus)) {
                        RegularMethodNode node = this.astIO.read(input, methodReference);
                        ControlFlowEntry[] cfg = this.astIO.readControlFlow(input);
                        item.entry = new AstCacheEntry(node, cfg);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return item.entry;
    }

    @Override
    public void store(MethodReference methodReference, AstCacheEntry entry, Supplier<String[]> dependencies) {
        Item item = new Item();
        item.entry = entry;
        item.dependencies = (String[])dependencies.get().clone();
        this.cache.put(methodReference, item);
        this.newMethods.add(methodReference);
    }

    @Override
    public AsyncMethodNode getAsync(MethodReference methodReference, CacheStatus cacheStatus) {
        AsyncItem item = this.asyncCache.get(methodReference);
        if (item == null) {
            item = new AsyncItem();
            this.asyncCache.put(methodReference, item);
            File file = this.getMethodFile(methodReference, true);
            if (file.exists()) {
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    VarDataInput input = new VarDataInput(stream);
                    if (!this.checkIfDependenciesChanged(input, cacheStatus)) {
                        item.node = this.astIO.readAsync(input, methodReference);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return item.node;
    }

    private boolean checkIfDependenciesChanged(VarDataInput input, CacheStatus cacheStatus) throws IOException {
        int depCount = input.readUnsigned();
        for (int i = 0; i < depCount; ++i) {
            String depClass = input.read();
            if (!cacheStatus.isStaleClass(depClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void storeAsync(MethodReference methodReference, AsyncMethodNode node, Supplier<String[]> depenencies) {
        AsyncItem item = new AsyncItem();
        item.node = node;
        item.dependencies = (String[])depenencies.get().clone();
        this.asyncCache.put(methodReference, item);
        this.newAsyncMethods.add(methodReference);
    }

    public void flush() throws IOException {
        VarDataOutput output;
        Object item;
        File file;
        for (MethodReference method : this.newMethods) {
            file = this.getMethodFile(method, true);
            item = this.cache.get(method);
            output = new VarDataOutput(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                output.writeUnsigned(((Item)item).dependencies.length);
                for (String dependency : ((Item)item).dependencies) {
                    output.write(dependency);
                }
                this.astIO.write(output, ((Item)item).entry.method);
                this.astIO.write(output, ((Item)item).entry.cfg);
            }
            finally {
                output.close();
            }
        }
        for (MethodReference method : this.newAsyncMethods) {
            file = this.getMethodFile(method, true);
            item = this.asyncCache.get(method);
            output = new VarDataOutput(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                output.writeUnsigned(((AsyncItem)item).dependencies.length);
                for (String dependency : ((AsyncItem)item).dependencies) {
                    output.write(dependency);
                }
                this.astIO.writeAsync(output, ((AsyncItem)item).node);
            }
            finally {
                output.close();
            }
        }
    }

    private File getMethodFile(MethodReference method, boolean async) {
        File dir = new File(this.directory, method.getClassName().replace('.', '/'));
        return new File(dir, FileNameEncoder.encodeFileName(method.getDescriptor().toString()) + ".teavm-ast" + (async ? "-async" : ""));
    }

    private static class AsyncItem {
        AsyncMethodNode node;
        String[] dependencies;

        private AsyncItem() {
        }
    }

    private static class Item {
        AstCacheEntry entry;
        String[] dependencies;

        private Item() {
        }
    }
}

