/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.optimization;

import com.antgroup.antchain.myjava.backend.wasm.model.WasmFunction;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmModule;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmDefaultExpressionVisitor;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpressionVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class UnusedFunctionElimination {
    private WasmModule module;
    private Set<WasmFunction> usedFunctions = new HashSet<WasmFunction>();
    private Set<WasmFunction> manuallyLinkMethods = new HashSet<WasmFunction>();
    private WasmExpressionVisitor visitor = new WasmDefaultExpressionVisitor(){

        @Override
        public void visit(WasmCall expression) {
            super.visit(expression);
            WasmFunction function = UnusedFunctionElimination.this.module.getFunctions().get(expression.getFunctionName());
            if (function != null) {
                UnusedFunctionElimination.this.use(function);
            }
        }
    };

    public UnusedFunctionElimination(WasmModule module, Set<WasmFunction> manuallyLinkMethods) {
        this.module = module;
        this.manuallyLinkMethods = manuallyLinkMethods;
    }

    public void apply() {
        List exported = this.module.getFunctions().values().stream().filter(function -> function.getExportName() != null).collect(Collectors.toList());
        for (WasmFunction function2 : exported) {
            this.use(function2);
        }
        for (WasmFunction function2 : this.module.getFunctionTable()) {
            this.use(function2);
        }
        for (WasmFunction function2 : this.manuallyLinkMethods) {
            this.use(function2);
        }
        if (this.module.getStartFunction() != null) {
            this.use(this.module.getStartFunction());
        }
        for (Iterator<Object> iterator : this.module.getFunctions().values().toArray(new WasmFunction[0])) {
            if (this.usedFunctions.contains(iterator)) continue;
            this.module.remove((WasmFunction)((Object)iterator));
        }
    }

    private void use(WasmFunction function) {
        if (!this.usedFunctions.add(function)) {
            return;
        }
        for (WasmExpression part : function.getBody()) {
            part.acceptVisitor(this.visitor);
        }
    }
}

