/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.model.expression;

import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpressionVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WasmCall
extends WasmExpression {
    private String functionName;
    private boolean imported;
    private List<WasmExpression> arguments = new ArrayList<WasmExpression>();

    public WasmCall(String functionName, boolean imported) {
        Objects.requireNonNull(functionName);
        this.functionName = functionName;
        this.imported = imported;
    }

    public WasmCall(String functionName) {
        this(functionName, false);
    }

    public WasmCall(String functionName, WasmExpression ... arguments) {
        this(functionName);
        this.getArguments().addAll(Arrays.asList(arguments));
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        Objects.requireNonNull(functionName);
        this.functionName = functionName;
    }

    public List<WasmExpression> getArguments() {
        return this.arguments;
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    @Override
    public void acceptVisitor(WasmExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

