/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.javautils;

import com.antgroup.antchain.myjava.backend.wasm.javautils.AbiParamTypeException;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.runtime.Identity;

public class MyContractAbiUtils {
    public static final String contractInterfaceExportNamePrefix = "my_";

    private MyContractAbiUtils() {
    }

    public static boolean isStringValueType(ValueType valueType) {
        String valueTypeSig = valueType.toString();
        return valueType.isObject(String.class) || valueTypeSig.equals("Ljava/lang/String;");
    }

    public static boolean isStringArrayValueType(ValueType valueType) {
        return valueType.isArray(String[].class);
    }

    public static boolean isIntValueType(ValueType valueType) {
        String valueTypeSig = valueType.toString();
        return valueTypeSig.equals("I");
    }

    public static boolean isLongValueType(ValueType valueType) {
        String valueTypeSig = valueType.toString();
        return valueTypeSig.equals("J");
    }

    public static boolean isByteValueType(ValueType valueType) {
        String valueTypeSig = valueType.toString();
        return valueTypeSig.equals("B");
    }

    public static boolean isCharValueType(ValueType valueType) {
        String valueTypeSig = valueType.toString();
        return valueTypeSig.equals("C");
    }

    public static boolean isBooleanValueType(ValueType valueType) {
        String valueTypeSig = valueType.toString();
        return valueTypeSig.equals("Z");
    }

    public static boolean isIntArrayValueType(ValueType valueType) {
        return valueType.isArray(int[].class);
    }

    public static boolean isLongArrayValueType(ValueType valueType) {
        return valueType.isArray(long[].class);
    }

    public static boolean isByteArrayValueType(ValueType valueType) {
        return valueType.isArray(byte[].class);
    }

    public static boolean isCharArrayValueType(ValueType valueType) {
        return valueType.isArray(char[].class);
    }

    public static boolean isBooleanArrayValueType(ValueType valueType) {
        return valueType.isArray(boolean[].class);
    }

    public static boolean isIdentityValueType(ValueType valueType) {
        return valueType.isObject(Identity.class);
    }

    public static boolean isIdentityArrayValueType(ValueType valueType) {
        return valueType.isArray(Identity[].class);
    }

    public static boolean isVoidValueType(ValueType valueType) {
        return valueType == null || valueType.toString().equals("V");
    }

    public static String valueTypeToAbiTypeName(ValueType valueType) throws AbiParamTypeException {
        String valueTypeSig = valueType.toString();
        if (MyContractAbiUtils.isStringValueType(valueType)) {
            return "string";
        }
        if (MyContractAbiUtils.isStringArrayValueType(valueType)) {
            return "string[]";
        }
        if (MyContractAbiUtils.isIntValueType(valueType)) {
            return "int32";
        }
        if (MyContractAbiUtils.isLongValueType(valueType)) {
            return "int64";
        }
        if (MyContractAbiUtils.isByteValueType(valueType) || MyContractAbiUtils.isCharValueType(valueType)) {
            return "int8";
        }
        if (MyContractAbiUtils.isBooleanValueType(valueType)) {
            return "bool";
        }
        if (MyContractAbiUtils.isIntArrayValueType(valueType)) {
            return "int32[]";
        }
        if (MyContractAbiUtils.isLongArrayValueType(valueType)) {
            return "int64[]";
        }
        if (MyContractAbiUtils.isByteArrayValueType(valueType) || MyContractAbiUtils.isCharArrayValueType(valueType)) {
            return "int8[]";
        }
        if (MyContractAbiUtils.isBooleanArrayValueType(valueType)) {
            return "bool[]";
        }
        if (MyContractAbiUtils.isIdentityValueType(valueType)) {
            return "identity";
        }
        if (MyContractAbiUtils.isIdentityArrayValueType(valueType)) {
            return "identity[]";
        }
        if (MyContractAbiUtils.isVoidValueType(valueType)) {
            return null;
        }
        throw new AbiParamTypeException("not supported abi param type " + valueTypeSig);
    }
}

