/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.ast.InvocationType;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.runtime.ShadowStack;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

public class ShadowStackIntrinsic
implements WasmIntrinsic {
    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(ShadowStack.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "getStackTop": 
            case "getNextStackFrame": 
            case "getStackRootCount": 
            case "getStackRootPointer": 
            case "getCallSiteId": 
            case "setExceptionHandlerId": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        InvocationExpr expr = new InvocationExpr();
        MethodReference method = new MethodReference(WasmRuntime.class.getName(), invocation.getMethod().getDescriptor());
        expr.setMethod(method);
        expr.setType(InvocationType.SPECIAL);
        expr.getArguments().addAll(invocation.getArguments());
        return manager.generate(expr);
    }
}

