/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.WasmTarget;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.javautils.JavaByteArrayWasmExprPair;
import com.antgroup.antchain.myjava.backend.wasm.javautils.JavaStringWasmUtils;
import com.antgroup.antchain.myjava.backend.wasm.javautils.MyContractAbiInfo;
import com.antgroup.antchain.myjava.backend.wasm.javautils.MyContractAbiInfoInterface;
import com.antgroup.antchain.myjava.backend.wasm.javautils.MyContractAbiUtils;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBlock;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmConditional;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmDrop;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmGetLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmReturn;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmSetLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmUnreachable;
import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.runtime.Identity;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import com.antgroup.antchain.myjava.runtime.ParamsStream;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MychainLibIntrinsic
implements WasmIntrinsic {
    private static final Logger log = LoggerFactory.getLogger(MychainLibIntrinsic.class);
    private static final MethodReference REVERT = new MethodReference(WasmRuntime.class, "revert", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference ABORT = new MethodReference(WasmRuntime.class, "abort", Void.TYPE);
    private static final MethodReference REVERT_ABI_NOT_FOUND = new MethodReference(MychainLib.class, "revertAbiNotFound", String.class, Void.TYPE);
    private static final MethodReference SET_RETURN_VALUE = new MethodReference(WasmRuntime.class, "setReturnValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference READ_INTERFACE_NAME = new MethodReference(WasmRuntime.class, "readInterfaceName", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference READ_INTERFACE_PARAMS = new MethodReference(WasmRuntime.class, "readInterfaceParams", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference CHECK_ACCOUNT = new MethodReference(WasmRuntime.class, "checkAccount", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_BLOCK_HASH = new MethodReference(WasmRuntime.class, "getBlockHash", Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_ORIGIN = new MethodReference(WasmRuntime.class, "getOrigin", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_AUTH_MAP = new MethodReference(WasmRuntime.class, "getAuthMap", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_AUTH_MAP_IN_CACHE = new MethodReference(WasmRuntime.class, "getAuthMapInCache", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_BALANCE = new MethodReference(WasmRuntime.class, "getBalance", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_CODE = new MethodReference(WasmRuntime.class, "getCode", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_CODE_HASH = new MethodReference(WasmRuntime.class, "getCodeHash", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_RECOVER_KEY = new MethodReference(WasmRuntime.class, "getRecoverKey", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_TXHASH = new MethodReference(WasmRuntime.class, "getTxHash", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_ACCOUNT_STATUS = new MethodReference(WasmRuntime.class, "getAccountStatus", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference TRANSFER_BALANCE = new MethodReference(WasmRuntime.class, "transferBalance", Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE);
    private static final MethodReference LOG = new MethodReference(WasmRuntime.class, "log", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_DATA = new MethodReference(WasmRuntime.class, "getData", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_SENDER = new MethodReference(WasmRuntime.class, "getSender", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_SELF = new MethodReference(WasmRuntime.class, "getSelf", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_RELATED_TRANSACTION_LIST_SIZE = new MethodReference(WasmRuntime.class, "getRelatedTransactionListSize", Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_RELATED_TRANSACTION_LIST = new MethodReference(WasmRuntime.class, "getRelatedTransactionList", Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference READ_BUFFER = new MethodReference(WasmRuntime.class, "readBuffer", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_TRANSACTION = new MethodReference(WasmRuntime.class, "getTransaction", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_CONFIDENTIAL_DEPOSIT = new MethodReference(WasmRuntime.class, "getConfidentialDeposit", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference CREATE_CONTRACT = new MethodReference(WasmRuntime.class, "createContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference DIGEST = new MethodReference(WasmRuntime.class, "digest", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference VERIFY_RSA = new MethodReference(WasmRuntime.class, "verifyRsa2", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference BASE64_ENCODE = new MethodReference(WasmRuntime.class, "base64Encode", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference BASE64_DECODE = new MethodReference(WasmRuntime.class, "base64Decode", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference ECRECOVERY = new MethodReference(WasmRuntime.class, "ecrecovery", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference VERIFY_MESSAGE_SM2 = new MethodReference(WasmRuntime.class, "verifyMessageSM2", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference VERIFY_MESSAGE_ECCK1 = new MethodReference(WasmRuntime.class, "verifyMessageECCK1", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference VERIFY_MESSAGE_ECCR1 = new MethodReference(WasmRuntime.class, "verifyMessageECCR1", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference BELLMAN_SNARK_VERIFY = new MethodReference(WasmRuntime.class, "bellmanSnarkVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference RANGE_PROOF_VERIFY = new MethodReference(WasmRuntime.class, "rangeProofVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference ADD_PEDERSEN_COMMIT = new MethodReference(WasmRuntime.class, "addPedersenCommit", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference SUB_PEDERSEN_COMMIT = new MethodReference(WasmRuntime.class, "subPedersenCommit", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference CALCULATE_PEDERSEN_COMMIT = new MethodReference(WasmRuntime.class, "calculatePedersenCommit", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference PEDERSEN_COMMIT_EQUALITY_VERIFY = new MethodReference(WasmRuntime.class, "pedersenCommitEqualityVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference LIFTED_ELGAMAL_CONTRACT_HOMOMORPHIC_ADD = new MethodReference(WasmRuntime.class, "liftedElgamalContractHomomorphicAdd", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference LIFTED_ELGAMAL_CONTRACT_HOMOMORPHIC_SUB = new MethodReference(WasmRuntime.class, "liftedElgamalContractHomomorphicSub", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference LIFTED_ELGAMAL_SCALAR_MUTIPLY = new MethodReference(WasmRuntime.class, "liftedElgamalScalarMutiply", Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference LIFTED_ELGAMAL_CONTRACT_ZERO_CHECK_VERIFY = new MethodReference(WasmRuntime.class, "liftedElgamalContractZeroCheckVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference LIFTED_ELGAMAL_CONTRACT_RANGE_VERIFY = new MethodReference(WasmRuntime.class, "liftedElgamalContractRangeVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference SET_STORAGE = new MethodReference(WasmRuntime.class, "setStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_STORAGE_SIZE = new MethodReference(WasmRuntime.class, "getStorageSize", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_STORAGE = new MethodReference(WasmRuntime.class, "getStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference DELETE_STORAGE = new MethodReference(WasmRuntime.class, "deleteStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference RESULT = new MethodReference(WasmRuntime.class, "result", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GET_CALL_RESULT = new MethodReference(WasmRuntime.class, "getCallResult", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference READ_BUFFER_REF = new MethodReference(WasmRuntime.class, "readBufferRef", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference VERIFY_COMMITMENT = new MethodReference(WasmRuntime.class, "verifyCommitment", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference VERIFY_RANGE = new MethodReference(WasmRuntime.class, "verifyRange", Integer.TYPE, Long.TYPE, Integer.TYPE);
    private static final MethodReference VERIFY_BALANCE = new MethodReference(WasmRuntime.class, "verifyBalance", Integer.TYPE, Integer.TYPE);
    private static final MethodReference F_TRACE_BEGIN = new MethodReference(WasmRuntime.class, "fTraceBegin", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference DEPLOY_CONTRACT = new MethodReference(WasmRuntime.class, "deployContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference UPDATE_CONTRACT = new MethodReference(WasmRuntime.class, "updateContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference UPDATE_CONTRACT_STATUS = new MethodReference(WasmRuntime.class, "updateContractStatus", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference DC_GET_STORAGE_SIZE = new MethodReference(WasmRuntime.class, "dcGetStorageSize", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference DC_SET_STORAGE = new MethodReference(WasmRuntime.class, "dcSetStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference DC_DELETE_STORAGE = new MethodReference(WasmRuntime.class, "dcDeleteStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GRAYSCALE_DEPLOY_CONTRACT = new MethodReference(WasmRuntime.class, "grayscaleDeployContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference GRAYSCALE_VERIFICATION = new MethodReference(WasmRuntime.class, "grayscaleVerification", Integer.TYPE, Integer.TYPE);
    private static final MethodReference GRAYSCALE_VERSION_SWITCH_BACK = new MethodReference(WasmRuntime.class, "grayscaleVersionSwitchBack", Integer.TYPE, Integer.TYPE);
    private static final MethodReference GRAYSCALE_UPDATE_CONTRACT = new MethodReference(WasmRuntime.class, "grayscaleUpdateContract", Integer.TYPE, Integer.TYPE);
    private static final MethodReference CALL_CONTRACT = new MethodReference(WasmRuntime.class, "callContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference DC_SET_ACL = new MethodReference(WasmRuntime.class, "dcSetAcl", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final MethodReference CALL_EVM = new MethodReference(WasmRuntime.class, "callEvm", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE);

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(MychainLib.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "dispatchContractInterface": 
            case "revertRaw": 
            case "abort": 
            case "setReturnValue": 
            case "readInterfaceNameBytes": 
            case "readInterfaceParamsBytes": 
            case "checkAccountBytes": 
            case "getBlockHashBytes": 
            case "getOriginBytes": 
            case "getAuthMapBytes": 
            case "getAuthMapInCacheBytes": 
            case "getBalanceBytes": 
            case "getCodeBytes": 
            case "getCodeHashBytes": 
            case "getRecoverKeyBytes": 
            case "getAccountStatusBytes": 
            case "getTxHashBytes": 
            case "logBytes": 
            case "transferBalanceBytes": 
            case "getDataBytes": 
            case "getSenderBytes": 
            case "getSelfBytes": 
            case "getRelatedTransactionListSizeBytes": 
            case "getRelatedTransactionListBytes": 
            case "readBufferBytes": 
            case "getTransactionSenderBytes": 
            case "getTransactionReceiverBytes": 
            case "getTransactionTimestampBytes": 
            case "getTransactionDataBytes": 
            case "getTransactionBlockIndexBytes": 
            case "getTransactionDepositFlagBytes": 
            case "getConfidentialDepositDataBytes": 
            case "getConfidentialDepositFlagBytes": 
            case "createContractBytes": 
            case "digestBytes": 
            case "verifyRsaBytes": 
            case "base64EncodeBytes": 
            case "base64DecodeBytes": 
            case "ecrecoveryBytes": 
            case "verifyMessageSM2Bytes": 
            case "verifyMessageECCK1Bytes": 
            case "verifyMessageECCR1Bytes": 
            case "bellmanSnarkVerifyBytes": 
            case "rangeProofVerifyBytes": 
            case "addPedersenCommitBytes": 
            case "subPedersenCommitBytes": 
            case "liftedElgamalContractHomomorphicAddBytes": 
            case "liftedElgamalContractHomomorphicSubBytes": 
            case "liftedElgamalScalarMutiplyBytes": 
            case "liftedElgamalContractZeroCheckVerifyBytes": 
            case "liftedElgamalContractRangeVerifyBytes": 
            case "setStorageBytes": 
            case "getStorageSizeBytes": 
            case "getStorageBytes": 
            case "deleteStorageBytes": 
            case "resultBytes": 
            case "getCallResult": 
            case "calculatePedersenCommitBytes": 
            case "pedersenCommitEqualityVerifyBytes": 
            case "readBufferRef": 
            case "verifyCommitment": 
            case "verifyRange": 
            case "verifyBalance": 
            case "fTraceBegin": 
            case "deployContractBytes": 
            case "updateContractBytes": 
            case "updateContractStatusBytes": 
            case "dcGetStorageSize": 
            case "dcSetStorageBytes": 
            case "dcDeleteStorageBytes": 
            case "grayscaleDeployContractBytes": 
            case "grayscaleVerificationBytes": 
            case "grayscaleVersionSwitchBackBytes": 
            case "grayscaleUpdateContractBytes": 
            case "callContractBytes": 
            case "dcSetAclBytes": 
            case "callEvmBytes": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "dispatchContractInterface": {
                log.info("MychainLibIntrinsic generating dispatchContractInterface");
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                MyContractAbiInfo contractAbiInfo = WasmTarget.contractAbiInfo;
                if (contractAbiInfo == null) {
                    log.info("WasmTarget.contractAbiInfo null");
                    throw new RuntimeException("WasmTarget.contractAbiInfo null");
                }
                WasmExpression appArg = manager.generate(invocation.getArguments().get(0));
                WasmExpression abiNameArg = manager.generate(invocation.getArguments().get(1));
                WasmExpression abiNameCharArrayPart = manager.generate(invocation.getArguments().get(2));
                WasmExpression abiNameLength = manager.generate(invocation.getArguments().get(3));
                WasmExpression abiParamsStreamArg = manager.generate(invocation.getArguments().get(4));
                for (MyContractAbiInfoInterface abiInfo : contractAbiInfo.getInterfaces()) {
                    WasmCall setReturnValueCall;
                    String setReturnValueMethodWasmFuncName;
                    ValueType[] methodParams;
                    String abiName = abiInfo.getName();
                    MethodReader method = abiInfo.getMethod();
                    WasmBlock abiBranchBlock = new WasmBlock(false);
                    abiBranchBlock.setType(WasmType.INT32);
                    WasmCall abiCall = new WasmCall("my_" + abiName);
                    abiCall.setImported(true);
                    abiCall.getArguments().add(appArg);
                    for (ValueType methodParam : methodParams = method.getParameterTypes()) {
                        MethodReference paramsStreamReadMethod = null;
                        WasmType paramWasmType = WasmType.INT32;
                        if (MyContractAbiUtils.isBooleanValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readBoolean", Boolean.TYPE);
                        } else if (MyContractAbiUtils.isByteValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readByte", Byte.TYPE);
                        } else if (MyContractAbiUtils.isCharValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readChar", Character.TYPE);
                        } else if (MyContractAbiUtils.isIntValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readInt", Integer.TYPE);
                        } else if (MyContractAbiUtils.isLongValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readLong", Long.TYPE);
                            paramWasmType = WasmType.INT64;
                        } else if (MyContractAbiUtils.isStringValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readString", String.class);
                        } else if (MyContractAbiUtils.isBooleanArrayValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readBooleanArray", boolean[].class);
                        } else if (MyContractAbiUtils.isCharArrayValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readCharArray", char[].class);
                        } else if (MyContractAbiUtils.isByteArrayValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readByteArray", byte[].class);
                        } else if (MyContractAbiUtils.isIntArrayValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readIntArray", int[].class);
                        } else if (MyContractAbiUtils.isLongArrayValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readLongArray", long[].class);
                        } else if (MyContractAbiUtils.isStringArrayValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readStringArray", String[].class);
                        } else if (MyContractAbiUtils.isIdentityValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readIdentity", Identity.class);
                        } else if (MyContractAbiUtils.isIdentityArrayValueType(methodParam)) {
                            paramsStreamReadMethod = new MethodReference(ParamsStream.class, "readIdentityArray", Identity[].class);
                        }
                        String paramReadWasmFuncName = manager.getNames().forMethod(paramsStreamReadMethod);
                        if (paramReadWasmFuncName != null) {
                            WasmCall arg = new WasmCall(paramReadWasmFuncName, true);
                            arg.getArguments().add(abiParamsStreamArg);
                            if (methodParam instanceof ValueType.Object || methodParam instanceof ValueType.Array) {
                                WasmLocal argLocal = manager.getTemporary(paramWasmType);
                                WasmBlock argBlock = new WasmBlock(false);
                                argBlock.setType(paramWasmType);
                                argBlock.getBody().add(new WasmSetLocal(argLocal, arg));
                                WasmCall saveAbiParamCall = new WasmCall(manager.getNames().forMethod(new MethodReference(MychainLib.class, "saveContractAbiParam", Object.class, Void.TYPE)), true);
                                saveAbiParamCall.getArguments().add(new WasmGetLocal(argLocal));
                                argBlock.getBody().add(saveAbiParamCall);
                                argBlock.getBody().add(new WasmGetLocal(argLocal));
                                abiCall.getArguments().add(argBlock);
                                continue;
                            }
                            abiCall.getArguments().add(arg);
                            continue;
                        }
                        throw new RuntimeException("not supported abi param type " + methodParam + " to dispatch");
                    }
                    MethodReference paramsStreamCheckEnd = new MethodReference(ParamsStream.class, "requireEnd", Void.TYPE);
                    String paramsStreamCheckEndFuncName = manager.getNames().forMethod(paramsStreamCheckEnd);
                    if (paramsStreamCheckEndFuncName != null) {
                        WasmCall endCall = new WasmCall(paramsStreamCheckEndFuncName, true);
                        endCall.getArguments().add(abiParamsStreamArg);
                        abiCall.getArguments().add(endCall);
                    }
                    WasmLocal abiCallResultLocal = manager.getTemporary(WasmType.INT32);
                    if (MyContractAbiUtils.isStringValueType(method.getResultType())) {
                        setReturnValueMethodWasmFuncName = manager.getNames().forMethod(new MethodReference(MychainLib.class, "setReturnStringValue", String.class, Integer.TYPE));
                    } else if (MyContractAbiUtils.isIntValueType(method.getResultType())) {
                        setReturnValueMethodWasmFuncName = manager.getNames().forMethod(new MethodReference(MychainLib.class, "setReturnIntValue", Integer.TYPE, Integer.TYPE));
                    } else if (MyContractAbiUtils.isLongValueType(method.getResultType())) {
                        abiCallResultLocal = manager.getTemporary(WasmType.INT64);
                        setReturnValueMethodWasmFuncName = manager.getNames().forMethod(new MethodReference(MychainLib.class, "setReturnLongValue", Long.TYPE, Integer.TYPE));
                    } else if (MyContractAbiUtils.isByteArrayValueType(method.getResultType())) {
                        setReturnValueMethodWasmFuncName = manager.getNames().forMethod(new MethodReference(MychainLib.class, "setReturnByteArray", byte[].class, Integer.TYPE));
                    } else if (MyContractAbiUtils.isBooleanValueType(method.getResultType())) {
                        setReturnValueMethodWasmFuncName = manager.getNames().forMethod(new MethodReference(MychainLib.class, "setReturnBooleanValue", Boolean.TYPE, Integer.TYPE));
                    } else if (MyContractAbiUtils.isVoidValueType(method.getResultType())) {
                        setReturnValueMethodWasmFuncName = null;
                    } else {
                        throw new RuntimeException("not supported abi return type " + method.getResultType());
                    }
                    if (setReturnValueMethodWasmFuncName != null) {
                        abiBranchBlock.getBody().add(new WasmSetLocal(abiCallResultLocal, abiCall));
                        setReturnValueCall = new WasmCall(setReturnValueMethodWasmFuncName, true);
                        setReturnValueCall.getArguments().add(new WasmGetLocal(abiCallResultLocal));
                        abiBranchBlock.getBody().add(new WasmReturn(setReturnValueCall));
                    } else {
                        abiBranchBlock.getBody().add(abiCall);
                        setReturnValueMethodWasmFuncName = manager.getNames().forMethod(new MethodReference(MychainLib.class, "setReturnIntValue", Integer.TYPE, Integer.TYPE));
                        setReturnValueCall = new WasmCall(setReturnValueMethodWasmFuncName, true);
                        setReturnValueCall.getArguments().add(new WasmInt32Constant(0));
                        abiBranchBlock.getBody().add(new WasmReturn(setReturnValueCall));
                    }
                    String abiEqualsMethod = manager.getNames().forMethod(new MethodReference(MychainLib.class, "isSameCharArrayPart", Address.class, Integer.TYPE, Address.class, Integer.TYPE, Boolean.TYPE));
                    WasmCall condition = new WasmCall(abiEqualsMethod, true);
                    int iterateAbiNameCharArrayAddr = manager.getStringPool().getStringCharacters(abiName);
                    condition.getArguments().add(abiNameCharArrayPart);
                    condition.getArguments().add(abiNameLength);
                    int iterateAbiNameCharArrayDataPartAddr = iterateAbiNameCharArrayAddr + 12;
                    condition.getArguments().add(new WasmInt32Constant(iterateAbiNameCharArrayDataPartAddr));
                    condition.getArguments().add(new WasmInt32Constant(abiName.length()));
                    WasmConditional conditionalExpr = new WasmConditional(condition);
                    conditionalExpr.getThenBlock().getBody().add(new WasmDrop(abiBranchBlock));
                    block.getBody().add(conditionalExpr);
                }
                WasmCall revertAbiNotFoundCall = new WasmCall(manager.getNames().forMethod(REVERT_ABI_NOT_FOUND), true);
                revertAbiNotFoundCall.getArguments().add(abiNameArg);
                block.getBody().add(revertAbiNotFoundCall);
                block.getBody().add(new WasmInt32Constant(1));
                return block;
            }
            case "revertRaw": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                String name = manager.getNames().forMethod(REVERT);
                WasmCall call = new WasmCall(name, true);
                call.getArguments().add(manager.generate(invocation.getArguments().get(0)));
                call.getArguments().add(manager.generate(invocation.getArguments().get(1)));
                block.getBody().add(call);
                block.getBody().add(new WasmUnreachable());
                return block;
            }
            case "abort": {
                WasmBlock block = new WasmBlock(false);
                String name = manager.getNames().forMethod(ABORT);
                WasmCall call = new WasmCall(name, true);
                block.getBody().add(call);
                block.getBody().add(new WasmUnreachable());
                return block;
            }
            case "setReturnValue": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression byteArrayArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair javaByteArrayWasmExprPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, byteArrayArg);
                String name = manager.getNames().forMethod(SET_RETURN_VALUE);
                WasmCall call = new WasmCall(name, true);
                call.getArguments().add(javaByteArrayWasmExprPair.getArrayDataOffsetExpr());
                call.getArguments().add(javaByteArrayWasmExprPair.getArrayLengthExpr());
                block.getBody().add(call);
                return block;
            }
            case "readInterfaceNameBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(1));
                String readInterfaceNameBytesMethodName = manager.getNames().forMethod(READ_INTERFACE_NAME);
                WasmCall readInterfaceNameCall = new WasmCall(readInterfaceNameBytesMethodName, true);
                readInterfaceNameCall.getArguments().add(dataArrayOffsetExpr);
                readInterfaceNameCall.getArguments().add(lengthOffsetExpr);
                return readInterfaceNameCall;
            }
            case "readInterfaceParamsBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(1));
                String readInterfaceNameBytesMethodName = manager.getNames().forMethod(READ_INTERFACE_PARAMS);
                WasmCall readInterfaceNameCall = new WasmCall(readInterfaceNameBytesMethodName, true);
                readInterfaceNameCall.getArguments().add(dataArrayOffsetExpr);
                readInterfaceNameCall.getArguments().add(lengthOffsetExpr);
                return readInterfaceNameCall;
            }
            case "checkAccountBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                String name = manager.getNames().forMethod(CHECK_ACCOUNT);
                WasmCall call = new WasmCall(name, true);
                call.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                call.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(call);
                return block;
            }
            case "getBlockHashBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression blockNumExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(1));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(2));
                String getBlockHashBytesName = manager.getNames().forMethod(GET_BLOCK_HASH);
                WasmCall getBlockHashCall = new WasmCall(getBlockHashBytesName, true);
                getBlockHashCall.getArguments().add(blockNumExpr);
                getBlockHashCall.getArguments().add(dataOffsetExpr);
                getBlockHashCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getBlockHashCall);
                return block;
            }
            case "getOriginBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(1));
                String getOriginBytesName = manager.getNames().forMethod(GET_ORIGIN);
                WasmCall getOriginCall = new WasmCall(getOriginBytesName, true);
                getOriginCall.getArguments().add(dataOffsetExpr);
                getOriginCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getOriginCall);
                return block;
            }
            case "getBalanceBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                WasmExpression balanceOutAddrExpr = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                String getBalanceBytesName = manager.getNames().forMethod(GET_BALANCE);
                WasmCall getBalanceCall = new WasmCall(getBalanceBytesName, true);
                getBalanceCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getBalanceCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getBalanceCall.getArguments().add(balanceOutAddrExpr);
                block.getBody().add(getBalanceCall);
                return block;
            }
            case "getAuthMapBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(1));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(2));
                String getAuthMapBytesName = manager.getNames().forMethod(GET_AUTH_MAP);
                WasmCall getAuthMapCall = new WasmCall(getAuthMapBytesName, true);
                getAuthMapCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getAuthMapCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getAuthMapCall.getArguments().add(dataOffsetExpr);
                getAuthMapCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getAuthMapCall);
                return block;
            }
            case "getAuthMapInCacheBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(1));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(2));
                String getAuthMapInCacheBytesName = manager.getNames().forMethod(GET_AUTH_MAP_IN_CACHE);
                WasmCall getAuthMapInCacheCall = new WasmCall(getAuthMapInCacheBytesName, true);
                getAuthMapInCacheCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getAuthMapInCacheCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getAuthMapInCacheCall.getArguments().add(dataOffsetExpr);
                getAuthMapInCacheCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getAuthMapInCacheCall);
                return block;
            }
            case "getCodeBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                String getCodeBytesName = manager.getNames().forMethod(GET_CODE);
                WasmCall getCodeCall = new WasmCall(getCodeBytesName, true);
                getCodeCall.getArguments().add(manager.generate(invocation.getArguments().get(0)));
                getCodeCall.getArguments().add(manager.generate(invocation.getArguments().get(1)));
                getCodeCall.getArguments().add(manager.generate(invocation.getArguments().get(2)));
                getCodeCall.getArguments().add(manager.generate(invocation.getArguments().get(3)));
                block.getBody().add(getCodeCall);
                return block;
            }
            case "getCodeHashBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(1));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(2));
                String getCodeHashBytesName = manager.getNames().forMethod(GET_CODE_HASH);
                WasmCall getCodeHashCall = new WasmCall(getCodeHashBytesName, true);
                getCodeHashCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getCodeHashCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getCodeHashCall.getArguments().add(dataOffsetExpr);
                getCodeHashCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getCodeHashCall);
                return block;
            }
            case "getRecoverKeyBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(1));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(2));
                String getRecoverKeyBytesName = manager.getNames().forMethod(GET_RECOVER_KEY);
                WasmCall getRecoverKeyCall = new WasmCall(getRecoverKeyBytesName, true);
                getRecoverKeyCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getRecoverKeyCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getRecoverKeyCall.getArguments().add(dataOffsetExpr);
                getRecoverKeyCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getRecoverKeyCall);
                return block;
            }
            case "getAccountStatusBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                WasmExpression statusAddrExpr = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                String getAccountStatusBytesName = manager.getNames().forMethod(GET_ACCOUNT_STATUS);
                WasmCall getAccountStatusCall = new WasmCall(getAccountStatusBytesName, true);
                getAccountStatusCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getAccountStatusCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getAccountStatusCall.getArguments().add(statusAddrExpr);
                block.getBody().add(getAccountStatusCall);
                return block;
            }
            case "getTxHashBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(1));
                String getHashBytesName = manager.getNames().forMethod(GET_TXHASH);
                WasmCall getHashCall = new WasmCall(getHashBytesName, true);
                getHashCall.getArguments().add(dataOffsetExpr);
                getHashCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getHashCall);
                return block;
            }
            case "transferBalanceBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression balanceExpr = manager.generate(invocation.getArguments().get(1));
                String transferBalanceBytesName = manager.getNames().forMethod(TRANSFER_BALANCE);
                WasmCall transferBalanceCall = new WasmCall(transferBalanceBytesName, true);
                transferBalanceCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                transferBalanceCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                transferBalanceCall.getArguments().add(balanceExpr);
                block.getBody().add(transferBalanceCall);
                return block;
            }
            case "logBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair dataByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, dataArg);
                WasmExpression topicsArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair topicsByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, topicsArg);
                String logBytesName = manager.getNames().forMethod(LOG);
                WasmCall logCall = new WasmCall(logBytesName, true);
                logCall.getArguments().add(dataByteArrayArgPair.getArrayDataOffsetExpr());
                logCall.getArguments().add(dataByteArrayArgPair.getArrayLengthExpr());
                logCall.getArguments().add(topicsByteArrayArgPair.getArrayDataOffsetExpr());
                logCall.getArguments().add(topicsByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(logCall);
                return block;
            }
            case "getDataBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(1));
                String getDataBytesName = manager.getNames().forMethod(GET_DATA);
                WasmCall getDataCall = new WasmCall(getDataBytesName, true);
                getDataCall.getArguments().add(dataOffsetExpr);
                getDataCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getDataCall);
                return block;
            }
            case "getSenderBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(1));
                String getSenderBytesName = manager.getNames().forMethod(GET_SENDER);
                WasmCall getSenderCall = new WasmCall(getSenderBytesName, true);
                getSenderCall.getArguments().add(dataOffsetExpr);
                getSenderCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getSenderCall);
                return block;
            }
            case "getSelfBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(1));
                String getSelfBytesName = manager.getNames().forMethod(GET_SELF);
                WasmCall getSelfCall = new WasmCall(getSelfBytesName, true);
                getSelfCall.getArguments().add(dataOffsetExpr);
                getSelfCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getSelfCall);
                return block;
            }
            case "getRelatedTransactionListSizeBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression depositExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression countExpr = manager.generate(invocation.getArguments().get(2));
                String getRelatedTransListSizeName = manager.getNames().forMethod(GET_RELATED_TRANSACTION_LIST_SIZE);
                WasmCall getRelatedTransactionListSizeCall = new WasmCall(getRelatedTransListSizeName, true);
                getRelatedTransactionListSizeCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getRelatedTransactionListSizeCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getRelatedTransactionListSizeCall.getArguments().add(depositExpr);
                getRelatedTransactionListSizeCall.getArguments().add(countExpr);
                block.getBody().add(getRelatedTransactionListSizeCall);
                return block;
            }
            case "getRelatedTransactionListBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression depositFlagExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression startIndexExpr = manager.generate(invocation.getArguments().get(2));
                WasmExpression numberExpr = manager.generate(invocation.getArguments().get(3));
                WasmExpression outLenOffsetExpr = manager.generate(invocation.getArguments().get(4));
                String getRelatedTransListName = manager.getNames().forMethod(GET_RELATED_TRANSACTION_LIST);
                WasmCall getRelatedTransactionListCall = new WasmCall(getRelatedTransListName, true);
                getRelatedTransactionListCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getRelatedTransactionListCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getRelatedTransactionListCall.getArguments().add(depositFlagExpr);
                getRelatedTransactionListCall.getArguments().add(startIndexExpr);
                getRelatedTransactionListCall.getArguments().add(numberExpr);
                getRelatedTransactionListCall.getArguments().add(outLenOffsetExpr);
                block.getBody().add(getRelatedTransactionListCall);
                return block;
            }
            case "readBufferBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression retArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(retArrayOffsetExpr);
                WasmCall retOffsetExpr = charArrayDataCall;
                WasmExpression sizeExpr = manager.generate(invocation.getArguments().get(1));
                String readBufferName = manager.getNames().forMethod(READ_BUFFER);
                WasmCall readBufferCall = new WasmCall(readBufferName, true);
                readBufferCall.getArguments().add(retOffsetExpr);
                readBufferCall.getArguments().add(sizeExpr);
                block.getBody().add(readBufferCall);
                return block;
            }
            case "getTransactionSenderBytes": 
            case "getTransactionReceiverBytes": 
            case "getTransactionDataBytes": 
            case "getTransactionBlockIndexBytes": 
            case "getTransactionTimestampBytes": 
            case "getTransactionDepositFlagBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression fieldExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression retOffsetAddrExpr = manager.generate(invocation.getArguments().get(2));
                String getTransactionName = manager.getNames().forMethod(GET_TRANSACTION);
                WasmCall getTransactionCall = new WasmCall(getTransactionName, true);
                getTransactionCall.getArguments().add(fieldExpr);
                getTransactionCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getTransactionCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getTransactionCall.getArguments().add(retOffsetAddrExpr);
                block.getBody().add(getTransactionCall);
                return block;
            }
            case "getConfidentialDepositDataBytes": 
            case "getConfidentialDepositFlagBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression fieldExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression retOffsetAddrExpr = manager.generate(invocation.getArguments().get(2));
                String getConfidentialDepositName = manager.getNames().forMethod(GET_CONFIDENTIAL_DEPOSIT);
                WasmCall getConfidentialDepositCall = new WasmCall(getConfidentialDepositName, true);
                getConfidentialDepositCall.getArguments().add(fieldExpr);
                getConfidentialDepositCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                getConfidentialDepositCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                getConfidentialDepositCall.getArguments().add(retOffsetAddrExpr);
                block.getBody().add(getConfidentialDepositCall);
                return block;
            }
            case "createContractBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression srcStringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair srcByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, srcStringArg);
                WasmExpression newStringArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair newByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, newStringArg);
                String createContractName = manager.getNames().forMethod(CREATE_CONTRACT);
                WasmCall createContractCall = new WasmCall(createContractName, true);
                createContractCall.getArguments().add(srcByteArrayArgPair.getArrayDataOffsetExpr());
                createContractCall.getArguments().add(srcByteArrayArgPair.getArrayLengthExpr());
                createContractCall.getArguments().add(newByteArrayArgPair.getArrayDataOffsetExpr());
                createContractCall.getArguments().add(newByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(createContractCall);
                return block;
            }
            case "digestBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression stringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair byteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, stringArg);
                WasmExpression digestTypeExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(2));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(3));
                String digestName = manager.getNames().forMethod(DIGEST);
                WasmCall digestCall = new WasmCall(digestName, true);
                digestCall.getArguments().add(byteArrayArgPair.getArrayDataOffsetExpr());
                digestCall.getArguments().add(byteArrayArgPair.getArrayLengthExpr());
                digestCall.getArguments().add(digestTypeExpr);
                digestCall.getArguments().add(dataOffsetExpr);
                digestCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(digestCall);
                return block;
            }
            case "verifyRsaBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression pkStringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair pkByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pkStringArg);
                WasmExpression sigStringArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair sigByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, sigStringArg);
                WasmExpression msgStringArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair msgByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, msgStringArg);
                WasmExpression hashTypeExpr = manager.generate(invocation.getArguments().get(3));
                String verifyName = manager.getNames().forMethod(VERIFY_RSA);
                WasmCall verifyCall = new WasmCall(verifyName, true);
                verifyCall.getArguments().add(pkByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(pkByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(sigByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(sigByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(msgByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(msgByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(hashTypeExpr);
                block.getBody().add(verifyCall);
                return block;
            }
            case "base64EncodeBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression inputOffset = manager.generate(invocation.getArguments().get(0));
                WasmExpression inputLength = manager.generate(invocation.getArguments().get(1));
                WasmExpression dataOffsetExpr = manager.generate(invocation.getArguments().get(2));
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(3));
                String base64EncodeName = manager.getNames().forMethod(BASE64_ENCODE);
                WasmCall base64EncodeCall = new WasmCall(base64EncodeName, true);
                base64EncodeCall.getArguments().add(inputOffset);
                base64EncodeCall.getArguments().add(inputLength);
                base64EncodeCall.getArguments().add(dataOffsetExpr);
                base64EncodeCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(base64EncodeCall);
                return block;
            }
            case "base64DecodeBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression inputOffset = manager.generate(invocation.getArguments().get(0));
                WasmExpression inputLength = manager.generate(invocation.getArguments().get(1));
                WasmExpression dataOffsetExpr = manager.generate(invocation.getArguments().get(2));
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(3));
                String base64DecodeName = manager.getNames().forMethod(BASE64_DECODE);
                WasmCall base64DecodeCall = new WasmCall(base64DecodeName, true);
                base64DecodeCall.getArguments().add(inputOffset);
                base64DecodeCall.getArguments().add(inputLength);
                base64DecodeCall.getArguments().add(dataOffsetExpr);
                base64DecodeCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(base64DecodeCall);
                return block;
            }
            case "ecrecoveryBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression hashStringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair hashByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, hashStringArg);
                WasmExpression sigStringArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair sigByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, sigStringArg);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(2));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(3));
                String ecrecoveryName = manager.getNames().forMethod(ECRECOVERY);
                WasmCall ecrecoveryCall = new WasmCall(ecrecoveryName, true);
                ecrecoveryCall.getArguments().add(hashByteArrayArgPair.getArrayDataOffsetExpr());
                ecrecoveryCall.getArguments().add(hashByteArrayArgPair.getArrayLengthExpr());
                ecrecoveryCall.getArguments().add(sigByteArrayArgPair.getArrayDataOffsetExpr());
                ecrecoveryCall.getArguments().add(sigByteArrayArgPair.getArrayLengthExpr());
                ecrecoveryCall.getArguments().add(dataOffsetExpr);
                ecrecoveryCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(ecrecoveryCall);
                return block;
            }
            case "verifyMessageSM2Bytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression pkStringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair pkByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pkStringArg);
                WasmExpression sigStringArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair sigByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, sigStringArg);
                WasmExpression msgStringArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair msgByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, msgStringArg);
                WasmExpression hashTypeExpr = manager.generate(invocation.getArguments().get(3));
                String verifyName = manager.getNames().forMethod(VERIFY_MESSAGE_SM2);
                WasmCall verifyCall = new WasmCall(verifyName, true);
                verifyCall.getArguments().add(pkByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(pkByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(sigByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(sigByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(msgByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(msgByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(hashTypeExpr);
                block.getBody().add(verifyCall);
                return block;
            }
            case "verifyMessageECCK1Bytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression pkStringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair pkByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pkStringArg);
                WasmExpression sigStringArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair sigByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, sigStringArg);
                WasmExpression msgStringArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair msgByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, msgStringArg);
                WasmExpression hashTypeExpr = manager.generate(invocation.getArguments().get(3));
                String verifyName = manager.getNames().forMethod(VERIFY_MESSAGE_ECCK1);
                WasmCall verifyCall = new WasmCall(verifyName, true);
                verifyCall.getArguments().add(pkByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(pkByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(sigByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(sigByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(msgByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(msgByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(hashTypeExpr);
                block.getBody().add(verifyCall);
                return block;
            }
            case "verifyMessageECCR1Bytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression pkStringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair pkByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pkStringArg);
                WasmExpression sigStringArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair sigByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, sigStringArg);
                WasmExpression msgStringArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair msgByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, msgStringArg);
                WasmExpression hashTypeExpr = manager.generate(invocation.getArguments().get(3));
                String verifyName = manager.getNames().forMethod(VERIFY_MESSAGE_ECCR1);
                WasmCall verifyCall = new WasmCall(verifyName, true);
                verifyCall.getArguments().add(pkByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(pkByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(sigByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(sigByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(msgByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(msgByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(hashTypeExpr);
                block.getBody().add(verifyCall);
                return block;
            }
            case "bellmanSnarkVerifyBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression keyStringArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair keyByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, keyStringArg);
                WasmExpression inputStringArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair inputByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, inputStringArg);
                WasmExpression proofStringArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair proofByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, proofStringArg);
                String verifyName = manager.getNames().forMethod(BELLMAN_SNARK_VERIFY);
                WasmCall verifyCall = new WasmCall(verifyName, true);
                verifyCall.getArguments().add(keyByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(keyByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(inputByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(inputByteArrayArgPair.getArrayLengthExpr());
                verifyCall.getArguments().add(proofByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCall.getArguments().add(proofByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(verifyCall);
                return block;
            }
            case "rangeProofVerifyBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression retOffsetAddrExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression proofArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair proofByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, proofArg);
                WasmExpression pcListArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair pcListByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pcListArg);
                String rangeProofVerifyName = manager.getNames().forMethod(RANGE_PROOF_VERIFY);
                WasmCall rangeProofVerifyCall = new WasmCall(rangeProofVerifyName, true);
                rangeProofVerifyCall.getArguments().add(retOffsetAddrExpr);
                rangeProofVerifyCall.getArguments().add(proofByteArrayArgPair.getArrayDataOffsetExpr());
                rangeProofVerifyCall.getArguments().add(proofByteArrayArgPair.getArrayLengthExpr());
                rangeProofVerifyCall.getArguments().add(pcListByteArrayArgPair.getArrayDataOffsetExpr());
                rangeProofVerifyCall.getArguments().add(pcListByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(rangeProofVerifyCall);
                return block;
            }
            case "addPedersenCommitBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression retOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(1));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(2));
                WasmExpression pcLeftArg = manager.generate(invocation.getArguments().get(3));
                JavaByteArrayWasmExprPair pcLeftArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pcLeftArg);
                WasmExpression pcRightArg = manager.generate(invocation.getArguments().get(4));
                JavaByteArrayWasmExprPair pcRightArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pcRightArg);
                String addPedersenCommitName = manager.getNames().forMethod(ADD_PEDERSEN_COMMIT);
                WasmCall addPedersenCommitCall = new WasmCall(addPedersenCommitName, true);
                addPedersenCommitCall.getArguments().add(retOffsetExpr);
                addPedersenCommitCall.getArguments().add(dataOffsetExpr);
                addPedersenCommitCall.getArguments().add(lengthOffsetExpr);
                addPedersenCommitCall.getArguments().add(pcLeftArgPair.getArrayDataOffsetExpr());
                addPedersenCommitCall.getArguments().add(pcLeftArgPair.getArrayLengthExpr());
                addPedersenCommitCall.getArguments().add(pcRightArgPair.getArrayDataOffsetExpr());
                addPedersenCommitCall.getArguments().add(pcRightArgPair.getArrayLengthExpr());
                block.getBody().add(addPedersenCommitCall);
                return block;
            }
            case "subPedersenCommitBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression retOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(1));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(2));
                WasmExpression pcLeftArg = manager.generate(invocation.getArguments().get(3));
                JavaByteArrayWasmExprPair pcLeftArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pcLeftArg);
                WasmExpression pcRightArg = manager.generate(invocation.getArguments().get(4));
                JavaByteArrayWasmExprPair pcRightArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pcRightArg);
                String subPedersenCommitName = manager.getNames().forMethod(SUB_PEDERSEN_COMMIT);
                WasmCall subPedersenCommitCall = new WasmCall(subPedersenCommitName, true);
                subPedersenCommitCall.getArguments().add(retOffsetExpr);
                subPedersenCommitCall.getArguments().add(dataOffsetExpr);
                subPedersenCommitCall.getArguments().add(lengthOffsetExpr);
                subPedersenCommitCall.getArguments().add(pcLeftArgPair.getArrayDataOffsetExpr());
                subPedersenCommitCall.getArguments().add(pcLeftArgPair.getArrayLengthExpr());
                subPedersenCommitCall.getArguments().add(pcRightArgPair.getArrayDataOffsetExpr());
                subPedersenCommitCall.getArguments().add(pcRightArgPair.getArrayLengthExpr());
                block.getBody().add(subPedersenCommitCall);
                return block;
            }
            case "calculatePedersenCommitBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression retOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(1));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(2));
                WasmExpression srcPcArg = manager.generate(invocation.getArguments().get(3));
                JavaByteArrayWasmExprPair srcPcArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, srcPcArg);
                WasmExpression positiveArg = manager.generate(invocation.getArguments().get(4));
                JavaByteArrayWasmExprPair positiveArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, positiveArg);
                WasmExpression negativeArg = manager.generate(invocation.getArguments().get(5));
                JavaByteArrayWasmExprPair negativeArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, negativeArg);
                String calculatePedersenCommitName = manager.getNames().forMethod(CALCULATE_PEDERSEN_COMMIT);
                WasmCall calculatePedersenCommitCall = new WasmCall(calculatePedersenCommitName, true);
                calculatePedersenCommitCall.getArguments().add(retOffsetExpr);
                calculatePedersenCommitCall.getArguments().add(dataOffsetExpr);
                calculatePedersenCommitCall.getArguments().add(lengthOffsetExpr);
                calculatePedersenCommitCall.getArguments().add(srcPcArgPair.getArrayDataOffsetExpr());
                calculatePedersenCommitCall.getArguments().add(srcPcArgPair.getArrayLengthExpr());
                calculatePedersenCommitCall.getArguments().add(positiveArgPair.getArrayDataOffsetExpr());
                calculatePedersenCommitCall.getArguments().add(positiveArgPair.getArrayLengthExpr());
                calculatePedersenCommitCall.getArguments().add(negativeArgPair.getArrayDataOffsetExpr());
                calculatePedersenCommitCall.getArguments().add(negativeArgPair.getArrayLengthExpr());
                block.getBody().add(calculatePedersenCommitCall);
                return block;
            }
            case "pedersenCommitEqualityVerifyBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression retOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression positiveArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair positiveArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, positiveArg);
                WasmExpression negativeArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair negativeArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, negativeArg);
                String pedersenCommitEqualityVerifyName = manager.getNames().forMethod(PEDERSEN_COMMIT_EQUALITY_VERIFY);
                WasmCall pedersenCommitEqualityVerifyCall = new WasmCall(pedersenCommitEqualityVerifyName, true);
                pedersenCommitEqualityVerifyCall.getArguments().add(retOffsetExpr);
                pedersenCommitEqualityVerifyCall.getArguments().add(positiveArgPair.getArrayDataOffsetExpr());
                pedersenCommitEqualityVerifyCall.getArguments().add(positiveArgPair.getArrayLengthExpr());
                pedersenCommitEqualityVerifyCall.getArguments().add(negativeArgPair.getArrayDataOffsetExpr());
                pedersenCommitEqualityVerifyCall.getArguments().add(negativeArgPair.getArrayLengthExpr());
                block.getBody().add(pedersenCommitEqualityVerifyCall);
                return block;
            }
            case "liftedElgamalContractHomomorphicAddBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression firstArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair firstByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, firstArg);
                WasmExpression secondArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair secondByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, secondArg);
                WasmExpression retOffsetAddrExpr = manager.generate(invocation.getArguments().get(2));
                String elgamalAddName = manager.getNames().forMethod(LIFTED_ELGAMAL_CONTRACT_HOMOMORPHIC_ADD);
                WasmCall elgamalAddCall = new WasmCall(elgamalAddName, true);
                elgamalAddCall.getArguments().add(firstByteArrayArgPair.getArrayDataOffsetExpr());
                elgamalAddCall.getArguments().add(firstByteArrayArgPair.getArrayLengthExpr());
                elgamalAddCall.getArguments().add(secondByteArrayArgPair.getArrayDataOffsetExpr());
                elgamalAddCall.getArguments().add(secondByteArrayArgPair.getArrayLengthExpr());
                elgamalAddCall.getArguments().add(retOffsetAddrExpr);
                block.getBody().add(elgamalAddCall);
                return block;
            }
            case "liftedElgamalContractHomomorphicSubBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression firstArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair firstByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, firstArg);
                WasmExpression secondArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair secondByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, secondArg);
                WasmExpression retOffsetAddrExpr = manager.generate(invocation.getArguments().get(2));
                String elgamalSubName = manager.getNames().forMethod(LIFTED_ELGAMAL_CONTRACT_HOMOMORPHIC_SUB);
                WasmCall elgamalSubCall = new WasmCall(elgamalSubName, true);
                elgamalSubCall.getArguments().add(firstByteArrayArgPair.getArrayDataOffsetExpr());
                elgamalSubCall.getArguments().add(firstByteArrayArgPair.getArrayLengthExpr());
                elgamalSubCall.getArguments().add(secondByteArrayArgPair.getArrayDataOffsetExpr());
                elgamalSubCall.getArguments().add(secondByteArrayArgPair.getArrayLengthExpr());
                elgamalSubCall.getArguments().add(retOffsetAddrExpr);
                block.getBody().add(elgamalSubCall);
                return block;
            }
            case "liftedElgamalScalarMutiplyBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression srcArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair srcByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, srcArg);
                WasmExpression scalarExp = manager.generate(invocation.getArguments().get(1));
                WasmExpression retOffsetAddrExpr = manager.generate(invocation.getArguments().get(2));
                String elgamalMulName = manager.getNames().forMethod(LIFTED_ELGAMAL_SCALAR_MUTIPLY);
                WasmCall elgamalMulCall = new WasmCall(elgamalMulName, true);
                elgamalMulCall.getArguments().add(srcByteArrayArgPair.getArrayDataOffsetExpr());
                elgamalMulCall.getArguments().add(srcByteArrayArgPair.getArrayLengthExpr());
                elgamalMulCall.getArguments().add(scalarExp);
                elgamalMulCall.getArguments().add(retOffsetAddrExpr);
                block.getBody().add(elgamalMulCall);
                return block;
            }
            case "liftedElgamalContractZeroCheckVerifyBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression cipherArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair cipherByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, cipherArg);
                WasmExpression proofArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair proofByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, proofArg);
                WasmExpression retOffsetAddrExpr = manager.generate(invocation.getArguments().get(2));
                String elgamalZeroCheckName = manager.getNames().forMethod(LIFTED_ELGAMAL_CONTRACT_ZERO_CHECK_VERIFY);
                WasmCall elgamalZeroCheckCall = new WasmCall(elgamalZeroCheckName, true);
                elgamalZeroCheckCall.getArguments().add(cipherByteArrayArgPair.getArrayDataOffsetExpr());
                elgamalZeroCheckCall.getArguments().add(cipherByteArrayArgPair.getArrayLengthExpr());
                elgamalZeroCheckCall.getArguments().add(proofByteArrayArgPair.getArrayDataOffsetExpr());
                elgamalZeroCheckCall.getArguments().add(proofByteArrayArgPair.getArrayLengthExpr());
                elgamalZeroCheckCall.getArguments().add(retOffsetAddrExpr);
                block.getBody().add(elgamalZeroCheckCall);
                return block;
            }
            case "liftedElgamalContractRangeVerifyBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression bufferLenExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression perValueBitSizeExpr = manager.generate(invocation.getArguments().get(2));
                WasmExpression pubArg = manager.generate(invocation.getArguments().get(3));
                JavaByteArrayWasmExprPair pubArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, pubArg);
                WasmExpression proofArg = manager.generate(invocation.getArguments().get(4));
                JavaByteArrayWasmExprPair proofArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, proofArg);
                WasmExpression retOffsetExpr = manager.generate(invocation.getArguments().get(5));
                String elgamalContractRangeVerifyName = manager.getNames().forMethod(LIFTED_ELGAMAL_CONTRACT_RANGE_VERIFY);
                WasmCall elgamalContractRangeVerifyCall = new WasmCall(elgamalContractRangeVerifyName, true);
                elgamalContractRangeVerifyCall.getArguments().add(dataOffsetExpr);
                elgamalContractRangeVerifyCall.getArguments().add(bufferLenExpr);
                elgamalContractRangeVerifyCall.getArguments().add(perValueBitSizeExpr);
                elgamalContractRangeVerifyCall.getArguments().add(pubArgPair.getArrayDataOffsetExpr());
                elgamalContractRangeVerifyCall.getArguments().add(pubArgPair.getArrayLengthExpr());
                elgamalContractRangeVerifyCall.getArguments().add(proofArgPair.getArrayDataOffsetExpr());
                elgamalContractRangeVerifyCall.getArguments().add(proofArgPair.getArrayLengthExpr());
                elgamalContractRangeVerifyCall.getArguments().add(retOffsetExpr);
                block.getBody().add(elgamalContractRangeVerifyCall);
                return block;
            }
            case "setStorageBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression keyArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair keyByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, keyArg);
                WasmExpression valueArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair valueByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, valueArg);
                String setStorageName = manager.getNames().forMethod(SET_STORAGE);
                WasmCall setStorageCall = new WasmCall(setStorageName, true);
                setStorageCall.getArguments().add(keyByteArrayArgPair.getArrayDataOffsetExpr());
                setStorageCall.getArguments().add(keyByteArrayArgPair.getArrayLengthExpr());
                setStorageCall.getArguments().add(valueByteArrayArgPair.getArrayDataOffsetExpr());
                setStorageCall.getArguments().add(valueByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(setStorageCall);
                return block;
            }
            case "getStorageSizeBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression keyArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair keyByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, keyArg);
                WasmExpression retOffsetAddrExpr = manager.generate(invocation.getArguments().get(1));
                String getStorageSizeName = manager.getNames().forMethod(GET_STORAGE_SIZE);
                WasmCall getStorageSizeCall = new WasmCall(getStorageSizeName, true);
                getStorageSizeCall.getArguments().add(keyByteArrayArgPair.getArrayDataOffsetExpr());
                getStorageSizeCall.getArguments().add(keyByteArrayArgPair.getArrayLengthExpr());
                getStorageSizeCall.getArguments().add(retOffsetAddrExpr);
                block.getBody().add(getStorageSizeCall);
                return block;
            }
            case "getStorageBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression keyArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair keyByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, keyArg);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(1));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(dataArrayOffsetExpr);
                WasmCall dataOffsetExpr = charArrayDataCall;
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(2));
                String getStorageName = manager.getNames().forMethod(GET_STORAGE);
                WasmCall getStorageCall = new WasmCall(getStorageName, true);
                getStorageCall.getArguments().add(keyByteArrayArgPair.getArrayDataOffsetExpr());
                getStorageCall.getArguments().add(keyByteArrayArgPair.getArrayLengthExpr());
                getStorageCall.getArguments().add(dataOffsetExpr);
                getStorageCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getStorageCall);
                return block;
            }
            case "deleteStorageBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression keyArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair keyByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, keyArg);
                String deleteStorageName = manager.getNames().forMethod(DELETE_STORAGE);
                WasmCall deleteStorageCall = new WasmCall(deleteStorageName, true);
                deleteStorageCall.getArguments().add(keyByteArrayArgPair.getArrayDataOffsetExpr());
                deleteStorageCall.getArguments().add(keyByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(deleteStorageCall);
                return block;
            }
            case "resultBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression msgArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair msgByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, msgArg);
                String resultName = manager.getNames().forMethod(RESULT);
                WasmCall resultCall = new WasmCall(resultName, true);
                resultCall.getArguments().add(msgByteArrayArgPair.getArrayDataOffsetExpr());
                resultCall.getArguments().add(msgByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(resultCall);
                return block;
            }
            case "getCallResult": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dataArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression lengthOffsetExpr = manager.generate(invocation.getArguments().get(1));
                String getCallResultName = manager.getNames().forMethod(GET_CALL_RESULT);
                WasmCall getCallResultCall = new WasmCall(getCallResultName, true);
                getCallResultCall.getArguments().add(dataArrayOffsetExpr);
                getCallResultCall.getArguments().add(lengthOffsetExpr);
                block.getBody().add(getCallResultCall);
                return block;
            }
            case "readBufferRef": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression retArrayOffsetExpr = manager.generate(invocation.getArguments().get(0));
                WasmCall charArrayDataCall = new WasmCall("myjava_charArrayData", true);
                charArrayDataCall.getArguments().add(retArrayOffsetExpr);
                WasmCall retOffsetExpr = charArrayDataCall;
                WasmExpression sizeExpr = manager.generate(invocation.getArguments().get(1));
                String readBufferRefName = manager.getNames().forMethod(READ_BUFFER_REF);
                WasmCall readBufferRefCall = new WasmCall(readBufferRefName, true);
                readBufferRefCall.getArguments().add(retOffsetExpr);
                readBufferRefCall.getArguments().add(sizeExpr);
                block.getBody().add(readBufferRefCall);
                return block;
            }
            case "verifyCommitment": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression typeExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression indexExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression toDataArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair toDataByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, toDataArg);
                WasmExpression encDataArg = manager.generate(invocation.getArguments().get(3));
                JavaByteArrayWasmExprPair encDataByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, encDataArg);
                String verifyCommitName = manager.getNames().forMethod(VERIFY_COMMITMENT);
                WasmCall verifyCommitCall = new WasmCall(verifyCommitName, true);
                verifyCommitCall.getArguments().add(typeExpr);
                verifyCommitCall.getArguments().add(indexExpr);
                verifyCommitCall.getArguments().add(toDataByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCommitCall.getArguments().add(toDataByteArrayArgPair.getArrayLengthExpr());
                verifyCommitCall.getArguments().add(encDataByteArrayArgPair.getArrayDataOffsetExpr());
                verifyCommitCall.getArguments().add(encDataByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(verifyCommitCall);
                return block;
            }
            case "verifyRange": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression indexExpr = manager.generate(invocation.getArguments().get(0));
                WasmExpression minValueExpr = manager.generate(invocation.getArguments().get(1));
                String verifyRangeName = manager.getNames().forMethod(VERIFY_RANGE);
                WasmCall verifyRangeCall = new WasmCall(verifyRangeName, true);
                verifyRangeCall.getArguments().add(indexExpr);
                verifyRangeCall.getArguments().add(minValueExpr);
                block.getBody().add(verifyRangeCall);
                return block;
            }
            case "verifyBalance": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression indexExpr = manager.generate(invocation.getArguments().get(0));
                String verifyBalanceName = manager.getNames().forMethod(VERIFY_BALANCE);
                WasmCall verifyBalanceCall = new WasmCall(verifyBalanceName, true);
                verifyBalanceCall.getArguments().add(indexExpr);
                block.getBody().add(verifyBalanceCall);
                return block;
            }
            case "fTraceBegin": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression fTraceBeginArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair fTraceBeginByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, fTraceBeginArg);
                String fTraceBeginName = manager.getNames().forMethod(F_TRACE_BEGIN);
                WasmCall fTraceBeginCall = new WasmCall(fTraceBeginName, true);
                fTraceBeginCall.getArguments().add(fTraceBeginByteArrayArgPair.getArrayDataOffsetExpr());
                fTraceBeginCall.getArguments().add(fTraceBeginByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(fTraceBeginCall);
                return block;
            }
            case "deployContractBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression proposerIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair proposerIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, proposerIdArg);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                WasmExpression contractCodeArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair contractCodeByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractCodeArg);
                WasmExpression authMapArg = manager.generate(invocation.getArguments().get(3));
                JavaByteArrayWasmExprPair authMapByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, authMapArg);
                String deployContractName = manager.getNames().forMethod(DEPLOY_CONTRACT);
                WasmCall deployContractCall = new WasmCall(deployContractName, true);
                deployContractCall.getArguments().add(proposerIdByteArrayArgPair.getArrayDataOffsetExpr());
                deployContractCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                deployContractCall.getArguments().add(contractCodeByteArrayArgPair.getArrayDataOffsetExpr());
                deployContractCall.getArguments().add(contractCodeByteArrayArgPair.getArrayLengthExpr());
                deployContractCall.getArguments().add(authMapByteArrayArgPair.getArrayDataOffsetExpr());
                deployContractCall.getArguments().add(authMapByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(deployContractCall);
                return block;
            }
            case "updateContractBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                WasmExpression contractCodeArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair contractCodeByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractCodeArg);
                String updateContractName = manager.getNames().forMethod(UPDATE_CONTRACT);
                WasmCall updateContractCall = new WasmCall(updateContractName, true);
                updateContractCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                updateContractCall.getArguments().add(contractCodeByteArrayArgPair.getArrayDataOffsetExpr());
                updateContractCall.getArguments().add(contractCodeByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(updateContractCall);
                return block;
            }
            case "updateContractStatusBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                WasmExpression statusExpr = manager.generate(invocation.getArguments().get(1));
                String updateContractStatusName = manager.getNames().forMethod(UPDATE_CONTRACT_STATUS);
                WasmCall updateContractStatusCall = new WasmCall(updateContractStatusName, true);
                updateContractStatusCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                updateContractStatusCall.getArguments().add(statusExpr);
                block.getBody().add(updateContractStatusCall);
                return block;
            }
            case "dcGetStorageSize": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dcIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair dcIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, dcIdArg);
                WasmExpression dbIdExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression keyArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair keyByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, keyArg);
                WasmExpression valueLenOffsetExpr = manager.generate(invocation.getArguments().get(3));
                String dcGetStorageSizeName = manager.getNames().forMethod(DC_GET_STORAGE_SIZE);
                WasmCall dcGetStorageSizeCall = new WasmCall(dcGetStorageSizeName, true);
                dcGetStorageSizeCall.getArguments().add(dcIdByteArrayArgPair.getArrayDataOffsetExpr());
                dcGetStorageSizeCall.getArguments().add(dbIdExpr);
                dcGetStorageSizeCall.getArguments().add(keyByteArrayArgPair.getArrayDataOffsetExpr());
                dcGetStorageSizeCall.getArguments().add(keyByteArrayArgPair.getArrayLengthExpr());
                dcGetStorageSizeCall.getArguments().add(valueLenOffsetExpr);
                block.getBody().add(dcGetStorageSizeCall);
                return block;
            }
            case "dcSetStorageBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dcIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair dcIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, dcIdArg);
                WasmExpression dbIdExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression keyArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair keyByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, keyArg);
                WasmExpression valueArg = manager.generate(invocation.getArguments().get(3));
                JavaByteArrayWasmExprPair valueyByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, valueArg);
                String dcSetStorageName = manager.getNames().forMethod(DC_SET_STORAGE);
                WasmCall dcSetStorageCall = new WasmCall(dcSetStorageName, true);
                dcSetStorageCall.getArguments().add(dcIdByteArrayArgPair.getArrayDataOffsetExpr());
                dcSetStorageCall.getArguments().add(dbIdExpr);
                dcSetStorageCall.getArguments().add(keyByteArrayArgPair.getArrayDataOffsetExpr());
                dcSetStorageCall.getArguments().add(keyByteArrayArgPair.getArrayLengthExpr());
                dcSetStorageCall.getArguments().add(valueyByteArrayArgPair.getArrayDataOffsetExpr());
                dcSetStorageCall.getArguments().add(valueyByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(dcSetStorageCall);
                return block;
            }
            case "dcDeleteStorageBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression dcIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair dcIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, dcIdArg);
                WasmExpression dbIdExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression keyArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair keyByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, keyArg);
                String dcDeleteStorageName = manager.getNames().forMethod(DC_DELETE_STORAGE);
                WasmCall dcDeleteStorageCall = new WasmCall(dcDeleteStorageName, true);
                dcDeleteStorageCall.getArguments().add(dcIdByteArrayArgPair.getArrayDataOffsetExpr());
                dcDeleteStorageCall.getArguments().add(dbIdExpr);
                dcDeleteStorageCall.getArguments().add(keyByteArrayArgPair.getArrayDataOffsetExpr());
                dcDeleteStorageCall.getArguments().add(keyByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(dcDeleteStorageCall);
                return block;
            }
            case "grayscaleDeployContractBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                WasmExpression contractCodeArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair contractCodeByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractCodeArg);
                String grayscaleDeployContractName = manager.getNames().forMethod(GRAYSCALE_DEPLOY_CONTRACT);
                WasmCall grayscaleDeployContractCall = new WasmCall(grayscaleDeployContractName, true);
                grayscaleDeployContractCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                grayscaleDeployContractCall.getArguments().add(contractCodeByteArrayArgPair.getArrayDataOffsetExpr());
                grayscaleDeployContractCall.getArguments().add(contractCodeByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(grayscaleDeployContractCall);
                return block;
            }
            case "grayscaleVerificationBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                String grayscaleVerificationName = manager.getNames().forMethod(GRAYSCALE_VERIFICATION);
                WasmCall grayscaleVerificationCall = new WasmCall(grayscaleVerificationName, true);
                grayscaleVerificationCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                block.getBody().add(grayscaleVerificationCall);
                return block;
            }
            case "grayscaleVersionSwitchBackBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                String grayscaleVersionSwitchBackName = manager.getNames().forMethod(GRAYSCALE_VERSION_SWITCH_BACK);
                WasmCall grayscaleVersionSwitchBackCall = new WasmCall(grayscaleVersionSwitchBackName, true);
                grayscaleVersionSwitchBackCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                block.getBody().add(grayscaleVersionSwitchBackCall);
                return block;
            }
            case "grayscaleUpdateContractBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                String grayscaleUpdateContractName = manager.getNames().forMethod(GRAYSCALE_UPDATE_CONTRACT);
                WasmCall grayscaleUpdateContractCall = new WasmCall(grayscaleUpdateContractName, true);
                grayscaleUpdateContractCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                block.getBody().add(grayscaleUpdateContractCall);
                return block;
            }
            case "callContractBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                WasmExpression methodArg = manager.generate(invocation.getArguments().get(1));
                JavaByteArrayWasmExprPair methodByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, methodArg);
                WasmExpression valueExpr = manager.generate(invocation.getArguments().get(2));
                WasmExpression gasExpr = manager.generate(invocation.getArguments().get(3));
                WasmExpression paramsArg = manager.generate(invocation.getArguments().get(4));
                JavaByteArrayWasmExprPair paramsByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, paramsArg);
                String callContractName = manager.getNames().forMethod(CALL_CONTRACT);
                WasmCall callContractCall = new WasmCall(callContractName, true);
                callContractCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                callContractCall.getArguments().add(contractIdByteArrayArgPair.getArrayLengthExpr());
                callContractCall.getArguments().add(methodByteArrayArgPair.getArrayDataOffsetExpr());
                callContractCall.getArguments().add(methodByteArrayArgPair.getArrayLengthExpr());
                callContractCall.getArguments().add(valueExpr);
                callContractCall.getArguments().add(gasExpr);
                callContractCall.getArguments().add(paramsByteArrayArgPair.getArrayDataOffsetExpr());
                callContractCall.getArguments().add(paramsByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(callContractCall);
                return block;
            }
            case "dcSetAclBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                WasmExpression dbIDExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression aclArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair aclByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, aclArg);
                String dcSetAclName = manager.getNames().forMethod(DC_SET_ACL);
                WasmCall dcSetAclCall = new WasmCall(dcSetAclName, true);
                dcSetAclCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                dcSetAclCall.getArguments().add(dbIDExpr);
                dcSetAclCall.getArguments().add(aclByteArrayArgPair.getArrayDataOffsetExpr());
                dcSetAclCall.getArguments().add(aclByteArrayArgPair.getArrayLengthExpr());
                block.getBody().add(dcSetAclCall);
                return block;
            }
            case "callEvmBytes": {
                WasmBlock block = new WasmBlock(false);
                block.setType(WasmType.INT32);
                WasmExpression contractIdArg = manager.generate(invocation.getArguments().get(0));
                JavaByteArrayWasmExprPair contractIdByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, contractIdArg);
                WasmExpression idLenExpr = manager.generate(invocation.getArguments().get(1));
                WasmExpression methodArg = manager.generate(invocation.getArguments().get(2));
                JavaByteArrayWasmExprPair methodByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, methodArg);
                WasmExpression methodLenExpr = manager.generate(invocation.getArguments().get(3));
                WasmExpression inputArg = manager.generate(invocation.getArguments().get(4));
                JavaByteArrayWasmExprPair inputByteArrayArgPair = JavaStringWasmUtils.putJavaByteArrayToWasmLocal(manager, block, inputArg);
                WasmExpression inputLenExpr = manager.generate(invocation.getArguments().get(5));
                WasmExpression gasExpr = manager.generate(invocation.getArguments().get(6));
                WasmExpression valueExpr = manager.generate(invocation.getArguments().get(7));
                String callEvmName = manager.getNames().forMethod(CALL_EVM);
                WasmCall callEvmCall = new WasmCall(callEvmName, true);
                callEvmCall.getArguments().add(contractIdByteArrayArgPair.getArrayDataOffsetExpr());
                callEvmCall.getArguments().add(idLenExpr);
                callEvmCall.getArguments().add(methodByteArrayArgPair.getArrayDataOffsetExpr());
                callEvmCall.getArguments().add(methodLenExpr);
                callEvmCall.getArguments().add(inputByteArrayArgPair.getArrayDataOffsetExpr());
                callEvmCall.getArguments().add(inputLenExpr);
                callEvmCall.getArguments().add(gasExpr);
                callEvmCall.getArguments().add(valueExpr);
                block.getBody().add(callEvmCall);
                return block;
            }
        }
        return new WasmUnreachable();
    }
}

