/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmDrop;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.runtime.MemoryTrace;
import java.util.stream.Collectors;

public class MemoryTraceIntrinsic
implements WasmIntrinsic {
    private final boolean enableMemoryTraceHooks;

    public MemoryTraceIntrinsic(boolean enableMemoryTraceHooks) {
        this.enableMemoryTraceHooks = enableMemoryTraceHooks;
    }

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        return methodReference.getClassName().equals(MemoryTrace.class.getName());
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        if (this.enableMemoryTraceHooks) {
            String hostApiName = "memory_trace_" + invocation.getMethod().getName();
            WasmCall call = new WasmCall(hostApiName, true);
            call.getArguments().addAll(invocation.getArguments().stream().map(manager::generate).collect(Collectors.toList()));
            return call;
        }
        return new WasmDrop(new WasmInt32Constant(0));
    }
}

