/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmConversion;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Subtype;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmLoadInt32;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.runtime.GC;
import com.antgroup.antchain.myjava.runtime.WasmHeap;

public class GCIntrinsic
implements WasmIntrinsic {
    private static final MethodReference RESIZE_HEAP = new MethodReference(WasmHeap.class, "resizeHeap", Integer.TYPE, Void.TYPE);

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(GC.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "gcStorageAddress": 
            case "gcStorageSize": 
            case "gcMarkQueueAddress": 
            case "gcMarkQueueBytesSize": 
            case "heapAddress": 
            case "availableBytes": 
            case "minAvailableBytes": 
            case "maxAvailableBytes": 
            case "resizeHeap": 
            case "writeBarrier": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "gcStorageAddress": {
                return GCIntrinsic.getStaticField(manager, "storageAddress");
            }
            case "gcStorageSize": {
                return GCIntrinsic.getStaticField(manager, "storageSize");
            }
            case "gcMarkQueueAddress": {
                return GCIntrinsic.getStaticField(manager, "markQueueAddress");
            }
            case "gcMarkQueueBytesSize": {
                return GCIntrinsic.getStaticField(manager, "markQueueBytesSize");
            }
            case "heapAddress": {
                return GCIntrinsic.getStaticField(manager, "heapAddress");
            }
            case "minAvailableBytes": {
                return GCIntrinsic.intToLong(GCIntrinsic.getStaticField(manager, "minHeapSize"));
            }
            case "maxAvailableBytes": {
                return GCIntrinsic.intToLong(GCIntrinsic.getStaticField(manager, "maxHeapSize"));
            }
            case "resizeHeap": {
                WasmExpression amount = manager.generate(invocation.getArguments().get(0));
                amount = new WasmConversion(WasmType.INT64, WasmType.INT32, false, amount);
                return new WasmCall(manager.getNames().forMethod(RESIZE_HEAP), amount);
            }
            case "availableBytes": {
                return GCIntrinsic.intToLong(GCIntrinsic.getStaticField(manager, "heapSize"));
            }
            case "writeBarrier": {
                return null;
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }

    private static WasmExpression getStaticField(WasmIntrinsicManager manager, String fieldName) {
        int address = manager.getStaticField(new FieldReference(WasmHeap.class.getName(), fieldName));
        return new WasmLoadInt32(4, new WasmInt32Constant(address), WasmInt32Subtype.INT32);
    }

    private static WasmExpression intToLong(WasmExpression expression) {
        return new WasmConversion(WasmType.INT32, WasmType.INT64, false, expression);
    }
}

