/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.intrinsics;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBlock;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBranch;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmConversion;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmDrop;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmFloat64Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmGetLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt64Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmSetLocal;
import com.antgroup.antchain.myjava.model.MethodReference;

public class DoubleIntrinsic
implements WasmIntrinsic {
    private static final long EXPONENT_BITS = 0x7FF0000000000000L;
    private static final long FRACTION_BITS = 0xFFFFFFFFFFFFFL;

    @Override
    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(Double.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "getNaN": 
            case "isNaN": 
            case "isInfinite": 
            case "doubleToLongBits": 
            case "longBitsToDouble": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "getNaN": {
                return new WasmFloat64Constant(Double.NaN);
            }
            case "isNaN": {
                return this.testSpecialIEEE(manager.generate(invocation.getArguments().get(0)), manager, WasmIntBinaryOperation.NE);
            }
            case "isInfinite": {
                return this.testSpecialIEEE(manager.generate(invocation.getArguments().get(0)), manager, WasmIntBinaryOperation.EQ);
            }
            case "doubleToLongBits": {
                WasmConversion conversion = new WasmConversion(WasmType.FLOAT64, WasmType.INT64, false, manager.generate(invocation.getArguments().get(0)));
                conversion.setReinterpret(true);
                return conversion;
            }
            case "longBitsToDouble": {
                WasmConversion conversion = new WasmConversion(WasmType.INT64, WasmType.FLOAT64, false, manager.generate(invocation.getArguments().get(0)));
                conversion.setReinterpret(true);
                return conversion;
            }
        }
        throw new AssertionError();
    }

    private WasmExpression testSpecialIEEE(WasmExpression expression, WasmIntrinsicManager manager, WasmIntBinaryOperation fractionOp) {
        WasmLocal bitsVar = manager.getTemporary(WasmType.INT64);
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        WasmConversion conversion = new WasmConversion(WasmType.FLOAT64, WasmType.INT64, false, expression);
        conversion.setReinterpret(true);
        block.getBody().add(new WasmSetLocal(bitsVar, conversion));
        WasmIntBinary exponentBits = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.AND, new WasmGetLocal(bitsVar), new WasmInt64Constant(0x7FF0000000000000L));
        WasmIntBinary fractionBits = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.AND, new WasmGetLocal(bitsVar), new WasmInt64Constant(0xFFFFFFFFFFFFFL));
        WasmIntBinary testExponent = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.NE, exponentBits, new WasmInt64Constant(0x7FF0000000000000L));
        WasmIntBinary testFraction = new WasmIntBinary(WasmIntType.INT64, fractionOp, fractionBits, new WasmInt64Constant(0L));
        WasmBranch breakIfWrongExponent = new WasmBranch(testExponent, block);
        breakIfWrongExponent.setResult(new WasmInt32Constant(0));
        block.getBody().add(new WasmDrop(breakIfWrongExponent));
        block.getBody().add(testFraction);
        return block;
    }
}

