/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm.generate;

import com.antgroup.antchain.myjava.ast.RegularMethodNode;
import com.antgroup.antchain.myjava.ast.VariableNode;
import com.antgroup.antchain.myjava.ast.decompilation.Decompiler;
import com.antgroup.antchain.myjava.backend.lowlevel.generate.NameProvider;
import com.antgroup.antchain.myjava.backend.wasm.binary.BinaryWriter;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmClassGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationVisitor;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGeneratorUtil;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmFunction;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBlock;
import com.antgroup.antchain.myjava.interop.Export;
import com.antgroup.antchain.myjava.model.AnnotationHolder;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.function.Predicate;

public class WasmGenerator {
    private Decompiler decompiler;
    private ClassHolderSource classSource;
    private WasmGenerationContext context;
    private WasmClassGenerator classGenerator;
    private BinaryWriter binaryWriter;
    private NameProvider names;
    private Predicate<MethodReference> asyncMethods;

    public WasmGenerator(Decompiler decompiler, ClassHolderSource classSource, WasmGenerationContext context, WasmClassGenerator classGenerator, BinaryWriter binaryWriter, Predicate<MethodReference> asyncMethods) {
        this.decompiler = decompiler;
        this.classSource = classSource;
        this.context = context;
        this.classGenerator = classGenerator;
        this.binaryWriter = binaryWriter;
        this.names = classGenerator.names;
        this.asyncMethods = asyncMethods;
    }

    public WasmFunction generateDefinition(MethodReference methodReference) {
        ClassHolder cls = this.classSource.get(methodReference.getClassName());
        MethodHolder method = cls.getMethod(methodReference.getDescriptor());
        WasmFunction function = new WasmFunction(this.names.forMethod(method.getReference()));
        if (!method.hasModifier(ElementModifier.STATIC)) {
            function.getParameters().add(WasmType.INT32);
        }
        for (int i = 0; i < method.parameterCount(); ++i) {
            function.getParameters().add(WasmGeneratorUtil.mapType(method.parameterType(i)));
        }
        if (method.getResultType() != ValueType.VOID) {
            function.setResult(WasmGeneratorUtil.mapType(method.getResultType()));
        }
        return function;
    }

    public WasmFunction generate(MethodReference methodReference, MethodHolder bodyMethod) {
        AnnotationHolder exportAnnot;
        int firstVariable;
        ClassHolder cls = this.classSource.get(methodReference.getClassName());
        MethodHolder method = cls.getMethod(methodReference.getDescriptor());
        RegularMethodNode methodAst = this.decompiler.decompileRegular(bodyMethod);
        WasmFunction function = this.context.getFunction(this.names.forMethod(methodReference));
        for (int i = firstVariable = method.hasModifier(ElementModifier.STATIC) ? 1 : 0; i < methodAst.getVariables().size(); ++i) {
            VariableNode variable = methodAst.getVariables().get(i);
            WasmType type = variable.getType() != null ? WasmGeneratorUtil.mapType(variable.getType()) : WasmType.INT32;
            function.add(new WasmLocal(type, variable.getName()));
        }
        WasmGenerationVisitor visitor = new WasmGenerationVisitor(this.context, this.classGenerator, this.binaryWriter, function, firstVariable, this.asyncMethods.test(methodReference));
        methodAst.getBody().acceptVisitor(visitor);
        if (visitor.result instanceof WasmBlock) {
            ((WasmBlock)visitor.result).setType(function.getResult());
        }
        function.getBody().add(visitor.result);
        String exportName = null;
        String specialName = this.names.getSpecialName(methodReference);
        if (specialName != null) {
            exportName = specialName;
        }
        if ((exportAnnot = method.getAnnotations().get(Export.class.getName())) != null) {
            exportName = exportAnnot.getValue("name").getString();
        }
        if (exportName != null && !exportName.isEmpty()) {
            function.setExportName(exportName);
        }
        return function;
    }

    public WasmFunction generateNative(MethodReference methodReference) {
        WasmFunction function = this.context.getFunction(this.names.forMethod(methodReference));
        WasmGenerationContext.ImportedMethod importedMethod = this.context.getImportedMethod(methodReference);
        if (importedMethod != null) {
            function.setImportName(importedMethod.name);
            function.setImportModule(importedMethod.module);
        } else {
            function.setImportName("<unknown>");
        }
        return function;
    }
}

