/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm;

import com.antgroup.antchain.myjava.ast.InvocationType;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.runtime.EVMParameter;
import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class ApiDisableManager {
    private Map<String, Set<String>> disabledStaticMethods = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> disabledVirtualMethods = new HashMap<String, Set<String>>();
    private static Set<String> disabledPackages = new HashSet<String>();
    private static final String ANY_DISABLED_METHOD = "*";
    private static ApiDisableManager singleton = new ApiDisableManager();

    private ApiDisableManager() {
        this.disabledStaticMethods.put(Math.class.getName(), new HashSet<String>(Arrays.asList("sin", "cos", "tan", "asin", "acos", "atan", "atan2", "log2", "random")));
        this.disabledStaticMethods.put(Double.class.getName(), new HashSet<String>(Arrays.asList("doubleToLongBits", "longBitsToDouble")));
        this.disabledStaticMethods.put(Float.class.getName(), new HashSet<String>(Arrays.asList("floatToIntBits", "intBitsToFloat")));
        this.disabledStaticMethods.put(Date.class.getName(), new HashSet<String>(Arrays.asList("getTimezoneOffset", "getDay")));
        this.disabledStaticMethods.put(DateFormat.class.getName(), new HashSet<String>(Arrays.asList("getTimeFormatString")));
        this.disabledStaticMethods.put(File.class.getName(), new HashSet<String>(Arrays.asList("createTempFile")));
        this.disabledStaticMethods.put(ServiceLoader.class.getName(), new HashSet<String>(Arrays.asList("load")));
        this.disabledVirtualMethods.put(Calendar.class.getName(), new HashSet<String>(Arrays.asList("setFirstDayOfWeek", "setMinimalDaysInFirstWeek")));
        this.disabledVirtualMethods.put(Class.class.getName(), new HashSet<String>(Arrays.asList("getResourceAsStream")));
        this.disabledVirtualMethods.put(File.class.getName(), new HashSet<String>(Arrays.asList("createNewFile", "mkdir", "mkdirs", "delete", "renameTo", "toURI")));
        this.disabledVirtualMethods.put(EVMParameter.class.getName(), new HashSet<String>(Arrays.asList("addStringArray")));
        disabledPackages.add("com.alibaba.fastjson");
    }

    private boolean inDisabledMethodsMap(Map<String, Set<String>> disabledMethodsMap, String className, String methodName) {
        Set<String> disabledMethods = disabledMethodsMap.get(className);
        if (disabledMethods == null) {
            return false;
        }
        if (disabledMethods.contains(ANY_DISABLED_METHOD)) {
            return true;
        }
        return disabledMethods.contains(methodName);
    }

    private boolean isDisabledStaticMethod(String className, String methodName) {
        return this.inDisabledMethodsMap(this.disabledStaticMethods, className, methodName);
    }

    private boolean isDisabledVirtualMethod(String className, String methodName) {
        return this.inDisabledMethodsMap(this.disabledVirtualMethods, className, methodName);
    }

    public static boolean isDisabledPackage(String className) {
        for (String pkgName : disabledPackages) {
            if (!className.startsWith(pkgName + ".")) continue;
            return true;
        }
        return false;
    }

    public void validateApiAvailable(MethodReference methodReference, InvocationType invocationType) {
        String className = methodReference.getClassName();
        if (ApiDisableManager.isDisabledPackage(className)) {
            throw new RuntimeException("can't use disabled package class " + className);
        }
        if ((invocationType == InvocationType.STATIC || invocationType == InvocationType.SPECIAL) && this.isDisabledStaticMethod(className, methodReference.getName())) {
            throw new RuntimeException("can't use disabled API " + className + "." + methodReference.getName());
        }
        if (invocationType == InvocationType.DYNAMIC && this.isDisabledVirtualMethod(className, methodReference.getName())) {
            throw new RuntimeException("can't use disabled API " + className + "." + methodReference.getName());
        }
    }

    public static ApiDisableManager instance() {
        return singleton;
    }
}

