/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.lowlevel.generate;

import com.antgroup.antchain.myjava.backend.lowlevel.generate.NameProvider;
import com.antgroup.antchain.myjava.interop.ContractInterface;
import com.antgroup.antchain.myjava.interop.Export;
import com.antgroup.antchain.myjava.interop.Import;
import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NameProviderWithSpecialNames
implements NameProvider {
    private NameProvider underlyingProvider;
    private ClassReaderSource classSource;
    private ClassHierarchy hierarchy;
    private MethodReference entrypoint;
    private Map<MethodReference, String> cache = new HashMap<MethodReference, String>();

    public NameProviderWithSpecialNames(NameProvider underlyingProvider, ClassReaderSource classSource, ClassHierarchy hierarchy, MethodReference entrypoint) {
        this.underlyingProvider = underlyingProvider;
        this.classSource = classSource;
        this.hierarchy = hierarchy;
        this.entrypoint = entrypoint;
    }

    @Override
    public String forMethod(MethodReference method) {
        return this.cache.computeIfAbsent(method, r -> {
            String special = this.getSpecialName((MethodReference)r);
            return special != null ? special : this.underlyingProvider.forMethod(method);
        });
    }

    private String getAbiNameByMethod(MethodReference methodReference, AnnotationReader contractInterfaceAnnot) {
        String abiName;
        AnnotationValue nameAnnoValue = contractInterfaceAnnot.getValue("name");
        String string = abiName = nameAnnoValue != null ? nameAnnoValue.getString() : null;
        if (abiName == null || abiName.isEmpty()) {
            abiName = methodReference.getName();
        }
        return abiName;
    }

    private String getEntrypointClassName() {
        return this.entrypoint != null ? this.entrypoint.getClassName() : null;
    }

    @Override
    public String getSpecialName(MethodReference methodReference) {
        MethodReader method = this.classSource.resolve(methodReference);
        if (method == null) {
            return null;
        }
        AnnotationReader exportAnnot = method.getAnnotations().get(Export.class.getName());
        if (exportAnnot != null) {
            return exportAnnot.getValue("name").getString();
        }
        AnnotationReader importAnnot = method.getAnnotations().get(Import.class.getName());
        if (importAnnot != null) {
            return importAnnot.getValue("name").getString();
        }
        AnnotationReader contractInterfaceAnnot = method.getAnnotations().get(ContractInterface.class.getName());
        if (contractInterfaceAnnot != null) {
            String abiName = this.getAbiNameByMethod(methodReference, contractInterfaceAnnot);
            String entrypointClassName = this.getEntrypointClassName();
            if (entrypointClassName != null && this.classSource.resolveImplementation(entrypointClassName, methodReference.getDescriptor()) != null) {
                this.hierarchy.addClassToClassSuperRelation(entrypointClassName);
                List<MethodReference> subMethods = this.hierarchy.resolveChildMethodImplementations(methodReference);
                for (MethodReference m : subMethods) {
                    MethodReader subMethodReader = this.classSource.resolve(m);
                    AnnotationReader subMethodContractInterface = subMethodReader.getAnnotations().get(ContractInterface.class.getName());
                    if (subMethodContractInterface == null) {
                        throw new RuntimeException("method " + m + " should add @ContractInterface when override contract abi method");
                    }
                    String subMethodAbiName = this.getAbiNameByMethod(m, subMethodContractInterface);
                    if (abiName.equals(subMethodAbiName)) continue;
                    throw new RuntimeException("method " + m + " override super class " + methodReference + " but has different abi name: " + subMethodAbiName + " and " + abiName);
                }
                if (!subMethods.isEmpty() && !methodReference.getClassName().equals(entrypointClassName)) {
                    return null;
                }
            }
            return "my_" + abiName;
        }
        return null;
    }

    @Override
    public String forVirtualMethod(MethodDescriptor method) {
        return this.underlyingProvider.forVirtualMethod(method);
    }

    @Override
    public String forStaticField(FieldReference field) {
        return this.underlyingProvider.forStaticField(field);
    }

    @Override
    public String forMemberField(FieldReference field) {
        return this.underlyingProvider.forMemberField(field);
    }

    @Override
    public String forClass(String className) {
        return this.underlyingProvider.forClass(className);
    }

    @Override
    public String forClassInitializer(String className) {
        return this.underlyingProvider.forClassInitializer(className);
    }

    @Override
    public String forClassSystemInitializer(ValueType type) {
        return this.underlyingProvider.forClassSystemInitializer(type);
    }

    @Override
    public String forClassClass(String className) {
        return this.underlyingProvider.forClassClass(className);
    }

    @Override
    public String forClassInstance(ValueType type) {
        return this.underlyingProvider.forClassInstance(type);
    }

    @Override
    public String forSupertypeFunction(ValueType type) {
        return this.underlyingProvider.forSupertypeFunction(type);
    }
}

