/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.lowlevel.generate;

import com.antgroup.antchain.myjava.backend.lowlevel.generate.NameProvider;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class LowLevelNameProvider
implements NameProvider {
    protected Set<String> occupiedTopLevelNames = new HashSet<String>();
    protected Set<String> occupiedVtableNames = new HashSet<String>();
    protected Map<String, Set<String>> occupiedClassNames = new HashMap<String, Set<String>>();
    protected Map<MethodReference, String> methodNames = new HashMap<MethodReference, String>();
    protected Map<MethodDescriptor, String> virtualMethodNames = new HashMap<MethodDescriptor, String>();
    protected Map<FieldReference, String> staticFieldNames = new HashMap<FieldReference, String>();
    protected Map<FieldReference, String> memberFieldNames = new HashMap<FieldReference, String>();
    protected Map<String, String> classNames = new HashMap<String, String>();
    protected Map<String, String> classInitializerNames = new HashMap<String, String>();
    protected Map<String, String> classClassNames = new HashMap<String, String>();
    protected Map<ValueType, String> classSystemInitializerNames = new HashMap<ValueType, String>();
    protected Map<ValueType, String> classInstanceNames = new HashMap<ValueType, String>();
    protected Map<ValueType, String> supertypeNames = new HashMap<ValueType, String>();

    @Override
    public String forMethod(MethodReference method) {
        return this.methodNames.computeIfAbsent(method, k -> this.pickUnoccupied("meth_" + this.suggestForMethod((MethodReference)k)));
    }

    @Override
    public String getSpecialName(MethodReference methodReference) {
        return null;
    }

    @Override
    public String forVirtualMethod(MethodDescriptor method) {
        return this.virtualMethodNames.computeIfAbsent(method, k -> this.pickUnoccupied("virt_" + this.sanitize(k.getName()), this.occupiedVtableNames));
    }

    @Override
    public String forStaticField(FieldReference field) {
        return this.staticFieldNames.computeIfAbsent(field, k -> this.pickUnoccupied("sfld_" + this.suggestForStaticField((FieldReference)k)));
    }

    @Override
    public String forMemberField(FieldReference field) {
        return this.memberFieldNames.computeIfAbsent(field, k -> {
            Set occupied = this.occupiedClassNames.computeIfAbsent(k.getClassName(), c -> new HashSet<String>(Arrays.asList("parent")));
            return this.pickUnoccupied("fld_" + this.sanitize(field.getFieldName()), occupied);
        });
    }

    @Override
    public String forClass(String className) {
        return this.classNames.computeIfAbsent(className, k -> this.pickUnoccupied("cls_" + this.suggestForClass((String)k)));
    }

    @Override
    public String forClassInitializer(String className) {
        return this.classInitializerNames.computeIfAbsent(className, k -> this.pickUnoccupied("initclass_" + this.suggestForClass((String)k)));
    }

    @Override
    public String forClassSystemInitializer(ValueType type) {
        return this.classSystemInitializerNames.computeIfAbsent(type, k -> this.pickUnoccupied("sysinitclass_" + this.suggestForType((ValueType)k)));
    }

    @Override
    public String forClassClass(String className) {
        return this.classClassNames.computeIfAbsent(className, k -> this.pickUnoccupied(this.suggestForClass((String)k) + "_VT"));
    }

    @Override
    public String forClassInstance(ValueType type) {
        return this.classInstanceNames.computeIfAbsent(type, k -> this.pickUnoccupied(this.suggestForType((ValueType)k) + "_Cls"));
    }

    @Override
    public String forSupertypeFunction(ValueType type) {
        return this.supertypeNames.computeIfAbsent(type, k -> this.pickUnoccupied("supertypeof_" + this.suggestForType((ValueType)k)));
    }

    private String suggestForMethod(MethodReference method) {
        StringBuilder sb = new StringBuilder();
        this.suggestForClass(method.getClassName(), sb);
        sb.append('_');
        sb.append(this.sanitize(method.getName()));
        String suggestName = sb.toString();
        if (suggestName.contains("caamcju") && !suggestName.contains("Test")) {
            throw new RuntimeException("can't include classlib replacement class lib " + method.getClassName() + ":" + method.getDescriptor().toString());
        }
        return suggestName;
    }

    private String suggestForStaticField(FieldReference field) {
        StringBuilder sb = new StringBuilder();
        this.suggestForClass(field.getClassName(), sb);
        sb.append('_');
        sb.append(this.sanitize(field.getFieldName()));
        return sb.toString();
    }

    private String suggestForClass(String className) {
        StringBuilder sb = new StringBuilder();
        this.suggestForClass(className, sb);
        return sb.toString();
    }

    private void suggestForClass(String className, StringBuilder sb) {
        int index = 0;
        while (true) {
            int next;
            if ((next = className.indexOf(46, index)) < 0) {
                if (index > 0) {
                    sb.append('_');
                    sb.append(this.sanitize(className.substring(index)));
                } else {
                    sb.append(this.sanitize(className));
                }
                return;
            }
            sb.append(this.sanitize(String.valueOf(className.charAt(index))));
            index = next + 1;
        }
    }

    private String suggestForType(ValueType type) {
        StringBuilder sb = new StringBuilder();
        this.suggestForType(type, sb);
        return sb.toString();
    }

    private void suggestForType(ValueType type, StringBuilder sb) {
        if (type instanceof ValueType.Object) {
            this.suggestForClass(((ValueType.Object)type).getClassName(), sb);
        } else if (type instanceof ValueType.Array) {
            sb.append("Arr_");
            this.suggestForType(((ValueType.Array)type).getItemType(), sb);
        } else {
            sb.append(type.toString());
        }
    }

    private String sanitize(String name) {
        StringBuilder sb = new StringBuilder();
        char c = name.charAt(0);
        sb.append(LowLevelNameProvider.isIdentifierStart(c) ? c : (char)'_');
        for (int i = 1; i < name.length(); ++i) {
            c = name.charAt(i);
            sb.append(LowLevelNameProvider.isIdentifierPart(c) ? c : (char)'_');
        }
        return sb.toString();
    }

    private static boolean isIdentifierStart(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private static boolean isIdentifierPart(char c) {
        return LowLevelNameProvider.isIdentifierStart(c) || c >= '0' && c <= '9';
    }

    private String pickUnoccupied(String name) {
        return this.pickUnoccupied(name, this.occupiedTopLevelNames);
    }

    private String pickUnoccupied(String name, Set<String> occupied) {
        String result = name;
        int index = 0;
        Set<? extends String> keywords = this.getKeywords();
        while (keywords.contains(result) || !occupied.add(result)) {
            result = name + "_" + index++;
        }
        return result;
    }

    protected Set<? extends String> getKeywords() {
        return Collections.emptySet();
    }
}

