/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast.optimization;

import com.antgroup.antchain.myjava.ast.AbstractStatementVisitor;
import com.antgroup.antchain.myjava.ast.BlockStatement;
import com.antgroup.antchain.myjava.ast.ConditionalStatement;
import com.antgroup.antchain.myjava.ast.ReturnStatement;
import com.antgroup.antchain.myjava.ast.SequentialStatement;
import com.antgroup.antchain.myjava.ast.Statement;
import com.antgroup.antchain.myjava.ast.SwitchClause;
import com.antgroup.antchain.myjava.ast.SwitchStatement;
import com.antgroup.antchain.myjava.ast.TryCatchStatement;
import java.util.List;

class RedundantReturnElimination
extends AbstractStatementVisitor {
    RedundantReturnElimination() {
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.handleList(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        this.handleList(statement.getConsequent());
        this.handleList(statement.getAlternative());
    }

    @Override
    public void visit(SwitchStatement statement) {
        this.handleList(statement.getDefaultClause());
        for (SwitchClause clause : statement.getClauses()) {
            this.handleList(clause.getBody());
        }
    }

    @Override
    public void visit(BlockStatement statement) {
        this.handleList(statement.getBody());
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.handleList(statement.getProtectedBody());
        this.handleList(statement.getHandler());
    }

    private void handleList(List<Statement> statements) {
        if (statements.isEmpty()) {
            return;
        }
        Statement last = statements.get(statements.size() - 1);
        if (last instanceof ReturnStatement && ((ReturnStatement)last).getResult() == null) {
            statements.remove(statements.size() - 1);
        } else {
            last.acceptVisitor(this);
        }
    }
}

