/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast.optimization;

import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.GraphUtils;
import com.antgroup.antchain.myjava.common.IntegerStack;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.util.DefinitionExtractor;
import com.antgroup.antchain.myjava.model.util.ProgramUtils;
import com.antgroup.antchain.myjava.model.util.UsageExtractor;
import java.util.Arrays;

class ReadWriteStatsBuilder {
    public int[] reads;
    public int[] writes;
    public Object[] constants;

    private ReadWriteStatsBuilder() {
    }

    public ReadWriteStatsBuilder(int variableCount) {
        this.reads = new int[variableCount];
        this.writes = new int[variableCount];
        this.constants = new Object[variableCount];
    }

    public ReadWriteStatsBuilder copy() {
        ReadWriteStatsBuilder result = new ReadWriteStatsBuilder();
        result.reads = Arrays.copyOf(this.reads, this.reads.length);
        result.writes = Arrays.copyOf(this.writes, this.writes.length);
        return result;
    }

    public void analyze(Program program) {
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        Graph dom = GraphUtils.buildDominatorGraph(GraphUtils.buildDominatorTree(cfg), cfg.size());
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        UsageExtractor useExtractor = new UsageExtractor();
        IntegerStack stack = new IntegerStack(program.basicBlockCount());
        stack.push(0);
        ConstantExtractor constantExtractor = new ConstantExtractor(this.constants);
        while (!stack.isEmpty()) {
            int node = stack.pop();
            BasicBlock block = program.basicBlockAt(node);
            if (block.getExceptionVariable() != null) {
                int n = block.getExceptionVariable().getIndex();
                this.writes[n] = this.writes[n] + 1;
                int n2 = block.getExceptionVariable().getIndex();
                this.reads[n2] = this.reads[n2] + 1;
            }
            for (Instruction insn : block) {
                insn.acceptVisitor(defExtractor);
                insn.acceptVisitor(useExtractor);
                for (Variable variable : defExtractor.getDefinedVariables()) {
                    int n = variable.getIndex();
                    this.writes[n] = this.writes[n] + 1;
                }
                for (Variable variable : useExtractor.getUsedVariables()) {
                    int n = variable.getIndex();
                    this.reads[n] = this.reads[n] + 1;
                }
                insn.acceptVisitor(constantExtractor);
            }
            for (Phi phi : block.getPhis()) {
                int n = phi.getReceiver().getIndex();
                this.writes[n] = this.writes[n] + phi.getIncomings().size();
                for (Incoming incoming : phi.getIncomings()) {
                    if (this.writes[incoming.getValue().getIndex()] != 0) continue;
                    int n3 = incoming.getValue().getIndex();
                    this.reads[n3] = this.reads[n3] + 1;
                }
            }
            for (Object succ : (Object)dom.outgoingEdges(node)) {
                stack.push((int)succ);
            }
        }
    }

    static class ConstantExtractor
    extends AbstractInstructionVisitor {
        private Object[] constants;

        ConstantExtractor(Object[] constants) {
            this.constants = constants;
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            this.constants[insn.getReceiver().getIndex()] = insn.getConstant();
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            this.constants[insn.getReceiver().getIndex()] = insn.getConstant();
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            this.constants[insn.getReceiver().getIndex()] = insn.getConstant();
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            this.constants[insn.getReceiver().getIndex()] = insn.getConstant();
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            this.constants[insn.getReceiver().getIndex()] = Float.valueOf(insn.getConstant());
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            this.constants[insn.getReceiver().getIndex()] = insn.getConstant();
        }
    }
}

