/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast.decompilation;

import com.antgroup.antchain.myjava.ast.ArrayType;
import com.antgroup.antchain.myjava.ast.AssignmentStatement;
import com.antgroup.antchain.myjava.ast.BinaryOperation;
import com.antgroup.antchain.myjava.ast.BoundCheckExpr;
import com.antgroup.antchain.myjava.ast.BreakStatement;
import com.antgroup.antchain.myjava.ast.CastExpr;
import com.antgroup.antchain.myjava.ast.ContinueStatement;
import com.antgroup.antchain.myjava.ast.Expr;
import com.antgroup.antchain.myjava.ast.InitClassStatement;
import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.ast.MonitorEnterStatement;
import com.antgroup.antchain.myjava.ast.MonitorExitStatement;
import com.antgroup.antchain.myjava.ast.OperationType;
import com.antgroup.antchain.myjava.ast.PrimitiveCastExpr;
import com.antgroup.antchain.myjava.ast.ReturnStatement;
import com.antgroup.antchain.myjava.ast.Statement;
import com.antgroup.antchain.myjava.ast.SwitchClause;
import com.antgroup.antchain.myjava.ast.SwitchStatement;
import com.antgroup.antchain.myjava.ast.ThrowStatement;
import com.antgroup.antchain.myjava.ast.UnaryOperation;
import com.antgroup.antchain.myjava.ast.UnwrapArrayExpr;
import com.antgroup.antchain.myjava.ast.WhileStatement;
import com.antgroup.antchain.myjava.ast.decompilation.Decompiler;
import com.antgroup.antchain.myjava.common.GraphIndexer;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHolderSource;
import com.antgroup.antchain.myjava.model.InvokeDynamicInstruction;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.ArrayElementType;
import com.antgroup.antchain.myjava.model.instructions.ArrayLengthInstruction;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryBranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BoundCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.BranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastIntegerInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastNumberInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.EmptyInstruction;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.IsInstanceInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorEnterInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.NegateInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.NumericOperandType;
import com.antgroup.antchain.myjava.model.instructions.PutElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.RaiseInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchTableEntry;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

class StatementGenerator
implements InstructionVisitor {
    private static final MethodReference CLONE_METHOD = new MethodReference(Object.class, "clone", Object.class);
    private int lastSwitchId;
    final List<Statement> statements = new ArrayList<Statement>();
    GraphIndexer indexer;
    Decompiler.Block currentBlock;
    Program program;
    ClassHolderSource classSource;
    private TextLocation currentLocation;
    boolean async;

    StatementGenerator() {
    }

    void setCurrentLocation(TextLocation currentLocation) {
        this.currentLocation = currentLocation;
    }

    @Override
    public void visit(EmptyInstruction insn) {
    }

    @Override
    public void visit(ClassConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver());
    }

    @Override
    public void visit(NullConstantInstruction insn) {
        this.assign(Expr.constant(null), insn.getReceiver());
    }

    @Override
    public void visit(IntegerConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver());
    }

    @Override
    public void visit(LongConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver());
    }

    @Override
    public void visit(FloatConstantInstruction insn) {
        this.assign(Expr.constant(Float.valueOf(insn.getConstant())), insn.getReceiver());
    }

    @Override
    public void visit(DoubleConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver());
    }

    @Override
    public void visit(StringConstantInstruction insn) {
        this.assign(Expr.constant(insn.getConstant()), insn.getReceiver());
    }

    @Override
    public void visit(BinaryInstruction insn) {
        int first = insn.getFirstOperand().getIndex();
        int second = insn.getSecondOperand().getIndex();
        Variable result = insn.getReceiver();
        switch (insn.getOperation()) {
            case ADD: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.ADD);
                break;
            }
            case SUBTRACT: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.SUBTRACT);
                break;
            }
            case MULTIPLY: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.MULTIPLY);
                break;
            }
            case DIVIDE: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.DIVIDE);
                break;
            }
            case MODULO: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.MODULO);
                break;
            }
            case COMPARE: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.COMPARE);
                break;
            }
            case AND: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.BITWISE_AND);
                break;
            }
            case OR: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.BITWISE_OR);
                break;
            }
            case XOR: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.BITWISE_XOR);
                break;
            }
            case SHIFT_LEFT: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.LEFT_SHIFT);
                break;
            }
            case SHIFT_RIGHT: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.RIGHT_SHIFT);
                break;
            }
            case SHIFT_RIGHT_UNSIGNED: {
                this.binary(insn.getOperandType(), first, second, result, BinaryOperation.UNSIGNED_RIGHT_SHIFT);
            }
        }
    }

    @Override
    public void visit(NegateInstruction insn) {
        this.assign(Expr.unary(UnaryOperation.NEGATE, StatementGenerator.mapOperandType(insn.getOperandType()), Expr.var(insn.getOperand().getIndex())), insn.getReceiver());
    }

    @Override
    public void visit(AssignInstruction insn) {
        AssignmentStatement stmt = Statement.assign(Expr.var(insn.getReceiver().getIndex()), Expr.var(insn.getAssignee().getIndex()));
        stmt.setLocation(this.currentLocation);
        this.statements.add(stmt);
    }

    @Override
    public void visit(CastInstruction insn) {
        CastExpr expr = new CastExpr();
        expr.setLocation(insn.getLocation());
        expr.setValue(Expr.var(insn.getValue().getIndex()));
        expr.setTarget(insn.getTargetType());
        this.assign(expr, insn.getReceiver());
    }

    @Override
    public void visit(CastNumberInstruction insn) {
        PrimitiveCastExpr expr = new PrimitiveCastExpr();
        expr.setSource(StatementGenerator.mapOperandType(insn.getSourceType()));
        expr.setTarget(StatementGenerator.mapOperandType(insn.getTargetType()));
        expr.setValue(Expr.var(insn.getValue().getIndex()));
        this.assign(expr, insn.getReceiver());
    }

    @Override
    public void visit(CastIntegerInstruction insn) {
        Expr value = Expr.var(insn.getValue().getIndex());
        switch (insn.getDirection()) {
            case FROM_INTEGER: {
                switch (insn.getTargetType()) {
                    case BYTE: {
                        value = Expr.unary(UnaryOperation.INT_TO_BYTE, null, value);
                        break;
                    }
                    case SHORT: {
                        value = Expr.unary(UnaryOperation.INT_TO_SHORT, null, value);
                        break;
                    }
                    case CHAR: {
                        value = Expr.unary(UnaryOperation.INT_TO_CHAR, null, value);
                    }
                }
                break;
            }
        }
        this.assign(value, insn.getReceiver());
    }

    @Override
    public void visit(BranchingInstruction insn) {
        switch (insn.getCondition()) {
            case EQUAL: {
                this.branch(this.compare(BinaryOperation.EQUALS, OperationType.INT, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case NOT_EQUAL: {
                this.branch(this.compare(BinaryOperation.NOT_EQUALS, OperationType.INT, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case GREATER: {
                this.branch(this.compare(BinaryOperation.GREATER, OperationType.INT, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case GREATER_OR_EQUAL: {
                this.branch(this.compare(BinaryOperation.GREATER_OR_EQUALS, OperationType.INT, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case LESS: {
                this.branch(this.compare(BinaryOperation.LESS, OperationType.INT, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case LESS_OR_EQUAL: {
                this.branch(this.compare(BinaryOperation.LESS_OR_EQUALS, OperationType.INT, insn.getOperand()), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case NOT_NULL: {
                this.branch(this.withLocation(Expr.binary(BinaryOperation.NOT_EQUALS, null, Expr.var(insn.getOperand().getIndex()), Expr.constant(null), this.currentLocation)), insn.getConsequent(), insn.getAlternative());
                break;
            }
            case NULL: {
                this.branch(this.withLocation(Expr.binary(BinaryOperation.EQUALS, null, Expr.var(insn.getOperand().getIndex()), Expr.constant(null))), insn.getConsequent(), insn.getAlternative());
            }
        }
    }

    @Override
    public void visit(BinaryBranchingInstruction insn) {
        int a = insn.getFirstOperand().getIndex();
        int b = insn.getSecondOperand().getIndex();
        BasicBlock consequent = insn.getConsequent();
        BasicBlock alternative = insn.getAlternative();
        switch (insn.getCondition()) {
            case EQUAL: {
                this.branch(this.withLocation(Expr.binary(BinaryOperation.EQUALS, OperationType.INT, Expr.var(a), Expr.var(b))), consequent, alternative);
                break;
            }
            case REFERENCE_EQUAL: {
                this.branch(this.withLocation(Expr.binary(BinaryOperation.EQUALS, null, Expr.var(a), Expr.var(b))), consequent, alternative);
                break;
            }
            case NOT_EQUAL: {
                this.branch(this.withLocation(Expr.binary(BinaryOperation.NOT_EQUALS, OperationType.INT, Expr.var(a), Expr.var(b))), consequent, alternative);
                break;
            }
            case REFERENCE_NOT_EQUAL: {
                this.branch(this.withLocation(Expr.binary(BinaryOperation.NOT_EQUALS, null, Expr.var(a), Expr.var(b))), consequent, alternative);
            }
        }
    }

    private Expr withLocation(Expr expr) {
        expr.setLocation(this.currentLocation);
        return expr;
    }

    @Override
    public void visit(JumpInstruction insn) {
        Statement stmt = this.generateJumpStatement(insn.getTarget());
        if (stmt != null) {
            this.statements.add(stmt);
        }
    }

    @Override
    public void visit(SwitchInstruction insn) {
        Object entry;
        SwitchStatement stmt = new SwitchStatement();
        stmt.setId("sblock" + this.lastSwitchId++);
        stmt.setValue(Expr.var(insn.getCondition().getIndex()));
        LinkedHashMap<Integer, List> switchMap = new LinkedHashMap<Integer, List>();
        for (int i = 0; i < insn.getEntries().size(); ++i) {
            entry = insn.getEntries().get(i);
            List conditions = switchMap.computeIfAbsent(((SwitchTableEntry)entry).getTarget().getIndex(), k -> new ArrayList());
            conditions.add(((SwitchTableEntry)entry).getCondition());
        }
        ArrayList targets = new ArrayList(switchMap.keySet());
        Collections.sort(targets);
        entry = targets.iterator();
        while (entry.hasNext()) {
            int target = (Integer)entry.next();
            SwitchClause clause = new SwitchClause();
            List conditionList = (List)switchMap.get(target);
            int[] conditions = new int[conditionList.size()];
            for (int i = 0; i < conditionList.size(); ++i) {
                conditions[i] = (Integer)conditionList.get(i);
            }
            clause.setConditions(conditions);
            clause.getBody().add(this.generateJumpStatement(stmt, target));
            stmt.getClauses().add(clause);
        }
        Statement breakStmt = this.generateJumpStatement(insn.getDefaultTarget());
        if (breakStmt != null) {
            stmt.getDefaultClause().add(breakStmt);
        }
        this.statements.add(stmt);
    }

    @Override
    public void visit(ExitInstruction insn) {
        ReturnStatement stmt = Statement.exitFunction(insn.getValueToReturn() != null ? Expr.var(insn.getValueToReturn().getIndex()) : null);
        stmt.setLocation(this.currentLocation);
        this.statements.add(stmt);
    }

    @Override
    public void visit(RaiseInstruction insn) {
        ThrowStatement stmt = new ThrowStatement();
        stmt.setLocation(this.currentLocation);
        stmt.setException(Expr.var(insn.getException().getIndex()));
        this.statements.add(stmt);
    }

    @Override
    public void visit(ConstructArrayInstruction insn) {
        this.assign(Expr.createArray(insn.getItemType(), Expr.var(insn.getSize().getIndex())), insn.getReceiver());
    }

    @Override
    public void visit(ConstructInstruction insn) {
        this.assign(Expr.createObject(insn.getType()), insn.getReceiver());
    }

    @Override
    public void visit(ConstructMultiArrayInstruction insn) {
        Expr[] dimensionExprs = new Expr[insn.getDimensions().size()];
        for (int i = 0; i < dimensionExprs.length; ++i) {
            dimensionExprs[i] = Expr.var(insn.getDimensions().get(i).getIndex());
        }
        this.assign(Expr.createArray(insn.getItemType(), dimensionExprs), insn.getReceiver());
    }

    @Override
    public void visit(GetFieldInstruction insn) {
        if (insn.getInstance() != null) {
            AssignmentStatement stmt = Statement.assign(Expr.var(insn.getReceiver().getIndex()), Expr.qualify(Expr.var(insn.getInstance().getIndex()), insn.getField()));
            stmt.setLocation(this.currentLocation);
            this.statements.add(stmt);
        } else {
            Expr fieldExpr = Expr.qualify(null, insn.getField());
            AssignmentStatement stmt = Statement.assign(Expr.var(insn.getReceiver().getIndex()), fieldExpr);
            stmt.setLocation(this.currentLocation);
            this.statements.add(stmt);
        }
    }

    @Override
    public void visit(PutFieldInstruction insn) {
        Expr right = Expr.var(insn.getValue().getIndex());
        Expr left = insn.getInstance() != null ? Expr.qualify(Expr.var(insn.getInstance().getIndex()), insn.getField()) : Expr.qualify(null, insn.getField());
        AssignmentStatement stmt = Statement.assign(left, right);
        stmt.setLocation(this.currentLocation);
        this.statements.add(stmt);
    }

    @Override
    public void visit(ArrayLengthInstruction insn) {
        this.assign(Expr.unary(UnaryOperation.LENGTH, null, Expr.var(insn.getArray().getIndex())), insn.getReceiver());
    }

    @Override
    public void visit(UnwrapArrayInstruction insn) {
        UnwrapArrayExpr unwrapExpr = new UnwrapArrayExpr(StatementGenerator.map(insn.getElementType()));
        unwrapExpr.setArray(Expr.var(insn.getArray().getIndex()));
        this.assign(unwrapExpr, insn.getReceiver());
    }

    @Override
    public void visit(CloneArrayInstruction insn) {
        this.assign(Expr.invoke(CLONE_METHOD, Expr.var(insn.getArray().getIndex()), new Expr[0]), insn.getReceiver());
    }

    @Override
    public void visit(GetElementInstruction insn) {
        Expr subscript = Expr.subscript(Expr.var(insn.getArray().getIndex()), Expr.var(insn.getIndex().getIndex()), StatementGenerator.map(insn.getType()));
        this.assign(subscript, insn.getReceiver());
    }

    @Override
    public void visit(PutElementInstruction insn) {
        Expr subscript = Expr.subscript(Expr.var(insn.getArray().getIndex()), Expr.var(insn.getIndex().getIndex()), StatementGenerator.map(insn.getType()));
        AssignmentStatement stmt = Statement.assign(subscript, Expr.var(insn.getValue().getIndex()));
        stmt.setLocation(this.currentLocation);
        this.statements.add(stmt);
    }

    private static ArrayType map(ArrayElementType type) {
        switch (type) {
            case BYTE: {
                return ArrayType.BYTE;
            }
            case SHORT: {
                return ArrayType.SHORT;
            }
            case CHAR: {
                return ArrayType.CHAR;
            }
            case INT: {
                return ArrayType.INT;
            }
            case LONG: {
                return ArrayType.LONG;
            }
            case FLOAT: {
                return ArrayType.FLOAT;
            }
            case DOUBLE: {
                return ArrayType.DOUBLE;
            }
            case OBJECT: {
                return ArrayType.OBJECT;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void visit(InvokeInstruction insn) {
        Expr[] exprArgs = new Expr[insn.getMethod().getParameterTypes().length];
        for (int i = 0; i < insn.getArguments().size(); ++i) {
            exprArgs[i] = Expr.var(insn.getArguments().get(i).getIndex());
        }
        InvocationExpr invocationExpr = insn.getInstance() != null ? (insn.getType() == InvocationType.VIRTUAL ? Expr.invoke(insn.getMethod(), Expr.var(insn.getInstance().getIndex()), exprArgs) : Expr.invokeSpecial(insn.getMethod(), Expr.var(insn.getInstance().getIndex()), exprArgs)) : Expr.invokeStatic(insn.getMethod(), exprArgs);
        AssignmentStatement stmt = insn.getReceiver() != null ? Statement.assign(Expr.var(insn.getReceiver().getIndex()), invocationExpr) : Statement.assign(null, invocationExpr);
        invocationExpr.setLocation(this.currentLocation);
        stmt.setLocation(this.currentLocation);
        stmt.setAsync(this.async);
        this.async = false;
        this.statements.add(stmt);
    }

    @Override
    public void visit(InvokeDynamicInstruction insn) {
    }

    @Override
    public void visit(IsInstanceInstruction insn) {
        this.assign(Expr.instanceOf(Expr.var(insn.getValue().getIndex()), insn.getType()), insn.getReceiver());
    }

    private void assign(Expr source, Variable target) {
        AssignmentStatement stmt = Statement.assign(Expr.var(target.getIndex()), source);
        stmt.setLocation(this.currentLocation);
        this.statements.add(stmt);
    }

    private void binary(NumericOperandType type, int first, int second, Variable result, BinaryOperation op) {
        this.assign(Expr.binary(op, StatementGenerator.mapOperandType(type), Expr.var(first), Expr.var(second)), result);
    }

    private static OperationType mapOperandType(NumericOperandType type) {
        switch (type) {
            case INT: {
                return OperationType.INT;
            }
            case LONG: {
                return OperationType.LONG;
            }
            case FLOAT: {
                return OperationType.FLOAT;
            }
            case DOUBLE: {
                return OperationType.DOUBLE;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    Statement generateJumpStatement(Decompiler.Block sourceBlock, BasicBlock target) {
        Decompiler.Block targetBlock = this.getTargetBlock(sourceBlock, target);
        if (targetBlock == null) {
            int targetIndex = this.indexer.indexOf(target.getIndex());
            if (targetIndex >= sourceBlock.end) {
                throw new IllegalStateException("Could not find block for basic block $" + target.getIndex());
            }
            return null;
        }
        if (target.getIndex() == this.indexer.nodeAt(targetBlock.end)) {
            BreakStatement breakStmt = new BreakStatement();
            breakStmt.setLocation(this.currentLocation);
            breakStmt.setTarget(targetBlock.statement);
            return breakStmt;
        }
        ContinueStatement contStmt = new ContinueStatement();
        contStmt.setLocation(this.currentLocation);
        contStmt.setTarget(targetBlock.statement);
        return contStmt;
    }

    Statement generateJumpStatement(BasicBlock target) {
        return this.generateJumpStatement(this.currentBlock, target);
    }

    private Statement generateJumpStatement(SwitchStatement stmt, int target) {
        Statement body = this.generateJumpStatement(this.program.basicBlockAt(target));
        if (body == null) {
            BreakStatement breakStmt = new BreakStatement();
            breakStmt.setTarget(stmt);
            body = breakStmt;
        }
        return body;
    }

    private Decompiler.Block getTargetBlock(Decompiler.Block source, BasicBlock target) {
        Decompiler.Block block = source;
        int targetIndex = this.indexer.indexOf(target.getIndex());
        Decompiler.Block candidate = null;
        while (block != null && (block.start >= targetIndex || block.end <= targetIndex)) {
            if (block.statement instanceof WhileStatement && block.start == targetIndex) {
                return block;
            }
            if (block.end == targetIndex) {
                candidate = block;
            }
            block = block.parent;
        }
        return candidate;
    }

    private void branch(Expr condition, BasicBlock consequentBlock, BasicBlock alternativeBlock) {
        Statement consequent = this.generateJumpStatement(consequentBlock);
        Statement alternative = this.generateJumpStatement(alternativeBlock);
        this.statements.add(Statement.cond(condition, consequent != null ? Arrays.asList(consequent) : Collections.emptyList(), alternative != null ? Arrays.asList(alternative) : Collections.emptyList()));
    }

    private Expr compare(BinaryOperation op, OperationType type, Variable value) {
        Expr expr = Expr.binary(op, type, Expr.var(value.getIndex()), Expr.constant(0));
        expr.setLocation(this.currentLocation);
        return expr;
    }

    @Override
    public void visit(InitClassInstruction insn) {
        InitClassStatement stmt = Statement.initClass(insn.getClassName());
        stmt.setLocation(this.currentLocation);
        stmt.setAsync(this.async);
        this.async = false;
        this.statements.add(stmt);
    }

    @Override
    public void visit(NullCheckInstruction insn) {
        this.assign(Expr.unary(UnaryOperation.NULL_CHECK, null, Expr.var(insn.getValue().getIndex())), insn.getReceiver());
    }

    @Override
    public void visit(MonitorEnterInstruction insn) {
        MonitorEnterStatement stmt = new MonitorEnterStatement();
        stmt.setLocation(this.currentLocation);
        stmt.setObjectRef(Expr.var(insn.getObjectRef().getIndex()));
        this.async = false;
        this.statements.add(stmt);
    }

    @Override
    public void visit(MonitorExitInstruction insn) {
        MonitorExitStatement stmt = new MonitorExitStatement();
        stmt.setLocation(this.currentLocation);
        stmt.setObjectRef(Expr.var(insn.getObjectRef().getIndex()));
        this.statements.add(stmt);
    }

    @Override
    public void visit(BoundCheckInstruction insn) {
        BoundCheckExpr expr = new BoundCheckExpr();
        expr.setLower(insn.isLower());
        expr.setIndex(Expr.var(insn.getIndex().getIndex()));
        if (insn.getArray() != null) {
            expr.setArray(Expr.var(insn.getArray().getIndex()));
        }
        expr.setLocation(insn.getLocation());
        this.assign(expr, insn.getReceiver());
    }
}

