/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnLabelsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnLabelsUtils.class);
    public static final String LABEL_EQUALS_OPERATOR = "=";
    public static final String LABEL_SPLIT_OPERATOR = ",";
    public static final int TAG_V2_LABEL_KEY_VALUE_SPLIT_LENGTH = 2;

    public static Map<String, String> parsePropertyValue2Map(Properties properties, String propertyName) {
        String rawLabels = properties.getProperty(propertyName, System.getProperty(propertyName, System.getenv(propertyName)));
        if (StringUtils.isBlank(rawLabels)) {
            LOGGER.info("no value found for property key: {}", (Object)propertyName);
            return new HashMap<String, String>(2);
        }
        return ConnLabelsUtils.parseRawLabels(rawLabels);
    }

    public static Map<String, String> parseRawLabels(String rawLabels) {
        if (StringUtils.isBlank(rawLabels)) {
            return new HashMap<String, String>(2);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        try {
            Arrays.stream(rawLabels.split(LABEL_SPLIT_OPERATOR)).filter(Objects::nonNull).map(String::trim).filter(StringUtils::isNotBlank).forEach(label -> {
                String[] kv = label.split(LABEL_EQUALS_OPERATOR);
                if (kv.length == 2) {
                    resultMap.put(kv[0].trim(), kv[1].trim());
                } else {
                    LOGGER.error("unknown label format: {}", label);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("unknown label format: {}", (Object)rawLabels);
        }
        return resultMap;
    }

    public static <T, R> Map<T, R> mergeMapByOrder(final Map<T, R> preferredMap, final Map<T, R> backwardMap) {
        if (preferredMap == null || preferredMap.isEmpty()) {
            return new HashMap<T, R>(8){
                {
                    super(initialCapacity);
                    this.putAll(backwardMap);
                }
            };
        }
        if (backwardMap == null || backwardMap.isEmpty()) {
            return new HashMap<T, R>(8){
                {
                    super(initialCapacity);
                    this.putAll(preferredMap);
                }
            };
        }
        HashMap resultMap = new HashMap<T, R>(8){
            {
                super(initialCapacity);
                this.putAll(preferredMap);
            }
        };
        backwardMap.forEach((key, value) -> {
            if (!resultMap.containsKey(key)) {
                resultMap.put(key, value);
            }
        });
        return resultMap;
    }

    public static <T> Map<String, T> addPrefixForEachKey(Map<String, T> map, String prefix) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        return map.entrySet().stream().filter(Objects::nonNull).filter(elem -> !((String)elem.getKey()).trim().isEmpty()).collect(Collectors.toMap(elem -> prefix + (String)elem.getKey(), Map.Entry::getValue));
    }
}

