/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.AppNameUtils;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.client.utils.TenantUtil;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class ParamUtil {
    private static final Logger LOGGER = LogUtils.logger(ParamUtil.class);
    public static final boolean USE_ENDPOINT_PARSING_RULE_DEFAULT_VALUE = true;
    private static final Pattern PATTERN = Pattern.compile("\\$\\{[^}]+\\}");
    private static String defaultContextPath;
    private static String defaultNodesPath;
    private static String appKey;
    private static String appName;
    private static final String DEFAULT_SERVER_PORT = "8848";
    private static String serverPort;
    private static String clientVersion;
    private static int connectTimeout;
    private static int readTimeout;
    private static double perTaskConfigSize;
    private static final String NACOS_CLIENT_APP_KEY = "nacos.client.appKey";
    private static final String BLANK_STR = "";
    private static final String NACOS_CLIENT_CONTEXTPATH_KEY = "nacos.client.contextPath";
    private static final String DEFAULT_NACOS_CLIENT_CONTEXTPATH = "nacos";
    private static final String NACOS_SERVER_PORT_KEY = "nacos.server.port";
    private static final String NACOS_CONNECT_TIMEOUT_KEY = "NACOS.CONNECT.TIMEOUT";
    private static final String NACOS_READ_TIMEOUT_KEY = "NACOS.READ.TIMEOUT";
    private static final String DEFAULT_NACOS_CONNECT_TIMEOUT = "1000";
    private static final String DEFAULT_NACOS_READ_TIMEOUT = "3000";
    private static final String PER_TASK_CONFIG_SIZE_KEY = "PER_TASK_CONFIG_SIZE";
    private static final String DEFAULT_PER_TASK_CONFIG_SIZE_KEY = "3000";
    private static final int DESENSITISE_PARAMETER_MIN_LENGTH = 2;
    private static final int DESENSITISE_PARAMETER_KEEP_ONE_CHAR_LENGTH = 8;
    public static final int MAX_ENV_NAME_LENGTH = 50;

    private static int initConnectionTimeout() {
        String tmp = DEFAULT_NACOS_CONNECT_TIMEOUT;
        try {
            tmp = NacosClientProperties.PROTOTYPE.getProperty(NACOS_CONNECT_TIMEOUT_KEY, DEFAULT_NACOS_CONNECT_TIMEOUT);
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid connect timeout:" + tmp;
            LOGGER.error("[settings] " + msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static int initReadTimeout() {
        String tmp = "3000";
        try {
            tmp = NacosClientProperties.PROTOTYPE.getProperty(NACOS_READ_TIMEOUT_KEY, "3000");
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid read timeout:" + tmp;
            LOGGER.error("[settings] " + msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static double initPerTaskConfigSize() {
        try {
            return Double.parseDouble(NacosClientProperties.PROTOTYPE.getProperty(PER_TASK_CONFIG_SIZE_KEY, "3000"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("[PER_TASK_CONFIG_SIZE] PER_TASK_CONFIG_SIZE invalid", (Throwable)e);
            throw new IllegalArgumentException("invalid PER_TASK_CONFIG_SIZE, expected value type double", e);
        }
    }

    public static String getAppKey() {
        return appKey;
    }

    public static void setAppKey(String appKey) {
        ParamUtil.appKey = appKey;
    }

    public static String getAppName() {
        return appName;
    }

    public static void setAppName(String appName) {
        ParamUtil.appName = appName;
    }

    public static String getDefaultContextPath() {
        return defaultContextPath;
    }

    public static void setDefaultContextPath(String defaultContextPath) {
        ParamUtil.defaultContextPath = defaultContextPath;
    }

    public static String getClientVersion() {
        return clientVersion;
    }

    public static void setClientVersion(String clientVersion) {
        ParamUtil.clientVersion = clientVersion;
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) {
        ParamUtil.connectTimeout = connectTimeout;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    public static void setReadTimeout(int readTimeout) {
        ParamUtil.readTimeout = readTimeout;
    }

    public static double getPerTaskConfigSize() {
        return perTaskConfigSize;
    }

    public static void setPerTaskConfigSize(double perTaskConfigSize) {
        ParamUtil.perTaskConfigSize = perTaskConfigSize;
    }

    public static String getDefaultServerPort() {
        return serverPort;
    }

    public static String getDefaultNodesPath() {
        return defaultNodesPath;
    }

    public static void setDefaultNodesPath(String defaultNodesPath) {
        ParamUtil.defaultNodesPath = defaultNodesPath;
    }

    public static String parseNamespace(NacosClientProperties properties) {
        String namespaceTmp = null;
        String isUseCloudNamespaceParsing = properties.getProperty("isUseCloudNamespaceParsing", properties.getProperty("nacos.use.cloud.namespace.parsing", String.valueOf(true)));
        if (Boolean.parseBoolean(isUseCloudNamespaceParsing)) {
            namespaceTmp = TenantUtil.getUserTenantForAcm();
            namespaceTmp = TemplateUtils.stringBlankAndThenExecute(namespaceTmp, () -> {
                String namespace = properties.getProperty("ALIBABA_ALIWARE_NAMESPACE");
                return StringUtils.isNotBlank(namespace) ? namespace : BLANK_STR;
            });
        }
        if (StringUtils.isBlank(namespaceTmp)) {
            namespaceTmp = properties.getProperty("namespace");
        }
        return StringUtils.isNotBlank(namespaceTmp) ? namespaceTmp.trim() : BLANK_STR;
    }

    public static String parsingEndpointRule(String endpointUrl) {
        String endpointUrlSource;
        if (endpointUrl == null || !PATTERN.matcher(endpointUrl).find()) {
            String endpointUrlSource2 = NacosClientProperties.PROTOTYPE.getProperty("ALIBABA_ALIWARE_ENDPOINT_URL");
            if (StringUtils.isNotBlank(endpointUrlSource2)) {
                endpointUrl = endpointUrlSource2;
            }
            return StringUtils.isNotBlank(endpointUrl) ? endpointUrl : BLANK_STR;
        }
        endpointUrl = endpointUrl.substring(endpointUrl.indexOf("${") + 2, endpointUrl.lastIndexOf("}"));
        int defStartOf = endpointUrl.indexOf(":");
        String defaultEndpointUrl = null;
        if (defStartOf != -1) {
            defaultEndpointUrl = endpointUrl.substring(defStartOf + 1);
            endpointUrl = endpointUrl.substring(0, defStartOf);
        }
        if (StringUtils.isBlank(endpointUrlSource = TemplateUtils.stringBlankAndThenExecute(NacosClientProperties.PROTOTYPE.getProperty(endpointUrl), () -> NacosClientProperties.PROTOTYPE.getProperty("ALIBABA_ALIWARE_ENDPOINT_URL")))) {
            if (StringUtils.isNotBlank(defaultEndpointUrl)) {
                endpointUrl = defaultEndpointUrl;
            }
        } else {
            endpointUrl = endpointUrlSource;
        }
        return StringUtils.isNotBlank(endpointUrl) ? endpointUrl : BLANK_STR;
    }

    public static String simplyEnvNameIfOverLimit(String envName) {
        if (StringUtils.isNotBlank(envName) && envName.length() > 50) {
            return envName.substring(0, 50) + MD5Utils.md5Hex(envName, "UTF-8");
        }
        return envName;
    }

    public static String getInputParameters(Properties properties) {
        boolean logAllParameters = ConvertUtils.toBoolean(properties.getProperty("logAllProperties"), false);
        StringBuilder result = new StringBuilder();
        if (logAllParameters) {
            result.append("Log nacos client init properties with Full mode, This mode is only used for debugging and troubleshooting. ");
            result.append("Please close this mode by removing properties `logAllProperties` after finishing debug or troubleshoot.\n");
            result.append("Nacos client all init properties: \n");
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.append("\t").append(key.toString()).append("=").append(value.toString()).append("\n")));
        } else {
            result.append("Nacos client key init properties: \n");
            ParamUtil.appendKeyParameters(result, properties, "serverAddr", false);
            ParamUtil.appendKeyParameters(result, properties, "namespace", false);
            ParamUtil.appendKeyParameters(result, properties, "endpoint", false);
            ParamUtil.appendKeyParameters(result, properties, "endpointPort", false);
            ParamUtil.appendKeyParameters(result, properties, "username", false);
            ParamUtil.appendKeyParameters(result, properties, "password", true);
            ParamUtil.appendKeyParameters(result, properties, "accessKey", false);
            ParamUtil.appendKeyParameters(result, properties, "secretKey", true);
            ParamUtil.appendKeyParameters(result, properties, "ramRoleName", false);
            ParamUtil.appendKeyParameters(result, properties, "signatureRegionId", false);
        }
        return result.toString();
    }

    private static void appendKeyParameters(StringBuilder result, Properties properties, String propertyKey, boolean needDesensitise) {
        String propertyValue = properties.getProperty(propertyKey);
        if (StringUtils.isBlank(propertyValue)) {
            return;
        }
        result.append("\t").append(propertyKey).append("=").append(needDesensitise ? ParamUtil.desensitiseParameter(propertyValue) : propertyValue).append("\n");
    }

    public static String desensitiseParameter(String parameterValue) {
        if (parameterValue.length() <= 2) {
            return parameterValue;
        }
        if (parameterValue.length() < 8) {
            return ParamUtil.doDesensitiseParameter(parameterValue, 1);
        }
        return ParamUtil.doDesensitiseParameter(parameterValue, 2);
    }

    private static String doDesensitiseParameter(String parameterValue, int keepCharCount) {
        StringBuilder result = new StringBuilder(parameterValue);
        for (int i = keepCharCount; i < parameterValue.length() - keepCharCount; ++i) {
            result.setCharAt(i, '*');
        }
        return result.toString();
    }

    public static String getNameSuffixByServerIps(String ... serverIps) {
        StringBuilder sb = new StringBuilder();
        String split = BLANK_STR;
        for (String serverIp : serverIps) {
            sb.append(split);
            serverIp = serverIp.replaceAll("http(s)?://", BLANK_STR);
            sb.append(serverIp.replaceAll(":", "_"));
            split = "-";
        }
        return sb.toString();
    }

    static {
        defaultNodesPath = "serverlist";
        clientVersion = "unknown";
        perTaskConfigSize = 3000.0;
        appKey = NacosClientProperties.PROTOTYPE.getProperty(NACOS_CLIENT_APP_KEY, BLANK_STR);
        defaultContextPath = NacosClientProperties.PROTOTYPE.getProperty(NACOS_CLIENT_CONTEXTPATH_KEY, DEFAULT_NACOS_CLIENT_CONTEXTPATH);
        appName = AppNameUtils.getAppName();
        serverPort = NacosClientProperties.PROTOTYPE.getProperty(NACOS_SERVER_PORT_KEY, DEFAULT_SERVER_PORT);
        LOGGER.info("[settings] [req-serv] nacos-server port:{}", (Object)serverPort);
        connectTimeout = ParamUtil.initConnectionTimeout();
        LOGGER.info("[settings] [http-client] connect timeout:{}", (Object)connectTimeout);
        readTimeout = ParamUtil.initReadTimeout();
        LOGGER.info("[settings] [http-client] read timeout:{}", (Object)readTimeout);
        clientVersion = VersionUtils.version;
        perTaskConfigSize = ParamUtil.initPerTaskConfigSize();
        LOGGER.info("PER_TASK_CONFIG_SIZE: {}", (Object)perTaskConfigSize);
    }
}

