/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.ExpressionSelector;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.client.address.ServerListChangeEvent;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.monitor.MetricsMonitor;
import com.alibaba.nacos.client.naming.core.NamingServerListManager;
import com.alibaba.nacos.client.naming.remote.AbstractNamingClientProxy;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientManager;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.naming.utils.UtilAndComs;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class NamingHttpClientProxy
extends AbstractNamingClientProxy {
    private final NacosRestTemplate nacosRestTemplate = NamingHttpClientManager.getInstance().getNacosRestTemplate();
    private static final int DEFAULT_SERVER_PORT = 8848;
    private static final String MODULE_NAME = "Naming";
    private static final String IP_PARAM = "ip";
    private static final String PORT_PARAM = "port";
    private static final String WEIGHT_PARAM = "weight";
    private static final String ENABLE_PARAM = "enabled";
    private static final String EPHEMERAL_PARAM = "ephemeral";
    private static final String META_PARAM = "metadata";
    private static final String SELECTOR_PARAM = "selector";
    private static final String HEALTHY_PARAM = "healthy";
    private static final String PROTECT_THRESHOLD_PARAM = "protectThreshold";
    private static final String CLUSTERS_PARAM = "clusters";
    private static final String CLIENT_IP_PARAM = "clientIP";
    private static final String HEALTHY_ONLY_PARAM = "healthyOnly";
    private static final String REGISTER_ENABLE_PARAM = "enable";
    private final String namespaceId;
    private final NamingServerListManager serverListManager;
    private final int maxRetry;
    private int serverPort = 8848;

    public NamingHttpClientProxy(String namespaceId, SecurityProxy securityProxy, NamingServerListManager serverListManager, NacosClientProperties properties) {
        super(securityProxy);
        this.serverListManager = serverListManager;
        this.setServerPort(8848);
        this.namespaceId = namespaceId;
        this.maxRetry = ConvertUtils.toInt(properties.getProperty("namingRequestDomainMaxRetryCount", String.valueOf(3)));
    }

    @Override
    public void onEvent(ServerListChangeEvent event) {
    }

    @Override
    public Class<? extends Event> subscribeType() {
        return ServerListChangeEvent.class;
    }

    @Override
    public void registerService(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[REGISTER-SERVICE] {} registering service {} with instance: {}", new Object[]{this.namespaceId, serviceName, instance});
        String groupedServiceName = NamingUtils.getGroupedName(serviceName, groupName);
        if (instance.isEphemeral()) {
            throw new UnsupportedOperationException("Do not support register ephemeral instances by HTTP, please use gRPC replaced.");
        }
        HashMap<String, String> params = new HashMap<String, String>(32);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", groupedServiceName);
        params.put("groupName", groupName);
        params.put("clusterName", instance.getClusterName());
        params.put(IP_PARAM, instance.getIp());
        params.put(PORT_PARAM, String.valueOf(instance.getPort()));
        params.put(WEIGHT_PARAM, String.valueOf(instance.getWeight()));
        params.put(REGISTER_ENABLE_PARAM, String.valueOf(instance.isEnabled()));
        params.put(HEALTHY_PARAM, String.valueOf(instance.isHealthy()));
        params.put(EPHEMERAL_PARAM, String.valueOf(instance.isEphemeral()));
        params.put(META_PARAM, JacksonUtils.toJson(instance.getMetadata()));
        this.reqApi(UtilAndComs.nacosUrlInstance, params, "POST");
    }

    @Override
    public void batchRegisterService(String serviceName, String groupName, List<Instance> instances) {
        throw new UnsupportedOperationException("Do not support persistent instances to perform batch registration methods.");
    }

    @Override
    public void batchDeregisterService(String serviceName, String groupName, List<Instance> instances) {
        throw new UnsupportedOperationException("Do not support persistent instances to perform batch de registration methods.");
    }

    @Override
    public void deregisterService(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[DEREGISTER-SERVICE] {} deregistering service {} with instance: {}", new Object[]{this.namespaceId, serviceName, instance});
        if (instance.isEphemeral()) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", NamingUtils.getGroupedName(serviceName, groupName));
        params.put("clusterName", instance.getClusterName());
        params.put(IP_PARAM, instance.getIp());
        params.put(PORT_PARAM, String.valueOf(instance.getPort()));
        params.put(EPHEMERAL_PARAM, String.valueOf(instance.isEphemeral()));
        this.reqApi(UtilAndComs.nacosUrlInstance, params, "DELETE");
    }

    @Override
    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[UPDATE-SERVICE] {} update service {} with instance: {}", new Object[]{this.namespaceId, serviceName, instance});
        HashMap<String, String> params = new HashMap<String, String>(32);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        params.put("clusterName", instance.getClusterName());
        params.put(IP_PARAM, instance.getIp());
        params.put(PORT_PARAM, String.valueOf(instance.getPort()));
        params.put(WEIGHT_PARAM, String.valueOf(instance.getWeight()));
        params.put(ENABLE_PARAM, String.valueOf(instance.isEnabled()));
        params.put(EPHEMERAL_PARAM, String.valueOf(instance.isEphemeral()));
        params.put(META_PARAM, JacksonUtils.toJson(instance.getMetadata()));
        this.reqApi(UtilAndComs.nacosUrlInstance, params, "PUT");
    }

    @Override
    public ServiceInfo queryInstancesOfService(String serviceName, String groupName, String clusters, boolean healthyOnly) {
        throw new UnsupportedOperationException("Do not support query instance by http client,please use gRPC replaced.");
    }

    @Override
    public Service queryService(String serviceName, String groupName) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[QUERY-SERVICE] {} query service : {}, {}", new Object[]{this.namespaceId, serviceName, groupName});
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        String result = this.reqApi(UtilAndComs.nacosUrlService, params, "GET");
        return JacksonUtils.toObj(result, Service.class);
    }

    @Override
    public void createService(Service service, AbstractSelector selector) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[CREATE-SERVICE] {} creating service : {}", (Object)this.namespaceId, (Object)service);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", service.getName());
        params.put("groupName", service.getGroupName());
        params.put(PROTECT_THRESHOLD_PARAM, String.valueOf(service.getProtectThreshold()));
        params.put(META_PARAM, JacksonUtils.toJson(service.getMetadata()));
        params.put(SELECTOR_PARAM, JacksonUtils.toJson(selector));
        this.reqApi(UtilAndComs.nacosUrlService, params, "POST");
    }

    @Override
    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[DELETE-SERVICE] {} deleting service : {} with groupName : {}", new Object[]{this.namespaceId, serviceName, groupName});
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", serviceName);
        params.put("groupName", groupName);
        String result = this.reqApi(UtilAndComs.nacosUrlService, params, "DELETE");
        return "ok".equals(result);
    }

    @Override
    public void updateService(Service service, AbstractSelector selector) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[UPDATE-SERVICE] {} updating service : {}", (Object)this.namespaceId, (Object)service);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("namespaceId", this.namespaceId);
        params.put("serviceName", service.getName());
        params.put("groupName", service.getGroupName());
        params.put(PROTECT_THRESHOLD_PARAM, String.valueOf(service.getProtectThreshold()));
        params.put(META_PARAM, JacksonUtils.toJson(service.getMetadata()));
        params.put(SELECTOR_PARAM, JacksonUtils.toJson(selector));
        this.reqApi(UtilAndComs.nacosUrlService, params, "PUT");
    }

    @Override
    public boolean serverHealthy() {
        try {
            String result = this.reqApi(UtilAndComs.nacosUrlBase + "/operator/metrics", new HashMap<String, String>(8), "GET");
            JsonNode json = JacksonUtils.toObj(result);
            String serverStatus = json.get("status").asText();
            return "UP".equals(serverStatus);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("pageNo", String.valueOf(pageNo));
        params.put("pageSize", String.valueOf(pageSize));
        params.put("namespaceId", this.namespaceId);
        params.put("groupName", groupName);
        if (selector != null) {
            switch (SelectorType.valueOf(selector.getType())) {
                case none: {
                    break;
                }
                case label: {
                    ExpressionSelector expressionSelector = (ExpressionSelector)selector;
                    params.put(SELECTOR_PARAM, JacksonUtils.toJson(expressionSelector));
                    break;
                }
            }
        }
        String result = this.reqApi(UtilAndComs.nacosUrlBase + "/service/list", params, "GET");
        JsonNode json = JacksonUtils.toObj(result);
        ListView<String> listView = new ListView<String>();
        listView.setCount(json.get("count").asInt());
        listView.setData(JacksonUtils.toObj(json.get("doms").toString(), new TypeReference<List<String>>(){}));
        return listView;
    }

    @Override
    public ServiceInfo subscribe(String serviceName, String groupName, String clusters) throws NacosException {
        throw new UnsupportedOperationException("Do not support subscribe service by UDP, please use gRPC replaced.");
    }

    @Override
    public void unsubscribe(String serviceName, String groupName, String clusters) throws NacosException {
    }

    @Override
    public boolean isSubscribed(String serviceName, String groupName, String clusters) throws NacosException {
        return true;
    }

    public String reqApi(String api, Map<String, String> params, String method) throws NacosException {
        return this.reqApi(api, params, Collections.EMPTY_MAP, method);
    }

    public String reqApi(String api, Map<String, String> params, Map<String, String> body, String method) throws NacosException {
        return this.reqApi(api, params, body, this.serverListManager.getServerList(), method);
    }

    public String reqApi(String api, Map<String, String> params, Map<String, String> body, List<String> servers, String method) throws NacosException {
        params.put("namespaceId", this.getNamespaceId());
        if (CollectionUtils.isEmpty(servers) && !this.serverListManager.isDomain()) {
            throw new NacosException(400, "no server available");
        }
        NacosException exception = new NacosException();
        if (this.serverListManager.isDomain()) {
            String nacosDomain = this.serverListManager.getNacosDomain();
            for (int i = 0; i < this.maxRetry; ++i) {
                try {
                    return this.callServer(api, params, body, nacosDomain, method);
                }
                catch (NacosException e) {
                    exception = e;
                    if (!LogUtils.NAMING_LOGGER.isDebugEnabled()) continue;
                    LogUtils.NAMING_LOGGER.debug("request {} failed.", (Object)nacosDomain, (Object)e);
                    continue;
                }
            }
        } else {
            Random random = new Random();
            int index = random.nextInt(servers.size());
            for (int i = 0; i < servers.size(); ++i) {
                String server = servers.get(index);
                try {
                    return this.callServer(api, params, body, server, method);
                }
                catch (NacosException e) {
                    exception = e;
                    if (LogUtils.NAMING_LOGGER.isDebugEnabled()) {
                        LogUtils.NAMING_LOGGER.debug("request {} failed.", (Object)server, (Object)e);
                    }
                    index = (index + 1) % servers.size();
                    continue;
                }
            }
        }
        LogUtils.NAMING_LOGGER.error("request: {} failed, servers: {}, code: {}, msg: {}", new Object[]{api, servers, exception.getErrCode(), exception.getErrMsg()});
        throw new NacosException(exception.getErrCode(), "failed to req API:" + api + " after all servers(" + servers + ") tried: " + exception.getMessage());
    }

    public String callServer(String api, Map<String, String> params, Map<String, String> body, String curServer, String method) throws NacosException {
        String url;
        long start = System.currentTimeMillis();
        long end = 0L;
        String namespace = params.get("namespaceId");
        String group = params.get("groupName");
        String serviceName = params.get("serviceName");
        params.putAll(this.getSecurityHeaders(namespace, group, serviceName));
        Header header = HttpUtils.builderHeader(MODULE_NAME);
        if (curServer.startsWith("https://") || curServer.startsWith("http://")) {
            url = curServer + api;
        } else {
            if (!InternetAddressUtil.containsPort(curServer)) {
                curServer = curServer + ":" + this.serverPort;
            }
            url = NamingHttpClientManager.getInstance().getPrefix() + curServer + api;
        }
        try {
            HttpRestResult restResult = this.nacosRestTemplate.exchangeForm(url, header, Query.newInstance().initParams(params), body, method, (Type)((Object)String.class));
            end = System.currentTimeMillis();
            MetricsMonitor.getNamingRequestMonitor(method, url, String.valueOf(restResult.getCode())).observe((double)(end - start));
            if (restResult.ok()) {
                return (String)restResult.getData();
            }
            if (304 == restResult.getCode()) {
                return "";
            }
            if (403 == restResult.getCode()) {
                this.reLogin();
            }
            throw new NacosException(restResult.getCode(), restResult.getMessage());
        }
        catch (NacosException e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to request", (Throwable)e);
            throw new NacosException(500, (Throwable)e);
        }
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
        String sp = NacosClientProperties.PROTOTYPE.getProperty("nacos.naming.exposed.port");
        if (StringUtils.isNotBlank(sp)) {
            this.serverPort = Integer.parseInt(sp);
        }
    }

    @Override
    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        NamingHttpClientManager.getInstance().shutdown();
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

