/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ServiceInfo {
    private static final int GROUP_POSITION = 0;
    private static final int SERVICE_POSITION = 1;
    private static final int CLUSTER_POSITION = 2;
    private static final int FILE_NAME_PARTS = 3;
    @JsonIgnore
    private String jsonFromServer = "";
    private static final String EMPTY = "";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private String name;
    private String groupName;
    private String clusters;
    private long cacheMillis = 1000L;
    private List<Instance> hosts = new ArrayList<Instance>();
    private long lastRefTime = 0L;
    private String checksum = "";
    private volatile boolean allIPs = false;
    private volatile boolean reachProtectionThreshold = false;

    public ServiceInfo() {
    }

    public boolean isAllIPs() {
        return this.allIPs;
    }

    public void setAllIPs(boolean allIPs) {
        this.allIPs = allIPs;
    }

    public ServiceInfo(String key) {
        String[] keys = key.split("@@");
        if (keys.length >= 3) {
            this.groupName = keys[0];
            this.name = keys[1];
            this.clusters = keys[2];
        } else if (keys.length == 2) {
            this.groupName = keys[0];
            this.name = keys[1];
        } else {
            throw new IllegalArgumentException("Can't parse out 'groupName',but it must not be null!");
        }
    }

    public ServiceInfo(String name, String clusters) {
        this.name = name;
        this.clusters = clusters;
    }

    public int ipCount() {
        return this.hosts.size();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.lastRefTime > this.cacheMillis;
    }

    public void setHosts(List<Instance> hosts) {
        this.hosts = hosts;
    }

    public void addHost(Instance host) {
        this.hosts.add(host);
    }

    public void addAllHosts(List<? extends Instance> hosts) {
        this.hosts.addAll(hosts);
    }

    public List<Instance> getHosts() {
        return new ArrayList<Instance>(this.hosts);
    }

    public boolean isValid() {
        return this.hosts != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setLastRefTime(long lastRefTime) {
        this.lastRefTime = lastRefTime;
    }

    public long getLastRefTime() {
        return this.lastRefTime;
    }

    public String getClusters() {
        return this.clusters;
    }

    public void setClusters(String clusters) {
        this.clusters = clusters;
    }

    public long getCacheMillis() {
        return this.cacheMillis;
    }

    public void setCacheMillis(long cacheMillis) {
        this.cacheMillis = cacheMillis;
    }

    public boolean validate() {
        if (this.isAllIPs()) {
            return true;
        }
        if (this.hosts == null) {
            return false;
        }
        boolean existValidHosts = false;
        for (Instance host : this.hosts) {
            if (!host.isHealthy() || !(host.getWeight() > 0.0)) continue;
            existValidHosts = true;
            break;
        }
        return existValidHosts;
    }

    @JsonIgnore
    public String getJsonFromServer() {
        return this.jsonFromServer;
    }

    public void setJsonFromServer(String jsonFromServer) {
        this.jsonFromServer = jsonFromServer;
    }

    @JsonIgnore
    public String getKey() {
        String serviceName = this.getGroupedServiceName();
        return ServiceInfo.getKey(serviceName, this.clusters);
    }

    @JsonIgnore
    public static String getKey(String name, String clusters) {
        if (!ServiceInfo.isEmpty(clusters)) {
            return name + "@@" + clusters;
        }
        return name;
    }

    @JsonIgnore
    public String getKeyWithoutClusters() {
        return this.getGroupedServiceName();
    }

    @JsonIgnore
    public String getKeyEncoded() {
        String serviceName = this.getGroupedServiceName();
        try {
            serviceName = URLEncoder.encode(serviceName, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ServiceInfo.getKey(serviceName, this.clusters);
    }

    private String getGroupedServiceName() {
        String serviceName = this.name;
        if (!ServiceInfo.isEmpty(this.groupName) && !serviceName.contains("@@")) {
            serviceName = this.groupName + "@@" + serviceName;
        }
        return serviceName;
    }

    public static ServiceInfo fromKey(String key) {
        return new ServiceInfo(key);
    }

    public String toString() {
        return this.getKey();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public boolean isReachProtectionThreshold() {
        return this.reachProtectionThreshold;
    }

    public void setReachProtectionThreshold(boolean reachProtectionThreshold) {
        this.reachProtectionThreshold = reachProtectionThreshold;
    }
}

