package com.alibaba.nacos.shaded.org.checkerframework.checker.index.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.SubtypeOf;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.TargetLocations;
import com.alibaba.nacos.shaded.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * The bottom type of the lower bound type system. A variable annotated with this value cannot take
 * on any integer values.
 *
 * @checker_framework.manual #index-checker Index Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@SubtypeOf({Positive.class})
public @interface LowerBoundBottom {}
