/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.spring.http.codec;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.AfterFilter;
import com.alibaba.fastjson2.filter.BeforeFilter;
import com.alibaba.fastjson2.filter.ContextNameFilter;
import com.alibaba.fastjson2.filter.ContextValueFilter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.LabelFilter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.codec.json.AbstractJackson2Encoder;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;

public class Fastjson2Encoder
extends AbstractJackson2Encoder {
    private final FastJsonConfig config;

    public Fastjson2Encoder(ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
        this.config = new FastJsonConfig();
    }

    public Fastjson2Encoder(ObjectMapper mapper, FastJsonConfig config, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
        this.config = config;
    }

    @NonNull
    public DataBuffer encodeValue(@Nullable Object value, @NonNull DataBufferFactory bufferFactory, @NonNull ResolvableType valueType, MimeType mimeType, Map<String, Object> hints) {
        DataBuffer dataBuffer;
        block14: {
            this.logValue(hints, value);
            if (value instanceof String && JSON.isValidObject((String)((String)value))) {
                byte[] strBytes = ((String)value).getBytes(this.config.getCharset());
                DataBuffer buffer = bufferFactory.allocateBuffer(strBytes.length);
                buffer.write(strBytes, 0, strBytes.length);
                Hints.touchDataBuffer((DataBuffer)buffer, hints, (Log)this.logger);
                return buffer;
            }
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Feature[])this.config.getWriterFeatures());
            try {
                if (value == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(value);
                    this.configFilter(writer.context, this.config.getWriterFilters());
                    Class<?> valueClass = value.getClass();
                    ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                    objectWriter.write(writer, value, null, null, 0L);
                }
                DataBuffer buffer = bufferFactory.allocateBuffer(writer.size());
                writer.flushTo(buffer.asOutputStream());
                Hints.touchDataBuffer((DataBuffer)buffer, hints, (Log)this.logger);
                dataBuffer = buffer;
                if (writer == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new JSONException("JSON#writeTo cannot serialize '" + value + "' to 'OutputStream'", (Throwable)e);
                    }
                }
                catch (JSONException ex) {
                    throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
                }
            }
            writer.close();
        }
        return dataBuffer;
    }

    private void configFilter(JSONWriter.Context context, Filter ... filters) {
        if (filters == null) {
            return;
        }
        for (Filter filter : filters) {
            NameFilter f;
            if (filter instanceof NameFilter) {
                f = (NameFilter)filter;
                if (context.getNameFilter() == null) {
                    context.setNameFilter(f);
                } else {
                    context.setNameFilter(NameFilter.compose((NameFilter)context.getNameFilter(), (NameFilter)f));
                }
            }
            if (filter instanceof ValueFilter) {
                f = (ValueFilter)filter;
                if (context.getValueFilter() == null) {
                    context.setValueFilter((ValueFilter)f);
                } else {
                    context.setValueFilter(ValueFilter.compose((ValueFilter)context.getValueFilter(), (ValueFilter)f));
                }
            }
            if (filter instanceof PropertyFilter) {
                f = (PropertyFilter)filter;
                context.setPropertyFilter((PropertyFilter)f);
            }
            if (filter instanceof PropertyPreFilter) {
                f = (PropertyPreFilter)filter;
                context.setPropertyPreFilter((PropertyPreFilter)f);
            }
            if (filter instanceof BeforeFilter) {
                f = (BeforeFilter)filter;
                context.setBeforeFilter((BeforeFilter)f);
            }
            if (filter instanceof AfterFilter) {
                f = (AfterFilter)filter;
                context.setAfterFilter((AfterFilter)f);
            }
            if (filter instanceof LabelFilter) {
                f = (LabelFilter)filter;
                context.setLabelFilter((LabelFilter)f);
            }
            if (filter instanceof ContextValueFilter) {
                f = (ContextValueFilter)filter;
                context.setContextValueFilter((ContextValueFilter)f);
            }
            if (!(filter instanceof ContextNameFilter)) continue;
            f = (ContextNameFilter)filter;
            context.setContextNameFilter((ContextNameFilter)f);
        }
    }

    private void logValue(@Nullable Map<String, Object> hints, Object value) {
        if (!Hints.isLoggingSuppressed(hints)) {
            LogFormatUtils.traceDebug((Log)this.logger, traceOn -> {
                String formatted = LogFormatUtils.formatValue((Object)value, (traceOn == false ? 1 : 0) != 0);
                return Hints.getLogPrefix((Map)hints) + "Encoding [" + formatted + "]";
            });
        }
    }
}

