/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.codegen;

import com.alibaba.fastjson2.internal.codegen.FieldWriter;
import com.alibaba.fastjson2.internal.codegen.MethodWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ClassWriter {
    final String packageName;
    final String name;
    final Class superClass;
    final Class[] interfaces;
    private Set<String> imports = new TreeSet<String>();
    private List<FieldWriter> fields = new ArrayList<FieldWriter>();
    private List<MethodWriter> methods = new ArrayList<MethodWriter>();

    public ClassWriter(String packageName, String name, Class superClass, Class[] interfaces) {
        this.packageName = packageName;
        this.name = name;
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    public MethodWriter method(int modifiers, String name, Class returnType, Class[] paramTypes, String[] paramNames) {
        MethodWriter mw = new MethodWriter(this, modifiers, name, returnType, paramTypes, paramNames);
        this.methods.add(mw);
        return mw;
    }

    static String getTypeName(Class type) {
        String className;
        Package pkg = type.getPackage();
        if (pkg != null && "java.lang".equals(pkg.getName()) && !type.isArray()) {
            return type.getSimpleName();
        }
        if (type.isArray()) {
            className = ClassWriter.getTypeName(type.getComponentType()) + "[]";
        } else {
            className = type.getName();
            className = className.replace('$', '.');
        }
        return className;
    }

    public FieldWriter field(int modifier, String name, Class fieldClass) {
        FieldWriter fw = new FieldWriter(modifier, name, fieldClass);
        this.fields.add(fw);
        return fw;
    }

    protected void toString(StringBuilder buf) {
        if (this.packageName != null && !this.packageName.isEmpty()) {
            buf.append("package ").append(this.packageName).append(";\n\n");
        }
        if (!this.imports.isEmpty()) {
            for (String item : this.imports) {
                buf.append("import ").append(item).append(";\n");
            }
        }
        buf.append("public final class ").append(this.name);
        if (this.superClass != null) {
            buf.append("\n\t\textends ").append(ClassWriter.getTypeName(this.superClass));
        }
        buf.append(" {\n");
        for (FieldWriter fw : this.fields) {
            buf.append('\t').append(ClassWriter.getTypeName(fw.fieldClass)).append(' ').append(fw.name).append(";\n");
        }
        if (!this.fields.isEmpty()) {
            buf.append("\n");
        }
        for (int i = 0; i < this.methods.size(); ++i) {
            if (i != 0) {
                buf.append("\n");
            }
            MethodWriter mw = this.methods.get(i);
            mw.toString(buf);
            buf.append("\n");
        }
        buf.append("}");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }
}

