/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.processor;

import com.alibaba.fastjson2.internal.processor.Analysis;
import com.alibaba.fastjson2.internal.processor.AttributeInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class StructInfo {
    final int modifiers;
    final boolean referenceDetect;
    final boolean disableJSONB;
    final boolean disableAutoType;
    final boolean disableArrayMapping;
    String typeKey;
    int readerFeatures;
    int writerFeatures;
    final TypeElement element;
    final String name;
    final String binaryName;
    final Map<String, AttributeInfo> attributes = new LinkedHashMap<String, AttributeInfo>();

    public StructInfo(Types types, TypeElement element, DeclaredType jsonCompiledDeclaredType, DeclaredType jsonTypeDeclaredType, String name, String binaryName) {
        boolean bl;
        this.element = element;
        this.name = name;
        this.binaryName = binaryName;
        this.modifiers = Analysis.getModifiers(element.getModifiers());
        AnnotationMirror jsonType = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!types.isSameType(annotationType, jsonTypeDeclaredType)) continue;
            jsonType = annotationMirror;
        }
        boolean referenceDetect = true;
        boolean bl2 = false;
        boolean disableAutoType = false;
        boolean disableArrayMapping = false;
        if (jsonType != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : jsonType.getElementValues().entrySet()) {
                String annFieldName = entry.getKey().getSimpleName().toString();
                AnnotationValue value = entry.getValue();
                switch (annFieldName) {
                    case "disableReferenceDetect": {
                        referenceDetect = (Boolean)value.getValue() == false;
                        break;
                    }
                    case "disableJSONB": {
                        bl = (Boolean)value.getValue();
                        break;
                    }
                    case "disableAutoType": {
                        disableAutoType = (Boolean)value.getValue();
                        break;
                    }
                    case "disableArrayMapping": {
                        disableArrayMapping = (Boolean)value.getValue();
                        break;
                    }
                }
            }
        }
        this.referenceDetect = referenceDetect;
        this.disableJSONB = bl;
        this.disableAutoType = disableAutoType;
        this.disableArrayMapping = disableArrayMapping;
    }

    public AttributeInfo getAttributeByField(String name, VariableElement field) {
        AttributeInfo origin;
        AttributeInfo attr = this.attributes.get(name);
        TypeMirror type = field.asType();
        if (attr == null && (origin = this.attributes.putIfAbsent(name, attr = new AttributeInfo(name, field.asType(), field, null, null, null))) != null) {
            attr = origin;
        }
        attr.field = field;
        return attr;
    }

    public AttributeInfo getAttributeByMethod(String name, TypeMirror type, ExecutableElement getter, ExecutableElement setter) {
        AttributeInfo origin;
        AttributeInfo attr = this.attributes.get(name);
        if (attr == null && (origin = this.attributes.putIfAbsent(name, attr = new AttributeInfo(name, type, null, getter, setter, null))) != null) {
            attr = origin;
        }
        if (getter != null) {
            attr.getMethod = getter;
        }
        if (setter != null) {
            attr.setMethod = setter;
        }
        return attr;
    }

    public List<AttributeInfo> getReaderAttributes() {
        return this.attributes.values().stream().filter(AttributeInfo::supportSet).sorted().collect(Collectors.toList());
    }
}

