/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.processor;

import com.alibaba.fastjson2.internal.processor.CodeGenUtils;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class JavacTreeUtils {
    private static TreeMaker treeMaker;
    private static Names names;
    private static Elements elements;

    private JavacTreeUtils() {
        throw new UnsupportedOperationException("this class can not be instantiated");
    }

    static void initialize(TreeMaker _treeMaker, Names _names, Elements _elements) {
        treeMaker = _treeMaker;
        names = _names;
        elements = _elements;
    }

    static ProcessingEnvironment unwrapProcessingEnv(ProcessingEnvironment processingEnv) {
        if (processingEnv instanceof JavacProcessingEnvironment) {
            return processingEnv;
        }
        ProcessingEnvironment unwrappedIntelliJ = JavacTreeUtils.unwrapIntelliJ(processingEnv);
        if (unwrappedIntelliJ != null) {
            return JavacTreeUtils.unwrapProcessingEnv(unwrappedIntelliJ);
        }
        for (Class<?> envClass = processingEnv.getClass(); envClass != null; envClass = envClass.getSuperclass()) {
            ProcessingEnvironment unwrappedGradle = JavacTreeUtils.unwrapGradle(envClass, processingEnv);
            if (unwrappedGradle == null) continue;
            return JavacTreeUtils.unwrapProcessingEnv(unwrappedGradle);
        }
        throw new IllegalArgumentException("failed to retrieve JavacProcessingEnvironment");
    }

    private static ProcessingEnvironment unwrapIntelliJ(ProcessingEnvironment processingEnv) {
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(processingEnv);
            Field field = handler.getClass().getDeclaredField("val$delegateTo");
            field.setAccessible(true);
            Object object = field.get(handler);
            if (object instanceof ProcessingEnvironment) {
                return (ProcessingEnvironment)object;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static ProcessingEnvironment unwrapGradle(Class<?> delegateClass, ProcessingEnvironment processingEnv) {
        try {
            Field field = delegateClass.getDeclaredField("delegate");
            field.setAccessible(true);
            Object object = field.get(processingEnv);
            if (object instanceof ProcessingEnvironment) {
                return (ProcessingEnvironment)object;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    static JCTree.JCLiteral defNull() {
        return JavacTreeUtils.literal(TypeTag.BOT, null);
    }

    static Name name(String name) {
        return names.fromString(name);
    }

    static JCTree.JCIdent ident(String name) {
        return treeMaker.Ident(JavacTreeUtils.name(name));
    }

    static JCTree.JCIdent ident(Name name) {
        return treeMaker.Ident(name);
    }

    static JCTree.JCExpression qualIdent(String name) {
        TypeElement typeElement = elements.getTypeElement(name);
        if (typeElement != null) {
            return treeMaker.QualIdent((Symbol)((Object)typeElement));
        }
        return JavacTreeUtils.ident(JavacTreeUtils.name(name));
    }

    static JCTree.JCExpression arrayIdent(String name) {
        JCTree.JCExpression elemTypeExpr;
        int idx = name.indexOf("[");
        String type = name.substring(0, idx);
        int count = 0;
        for (char c : name.substring(idx).toCharArray()) {
            if (c != '[') continue;
            ++count;
        }
        switch (type) {
            case "int": {
                elemTypeExpr = treeMaker.TypeIdent(TypeTag.INT);
                break;
            }
            case "long": {
                elemTypeExpr = treeMaker.TypeIdent(TypeTag.LONG);
                break;
            }
            case "float": {
                elemTypeExpr = treeMaker.TypeIdent(TypeTag.FLOAT);
                break;
            }
            case "double": {
                elemTypeExpr = treeMaker.TypeIdent(TypeTag.DOUBLE);
                break;
            }
            case "boolean": {
                elemTypeExpr = treeMaker.TypeIdent(TypeTag.BOOLEAN);
                break;
            }
            case "char": {
                elemTypeExpr = treeMaker.TypeIdent(TypeTag.CHAR);
                break;
            }
            case "byte": {
                elemTypeExpr = treeMaker.TypeIdent(TypeTag.BYTE);
                break;
            }
            case "short": {
                elemTypeExpr = treeMaker.TypeIdent(TypeTag.SHORT);
                break;
            }
            default: {
                elemTypeExpr = JavacTreeUtils.qualIdent(type);
            }
        }
        return JavacTreeUtils.arrayType(elemTypeExpr, count);
    }

    private static JCTree.JCArrayTypeTree arrayType(JCTree.JCExpression elemTypeExpr, int dims) {
        if (dims == 1) {
            return treeMaker.TypeArray(elemTypeExpr);
        }
        return treeMaker.TypeArray(JavacTreeUtils.arrayType(elemTypeExpr, dims - 1));
    }

    static JCTree.JCTypeApply collectionIdent(String type) {
        return JavacTreeUtils.collectionType(type);
    }

    private static JCTree.JCTypeApply collectionType(String type) {
        int open = type.indexOf("<");
        int close = type.indexOf(">");
        String clazz = type.substring(0, open);
        if (close == type.length() - 1) {
            String args = type.substring(open + 1, close);
            ListBuffer<JCTree.JCExpression> generics = new ListBuffer<JCTree.JCExpression>();
            for (String g : args.split(",")) {
                generics.append(JavacTreeUtils.qualIdent(g));
            }
            return JavacTreeUtils.typeApply(JavacTreeUtils.qualIdent(clazz), generics.toList());
        }
        return JavacTreeUtils.typeApply(JavacTreeUtils.qualIdent(clazz), List.of(JavacTreeUtils.collectionType(type.substring(open + 1, close + 1))));
    }

    static JCTree.JCVariableDecl defVar(long flag, String identName, JCTree.JCExpression identType) {
        return JavacTreeUtils.defVar(flag, identName, identType, null);
    }

    static JCTree.JCVariableDecl defVar(long flag, String identName, JCTree.JCExpression identType, JCTree.JCExpression init) {
        return treeMaker.VarDef(JavacTreeUtils.modifiers(flag), JavacTreeUtils.name(identName), identType, init);
    }

    static JCTree.JCMethodDecl defMethod(long flag, String name, JCTree.JCExpression rtnType, List<JCTree.JCTypeParameter> typeArgs, List<JCTree.JCVariableDecl> params, List<JCTree.JCExpression> recvArgs, JCTree.JCBlock block, JCTree.JCExpression defaultValue) {
        return JavacTreeUtils.defMethod(flag, JavacTreeUtils.name(name), rtnType, typeArgs, params, recvArgs, block, defaultValue);
    }

    static JCTree.JCMethodDecl defMethod(long flag, Name name, JCTree.JCExpression rtnType, List<JCTree.JCTypeParameter> typeArgs, List<JCTree.JCVariableDecl> params, List<JCTree.JCExpression> recvArgs, JCTree.JCBlock block, JCTree.JCExpression defaultValue) {
        if (typeArgs == null) {
            typeArgs = List.nil();
        }
        if (params == null) {
            params = List.nil();
        }
        if (recvArgs == null) {
            recvArgs = List.nil();
        }
        return treeMaker.MethodDef(JavacTreeUtils.modifiers(flag), name, rtnType, typeArgs, params, recvArgs, block, defaultValue);
    }

    static JCTree.JCMethodInvocation method(JCTree.JCExpression method) {
        return JavacTreeUtils.method(null, method, null);
    }

    static JCTree.JCMethodInvocation method(JCTree.JCExpression method, List<JCTree.JCExpression> args) {
        return JavacTreeUtils.method(null, method, args);
    }

    static JCTree.JCMethodInvocation method(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression method, List<JCTree.JCExpression> args) {
        if (typeArgs == null) {
            typeArgs = List.nil();
        }
        if (args == null) {
            args = List.nil();
        }
        return treeMaker.Apply(typeArgs, method, args);
    }

    static JCTree.JCFieldAccess field(JCTree.JCExpression expr, String name) {
        return treeMaker.Select(expr, JavacTreeUtils.name(name));
    }

    static JCTree.JCFieldAccess field(JCTree.JCExpression expr, Name name) {
        return treeMaker.Select(expr, name);
    }

    static JCTree.JCModifiers modifiers(long flag) {
        return treeMaker.Modifiers(flag);
    }

    static JCTree.JCExpressionStatement exec(JCTree.JCExpression expr) {
        return treeMaker.Exec(expr);
    }

    static JCTree.JCAssign assign(JCTree.JCExpression expr1, JCTree.JCExpression expr2) {
        return treeMaker.Assign(expr1, expr2);
    }

    static JCTree.JCIf defIf(JCTree.JCExpression cond, JCTree.JCStatement thenStmt, JCTree.JCStatement elseStmt) {
        return treeMaker.If(cond, thenStmt, elseStmt);
    }

    static JCTree.JCBinary binary(JCTree.Tag tag, JCTree.JCExpression expr1, JCTree.JCExpression expr2) {
        return treeMaker.Binary(tag, expr1, expr2);
    }

    static JCTree.JCUnary unary(JCTree.Tag tag, JCTree.JCExpression expr) {
        return treeMaker.Unary(tag, expr);
    }

    static JCTree.JCBlock block(JCTree.JCStatement stmt) {
        return JavacTreeUtils.block(0L, stmt);
    }

    static JCTree.JCBlock block(long pos, JCTree.JCStatement stmt) {
        return JavacTreeUtils.block(pos, List.of(stmt));
    }

    static JCTree.JCBlock block(List<JCTree.JCStatement> stmts) {
        return JavacTreeUtils.block(0L, stmts);
    }

    static JCTree.JCBlock block(long pos, List<JCTree.JCStatement> stmts) {
        return treeMaker.Block(pos, stmts);
    }

    static JCTree.JCLiteral literal(TypeTag tag, Object object) {
        return treeMaker.Literal(tag, object);
    }

    static JCTree.JCLiteral literal(Object object) {
        return treeMaker.Literal(object);
    }

    static JCTree.JCTypeCast cast(JCTree type, JCTree.JCExpression expr) {
        return treeMaker.TypeCast(type, expr);
    }

    static JCTree.JCNewClass newClass(JCTree.JCExpression encl, List<JCTree.JCExpression> typeArgs, JCTree.JCExpression clazz, List<JCTree.JCExpression> args, JCTree.JCClassDecl def) {
        if (typeArgs == null) {
            typeArgs = List.nil();
        }
        if (args == null) {
            args = List.nil();
        }
        return treeMaker.NewClass(encl, typeArgs, clazz, args, def);
    }

    static JCTree.JCPrimitiveTypeTree type(TypeTag tag) {
        return treeMaker.TypeIdent(tag);
    }

    static JCTree.JCLabeledStatement label(String name, JCTree.JCStatement stmt) {
        return treeMaker.Labelled(JavacTreeUtils.name(name), stmt);
    }

    static JCTree.JCBreak defBreak(JCTree.JCLabeledStatement labeledStatement) {
        Class<?> clazz = treeMaker.getClass();
        try {
            Method method = clazz.getDeclaredMethod("Break", Name.class);
            return (JCTree.JCBreak)method.invoke((Object)treeMaker, labeledStatement.label);
        }
        catch (Exception e) {
            try {
                Method method = clazz.getDeclaredMethod("Break", JCTree.JCExpression.class);
                return (JCTree.JCBreak)method.invoke((Object)treeMaker, new Object[]{null});
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static JCTree.JCContinue defContinue(JCTree.JCLabeledStatement labeledStatement) {
        return JavacTreeUtils.defContinue(labeledStatement.label);
    }

    static JCTree.JCContinue defContinue(Name name) {
        return treeMaker.Continue(name);
    }

    static JCTree.JCForLoop forLoop(List<JCTree.JCStatement> initStmts, JCTree.JCExpression condExpr, List<JCTree.JCExpressionStatement> stepExprs, JCTree.JCStatement bodyStmt) {
        if (initStmts == null) {
            initStmts = List.nil();
        }
        if (stepExprs == null) {
            stepExprs = List.nil();
        }
        return treeMaker.ForLoop(initStmts, condExpr, stepExprs, bodyStmt);
    }

    static JCTree.JCCase defCase(JCTree.JCExpression matchExpr, List<JCTree.JCStatement> matchStmts) {
        if (matchStmts == null) {
            matchStmts = List.nil();
        }
        Class<?> clazz = treeMaker.getClass();
        try {
            Method method = clazz.getDeclaredMethod("Case", JCTree.JCExpression.class, List.class);
            return (JCTree.JCCase)method.invoke((Object)treeMaker, matchExpr, matchStmts);
        }
        catch (Exception e) {
            try {
                Class<?> caseKind = Class.forName("com.sun.source.tree.CaseTree$CaseKind");
                Field statement = Class.forName("com.sun.tools.javac.tree.JCTree$JCCase").getDeclaredField("STATEMENT");
                Method method = clazz.getDeclaredMethod("Case", caseKind, List.class, List.class, JCTree.class);
                if (CodeGenUtils.JVM_VERSION >= 19 && (matchExpr instanceof JCTree.JCLiteral || matchExpr instanceof JCTree.JCTypeCast)) {
                    Class<?> constantCaseLabel = Class.forName("com.sun.tools.javac.tree.JCTree$JCConstantCaseLabel");
                    Constructor<?> constructor = constantCaseLabel.getDeclaredConstructor(JCTree.JCExpression.class);
                    constructor.setAccessible(true);
                    return (JCTree.JCCase)method.invoke((Object)treeMaker, statement.get(null), List.of(constructor.newInstance(matchExpr)), List.of(JavacTreeUtils.block(matchStmts)), null);
                }
                return (JCTree.JCCase)method.invoke((Object)treeMaker, statement.get(null), List.of(matchExpr), List.of(JavacTreeUtils.block(matchStmts)), null);
            }
            catch (Exception e2) {
                try {
                    Class<?> caseKind = Class.forName("com.sun.source.tree.CaseTree$CaseKind");
                    Field statement = Class.forName("com.sun.tools.javac.tree.JCTree$JCCase").getDeclaredField("STATEMENT");
                    Method method = clazz.getDeclaredMethod("Case", caseKind, List.class, JCTree.JCExpression.class, List.class, JCTree.class);
                    if (matchExpr instanceof JCTree.JCLiteral || matchExpr instanceof JCTree.JCTypeCast) {
                        Class<?> constantCaseLabel = Class.forName("com.sun.tools.javac.tree.JCTree$JCConstantCaseLabel");
                        Constructor<?> constructor = constantCaseLabel.getDeclaredConstructor(JCTree.JCExpression.class);
                        constructor.setAccessible(true);
                        return (JCTree.JCCase)method.invoke((Object)treeMaker, statement.get(null), List.of(constructor.newInstance(matchExpr)), null, List.of(JavacTreeUtils.block(matchStmts)), null);
                    }
                    return (JCTree.JCCase)method.invoke((Object)treeMaker, statement.get(null), List.of(matchExpr), null, List.of(JavacTreeUtils.block(matchStmts)), null);
                }
                catch (Exception e3) {
                    throw new RuntimeException(e3);
                }
            }
        }
    }

    static JCTree.JCSwitch defSwitch(JCTree.JCExpression selectorExpr, List<JCTree.JCCase> cases) {
        if (cases == null) {
            cases = List.nil();
        }
        return treeMaker.Switch(selectorExpr, cases);
    }

    static JCTree.JCReturn defReturn(JCTree.JCExpression expr) {
        return treeMaker.Return(expr);
    }

    static JCTree.JCParens parens(JCTree.JCExpression expr) {
        return treeMaker.Parens(expr);
    }

    static JCTree.JCWhileLoop whileLoop(JCTree.JCExpression condExpr, JCTree.JCStatement bodyStmt) {
        return treeMaker.WhileLoop(condExpr, bodyStmt);
    }

    static JCTree.JCTypeApply typeApply(JCTree.JCExpression clazz, List<JCTree.JCExpression> args) {
        if (args == null) {
            args = List.nil();
        }
        return treeMaker.TypeApply(clazz, args);
    }

    static JCTree.JCArrayAccess indexed(JCTree.JCExpression indexedExpr, JCTree.JCExpression indexExpr) {
        return treeMaker.Indexed(indexedExpr, indexExpr);
    }

    static JCTree.JCLambda lambda(List<JCTree.JCVariableDecl> args, JCTree body) {
        if (args == null) {
            args = List.nil();
        }
        return treeMaker.Lambda(args, body);
    }

    static JCTree.JCMemberReference constructorRef(JCTree.JCExpression beanClass) {
        return treeMaker.Reference(MemberReferenceTree.ReferenceMode.NEW, JavacTreeUtils.names.init, beanClass, null);
    }

    static JCTree.JCMemberReference methodRef(JCTree.JCExpression beanClass, String methodName) {
        return treeMaker.Reference(MemberReferenceTree.ReferenceMode.INVOKE, names.fromString(methodName), beanClass, null);
    }

    static JCTree.JCNewArray newArray(JCTree.JCExpression elemTypeExpr, List<JCTree.JCExpression> dimsExprs, List<JCTree.JCExpression> elemDataExprs) {
        if (dimsExprs == null) {
            dimsExprs = List.nil();
        }
        return treeMaker.NewArray(elemTypeExpr, dimsExprs, elemDataExprs);
    }

    static JCTree.JCClassDecl defClass(long flag, String name, List<JCTree.JCTypeParameter> typeArgs, JCTree.JCExpression extendExpr, List<JCTree.JCExpression> implementExprs, List<JCTree> defs) {
        if (typeArgs == null) {
            typeArgs = List.nil();
        }
        if (implementExprs == null) {
            implementExprs = List.nil();
        }
        if (defs == null) {
            defs = List.nil();
        }
        return treeMaker.ClassDef(JavacTreeUtils.modifiers(flag), JavacTreeUtils.name(name), typeArgs, extendExpr, implementExprs, defs);
    }

    static JCTree.JCAnnotation annotation(JCTree type, List<JCTree.JCExpression> args) {
        if (args == null) {
            args = List.nil();
        }
        return treeMaker.Annotation(type, args);
    }

    static void pos(int pos) {
        JavacTreeUtils.treeMaker.pos = pos;
    }
}

