/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.processor;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONCompiled;
import com.alibaba.fastjson2.internal.codegen.Label;
import com.alibaba.fastjson2.internal.processor.Analysis;
import com.alibaba.fastjson2.internal.processor.AttributeInfo;
import com.alibaba.fastjson2.internal.processor.CodeGenUtils;
import com.alibaba.fastjson2.internal.processor.JavacTreeUtils;
import com.alibaba.fastjson2.internal.processor.StructInfo;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaders;
import com.alibaba.fastjson2.util.JDKUtils;
import com.google.googlejavaformat.java.Formatter;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"com.alibaba.fastjson2.annotation.JSONCompiled", "com.alibaba.fastjson2.annotation.JSONBuilder", "com.alibaba.fastjson2.annotation.JSONCreator", "com.alibaba.fastjson2.annotation.JSONField", "com.alibaba.fastjson2.annotation.JSONType"})
public class JSONCompiledAnnotationProcessor
extends AbstractProcessor {
    private Messager messager;
    private JavacTrees javacTrees;
    private Names names;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        ProcessingEnvironment unwrappedProcessingEnv = JavacTreeUtils.unwrapProcessingEnv(processingEnv);
        super.init(unwrappedProcessingEnv);
        this.messager = unwrappedProcessingEnv.getMessager();
        this.javacTrees = JavacTrees.instance(unwrappedProcessingEnv);
        Context context = ((JavacProcessingEnvironment)unwrappedProcessingEnv).getContext();
        this.names = Names.instance(context);
        JavacTreeUtils.initialize(TreeMaker.instance(context), this.names, unwrappedProcessingEnv.getElementUtils());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Analysis analysis = new Analysis(this.processingEnv);
        Set<? extends Element> compiledJsons = roundEnv.getElementsAnnotatedWith(analysis.jsonCompiledElement);
        if (!compiledJsons.isEmpty()) {
            analysis.processAnnotation(analysis.jsonCompiledDeclaredType, compiledJsons);
        }
        Map<String, StructInfo> structs = analysis.analyze();
        Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(JSONCompiled.class);
        elementsAnnotatedWith.forEach(element -> {
            StructInfo structInfo = (StructInfo)structs.get(element.toString());
            java.util.List<AttributeInfo> attributeInfos = structInfo.getReaderAttributes();
            int fieldsSize = attributeInfos.size();
            Class superClass = CodeGenUtils.getSuperClass(attributeInfos.size());
            JCTree tree = this.javacTrees.getTree((Element)element);
            JavacTreeUtils.pos(tree.pos);
            tree.accept(new TreeTranslator((Element)element, structInfo, superClass, fieldsSize, attributeInfos){
                final /* synthetic */ Element val$element;
                final /* synthetic */ StructInfo val$structInfo;
                final /* synthetic */ Class val$superClass;
                final /* synthetic */ int val$fieldsSize;
                final /* synthetic */ java.util.List val$attributeInfos;
                {
                    this.val$element = element;
                    this.val$structInfo = structInfo;
                    this.val$superClass = clazz;
                    this.val$fieldsSize = n;
                    this.val$attributeInfos = list;
                }

                @Override
                public void visitClassDef(JCTree.JCClassDecl beanClassDecl) {
                    super.visitClassDef(beanClassDecl);
                    String beanClassFQN = beanClassDecl.sym.toString();
                    if (this.val$element.toString().equals(beanClassFQN)) {
                        boolean generatedFields;
                        String innerClassFQN = JSONCompiledAnnotationProcessor.this.findConverterName(this.val$structInfo);
                        int dotIdx = innerClassFQN.lastIndexOf(46);
                        String innerClassName = innerClassFQN.substring(dotIdx + 1);
                        JCTree.JCExpression beanType = dotIdx == -1 ? JavacTreeUtils.ident(beanClassFQN) : JavacTreeUtils.qualIdent(beanClassFQN);
                        JCTree.JCNewClass beanNew = JavacTreeUtils.newClass(null, null, beanType, null, null);
                        JCTree.JCIdent objectType = JavacTreeUtils.ident("Object");
                        JSONCompiledAnnotationProcessor.this.addDeserializerClassIfAbsent(beanClassDecl, beanClassFQN, innerClassName);
                        JCTree.JCClassDecl innerClass = JSONCompiledAnnotationProcessor.this.genInnerClass(innerClassName, this.val$superClass);
                        boolean bl = generatedFields = this.val$fieldsSize < 128;
                        if (generatedFields) {
                            innerClass.defs = innerClass.defs.prependList(JSONCompiledAnnotationProcessor.this.genFields(this.val$attributeInfos, this.val$superClass));
                        }
                        innerClass.defs = innerClass.defs.append(JSONCompiledAnnotationProcessor.this.genConstructor(this.val$structInfo, beanType, beanNew, this.val$attributeInfos, this.val$superClass, generatedFields));
                        innerClass.defs = innerClass.defs.append(JSONCompiledAnnotationProcessor.this.genCreateInstance(objectType, beanNew));
                        innerClass.defs = innerClass.defs.append(JSONCompiledAnnotationProcessor.this.genReadObject(objectType, beanType, beanNew, this.val$attributeInfos, this.val$structInfo, false));
                        innerClass.defs = innerClass.defs.append(JSONCompiledAnnotationProcessor.this.genReadObject(objectType, beanType, beanNew, this.val$attributeInfos, this.val$structInfo, true));
                        beanClassDecl.defs = beanClassDecl.defs.append(innerClass);
                    }
                }
            });
        });
        return true;
    }

    private void addDeserializerClassIfAbsent(JCTree.JCClassDecl beanClassDecl, String beanClassFQN, String innerClassName) {
        JCTree.JCExpression jsonTypeIdent = JavacTreeUtils.qualIdent("com.alibaba.fastjson2.annotation.JSONType");
        List<JCTree.JCAnnotation> annotations = beanClassDecl.mods.annotations;
        Optional<JCTree.JCAnnotation> jsonTypeAnnoOpt = annotations.stream().filter(a -> a.getAnnotationType().type.tsym.toString().equals(jsonTypeIdent.type.tsym.toString())).findAny();
        int dotIdx = beanClassFQN.lastIndexOf(46);
        String beanClassName = beanClassFQN.substring(dotIdx + 1);
        JCTree.JCIdent lhs = JavacTreeUtils.ident("deserializer");
        JCTree.JCFieldAccess rhs = JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(beanClassName), innerClassName), this.names._class);
        if (jsonTypeAnnoOpt.isPresent()) {
            JCTree.JCAnnotation jsonTypeAnno = jsonTypeAnnoOpt.get();
            Optional<JCTree.JCAssign> jsonTypeAsgOpt = jsonTypeAnno.args.stream().map(a -> (JCTree.JCAssign)a).filter(a2 -> "deserializer".equals(a2.lhs.toString())).findAny();
            if (jsonTypeAsgOpt.isPresent()) {
                JCTree.JCAssign deserializerAssign = jsonTypeAsgOpt.get();
                if ("Void.class".equals(deserializerAssign.rhs.toString())) {
                    deserializerAssign.rhs = rhs;
                }
            } else {
                jsonTypeAnno.args = jsonTypeAnno.args.prepend(JavacTreeUtils.assign(lhs, rhs));
            }
        } else {
            JCTree.JCAnnotation jsonTypeAnno = JavacTreeUtils.annotation(jsonTypeIdent, List.of(JavacTreeUtils.assign(lhs, rhs)));
            beanClassDecl.mods.annotations = annotations.prepend(jsonTypeAnno);
        }
    }

    private JCTree.JCClassDecl genInnerClass(String className, Class superClass) {
        return JavacTreeUtils.defClass(9L, className, null, JavacTreeUtils.qualIdent(superClass.getName()), null, null);
    }

    private List<JCTree> genFields(java.util.List<AttributeInfo> attributeInfos, Class superClass) {
        int i;
        ListBuffer<JCTree.JCVariableDecl> stmts = new ListBuffer<JCTree.JCVariableDecl>();
        int fieldsSize = attributeInfos.size();
        JCTree.JCExpression fieldReaderType = JavacTreeUtils.qualIdent(FieldReader.class.getName());
        JCTree.JCExpression objectReaderType = JavacTreeUtils.qualIdent(ObjectReader.class.getName());
        if (superClass == ObjectReaderAdapter.class) {
            for (i = 0; i < fieldsSize; ++i) {
                stmts.append(JavacTreeUtils.defVar(2L, CodeGenUtils.fieldReader(i), fieldReaderType));
            }
            for (i = 0; i < fieldsSize; ++i) {
                stmts.append(JavacTreeUtils.defVar(2L, CodeGenUtils.fieldObjectReader(i), objectReaderType));
            }
        }
        for (i = 0; i < fieldsSize; ++i) {
            AttributeInfo field = attributeInfos.get(i);
            String fieldType = field.type.toString();
            if (!fieldType.startsWith("java.util.List<") && !fieldType.startsWith("java.util.Map<java.lang.String,")) continue;
            stmts.append(JavacTreeUtils.defVar(2L, CodeGenUtils.fieldItemObjectReader(i), objectReaderType));
        }
        return stmts.toList();
    }

    private JCTree.JCMethodDecl genConstructor(StructInfo structInfo, JCTree.JCExpression beanType, JCTree.JCNewClass beanNew, java.util.List<AttributeInfo> fields, Class superClass, boolean generatedFields) {
        JCTree.JCMemberReference lambda = JavacTreeUtils.constructorRef(beanType);
        JCTree.JCExpression fieldReaderType = JavacTreeUtils.qualIdent(FieldReader.class.getName());
        ListBuffer<JCTree.JCMethodInvocation> fieldReaders = new ListBuffer<JCTree.JCMethodInvocation>();
        JCTree.JCExpression objectReadersType = JavacTreeUtils.qualIdent(ObjectReaders.class.getName());
        int fieldsSize = fields.size();
        for (int i = 0; i < fieldsSize; ++i) {
            JCTree.JCMethodInvocation readerMethod = this.genFieldReader(beanType, fields.get(i), objectReadersType);
            if (readerMethod == null) continue;
            fieldReaders.append(readerMethod);
        }
        JCTree.JCNewArray fieldReadersArray = JavacTreeUtils.newArray(fieldReaderType, null, List.from(fieldReaders));
        long features = 0L;
        JCTree.JCMethodInvocation superMethod = JavacTreeUtils.method(JavacTreeUtils.ident(this.names._super), List.of(JavacTreeUtils.field(beanType, this.names._class), JavacTreeUtils.defNull(), JavacTreeUtils.defNull(), new JCTree.JCExpression[]{JavacTreeUtils.literal(TypeTag.LONG, features), lambda, JavacTreeUtils.defNull(), fieldReadersArray}));
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        stmts.append(JavacTreeUtils.exec(superMethod));
        if (superClass == ObjectReaderAdapter.class && generatedFields) {
            stmts.appendList(this.genInitFields(fieldsSize));
        }
        return JavacTreeUtils.defMethod(1L, this.names.init, (JCTree.JCExpression)JavacTreeUtils.type(TypeTag.VOID), null, null, null, JavacTreeUtils.block(stmts.toList()), null);
    }

    private JCTree.JCMethodInvocation genFieldReader(JCTree.JCExpression beanType, AttributeInfo attributeInfo, JCTree.JCExpression objectReadersType) {
        JCTree.JCExpression identType;
        if (attributeInfo.setMethod == null && attributeInfo.field == null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "not implemented yet");
            return null;
        }
        String fieldType = attributeInfo.type.toString();
        JCTree.JCLiteral fieldName = JavacTreeUtils.literal(attributeInfo.name);
        JCTree.JCFunctionalExpression lambda = null;
        if (attributeInfo.setMethod != null) {
            lambda = JavacTreeUtils.methodRef(beanType, attributeInfo.setMethod.getSimpleName().toString());
        }
        String methodName = null;
        switch (fieldType) {
            case "byte": {
                methodName = "fieldReaderByte";
                identType = JavacTreeUtils.type(TypeTag.BYTE);
                break;
            }
            case "short": {
                identType = JavacTreeUtils.type(TypeTag.SHORT);
                methodName = "fieldReaderShort";
                break;
            }
            case "int": {
                identType = JavacTreeUtils.type(TypeTag.INT);
                methodName = "fieldReaderInt";
                break;
            }
            case "long": {
                identType = JavacTreeUtils.type(TypeTag.LONG);
                methodName = "fieldReaderLong";
                break;
            }
            case "char": {
                identType = JavacTreeUtils.type(TypeTag.CHAR);
                methodName = "fieldReaderChar";
                break;
            }
            case "float": {
                identType = JavacTreeUtils.type(TypeTag.FLOAT);
                methodName = "fieldReaderFloat";
                break;
            }
            case "double": {
                identType = JavacTreeUtils.type(TypeTag.DOUBLE);
                methodName = "fieldReaderDouble";
                break;
            }
            case "boolean": {
                identType = JavacTreeUtils.type(TypeTag.BOOLEAN);
                methodName = "fieldReaderBool";
                break;
            }
            case "java.lang.String": {
                identType = JavacTreeUtils.qualIdent("java.lang.String");
                methodName = "fieldReaderString";
                break;
            }
            default: {
                identType = this.getFieldValueType(fieldType);
            }
        }
        if (lambda == null) {
            JCTree.JCVariableDecl object = JavacTreeUtils.defVar(0x200000000L, "o", beanType);
            JCTree.JCExpression valueType = identType;
            if (fieldType.startsWith("java.util.Map<")) {
                valueType = JavacTreeUtils.qualIdent("java.util.Map");
            }
            JCTree.JCVariableDecl fieldValue = JavacTreeUtils.defVar(0x200000000L, "v", valueType);
            List<JCTree.JCVariableDecl> args = List.of(object, fieldValue);
            lambda = JavacTreeUtils.lambda(args, JavacTreeUtils.assign(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident("o"), attributeInfo.field.getSimpleName().toString()), JavacTreeUtils.ident("v")));
        }
        if (methodName != null) {
            return JavacTreeUtils.method(JavacTreeUtils.field(objectReadersType, methodName), List.of(fieldName, lambda));
        }
        JCTree.JCMethodInvocation readerMethod = this.genFieldReaderList(objectReadersType, fieldType, fieldName, lambda);
        if (readerMethod != null) {
            return readerMethod;
        }
        readerMethod = this.genFieldReaderMap(objectReadersType, fieldType, fieldName, lambda);
        if (readerMethod != null) {
            return readerMethod;
        }
        if (fieldType.indexOf(60) == -1) {
            readerMethod = JavacTreeUtils.method(JavacTreeUtils.field(objectReadersType, "fieldReader"), List.of(fieldName, JavacTreeUtils.field(this.getFieldValueType(fieldType), this.names._class), lambda));
        } else {
            List<JCTree.JCExpression> args;
            String fieldReaderMethodName;
            JCTree.JCFieldAccess fieldClassRef = JavacTreeUtils.field(beanType, this.names._class);
            if (attributeInfo.setMethod != null) {
                fieldReaderMethodName = "fieldReaderWithMethod";
                args = List.of(JavacTreeUtils.literal(attributeInfo.name), fieldClassRef, JavacTreeUtils.literal(methodName));
            } else {
                JCTree.JCLiteral fieldNameLiteral = JavacTreeUtils.literal(attributeInfo.field.getSimpleName().toString());
                args = fieldName.toString().equals(attributeInfo.name) ? List.of(fieldNameLiteral, fieldClassRef) : List.of(JavacTreeUtils.literal(attributeInfo.name), fieldClassRef, fieldNameLiteral);
                fieldReaderMethodName = "fieldReaderWithField";
            }
            readerMethod = JavacTreeUtils.method(JavacTreeUtils.field(objectReadersType, fieldReaderMethodName), args);
        }
        return readerMethod;
    }

    private JCTree.JCMethodInvocation genFieldReaderList(JCTree.JCExpression objectReadersType, String fieldType, JCTree.JCLiteral fieldName, JCTree.JCExpression lambda) {
        String[] listTypes;
        String listType = null;
        String itemType = null;
        for (String item : listTypes = new String[]{"java.util.List", "java.util.ArrayList"}) {
            if (!fieldType.startsWith(item) || fieldType.length() == item.length() || fieldType.charAt(item.length()) != '<') continue;
            int lastIndex = fieldType.lastIndexOf(62);
            String temp = fieldType.substring(item.length() + 1, lastIndex);
            if (temp.indexOf(44) != -1 || temp.indexOf(63) != -1) break;
            listType = item;
            itemType = temp;
            break;
        }
        if (listType == null) {
            return null;
        }
        JCTree.JCMethodInvocation readerMethod = "java.lang.String".equals(itemType) && "java.util.List".equals(listType) ? JavacTreeUtils.method(JavacTreeUtils.field(objectReadersType, "fieldReaderListStr"), List.of(fieldName, lambda)) : JavacTreeUtils.method(JavacTreeUtils.field(objectReadersType, "fieldReaderList"), List.of(fieldName, JavacTreeUtils.field(this.getFieldValueType(itemType), this.names._class), JavacTreeUtils.constructorRef(JavacTreeUtils.qualIdent("java.util.ArrayList")), new JCTree.JCExpression[]{lambda}));
        return readerMethod;
    }

    private JCTree.JCMethodInvocation genFieldReaderMap(JCTree.JCExpression objectReadersType, String fieldType, JCTree.JCLiteral fieldName, JCTree.JCExpression lambda) {
        String[] mapTypes;
        String mapType = null;
        String keyType = null;
        String valueType = null;
        for (String item : mapTypes = new String[]{"java.util.Map", "java.util.HashMap", "java.util.TreeMap"}) {
            if (!fieldType.startsWith(item) || fieldType.length() == item.length() || fieldType.charAt(item.length()) != '<') continue;
            int lastIndex = fieldType.lastIndexOf(62);
            String keyValueType = fieldType.substring(item.length() + 1, lastIndex);
            if (keyValueType.indexOf(60) != -1 || keyValueType.indexOf(63) != -1) break;
            int commaIndex = keyValueType.indexOf(44);
            if (commaIndex == -1) continue;
            keyType = keyValueType.substring(0, commaIndex);
            valueType = keyValueType.substring(commaIndex + 1);
            if (keyType.indexOf(60) != -1 || keyType.indexOf(63) != -1 || valueType.indexOf(60) != -1 || valueType.indexOf(63) != -1) {
                keyType = null;
                valueType = null;
                continue;
            }
            mapType = item;
            break;
        }
        if (mapType == null) {
            return null;
        }
        return JavacTreeUtils.method(JavacTreeUtils.field(objectReadersType, "fieldReaderMap"), List.of(fieldName, JavacTreeUtils.field(this.getFieldValueType(mapType), this.names._class), JavacTreeUtils.field(this.getFieldValueType(keyType), this.names._class), new JCTree.JCExpression[]{JavacTreeUtils.field(this.getFieldValueType(valueType), this.names._class), lambda}));
    }

    private List<JCTree.JCStatement> genInitFields(int fieldsSize) {
        ListBuffer<JCTree.JCExpressionStatement> stmts = new ListBuffer<JCTree.JCExpressionStatement>();
        for (int i = 0; i < fieldsSize; ++i) {
            stmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.ident(CodeGenUtils.fieldReader(i)), JavacTreeUtils.indexed(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "fieldReaders"), JavacTreeUtils.literal(i)))));
        }
        return stmts.toList();
    }

    private JCTree.JCMethodDecl genCreateInstance(JCTree.JCIdent objectType, JCTree.JCNewClass beanNew) {
        JCTree.JCVariableDecl featuresVar = JavacTreeUtils.defVar(0x200000000L, "features", JavacTreeUtils.type(TypeTag.LONG));
        return JavacTreeUtils.defMethod(1L, "createInstance", (JCTree.JCExpression)objectType, null, List.of(featuresVar), null, JavacTreeUtils.block(JavacTreeUtils.defReturn(beanNew)), null);
    }

    private JCTree.JCMethodDecl genReadObject(JCTree.JCIdent objectType, JCTree.JCExpression beanType, JCTree.JCNewClass beanNew, java.util.List<AttributeInfo> attributeInfos, StructInfo structInfo, boolean jsonb) {
        int fieldNameLengthMin = 0;
        int fieldNameLengthMax = 0;
        for (int i = 0; i < attributeInfos.size(); ++i) {
            String fieldName = attributeInfos.get((int)i).name;
            int fieldNameLength = fieldName.getBytes(StandardCharsets.UTF_8).length;
            if (i == 0) {
                fieldNameLengthMin = fieldNameLength;
                fieldNameLengthMax = fieldNameLength;
                continue;
            }
            fieldNameLengthMin = Math.min(fieldNameLength, fieldNameLengthMin);
            fieldNameLengthMax = Math.max(fieldNameLength, fieldNameLengthMax);
        }
        JCTree.JCVariableDecl jsonReaderVar = JavacTreeUtils.defVar(0x200000000L, "jsonReader", JavacTreeUtils.qualIdent(JSONReader.class.getName()));
        JCTree.JCIdent jsonReaderIdent = JavacTreeUtils.ident(jsonReaderVar.name);
        JCTree.JCVariableDecl fieldTypeVar = JavacTreeUtils.defVar(0x200000000L, "fieldType", JavacTreeUtils.qualIdent(Type.class.getName()));
        JCTree.JCVariableDecl fieldNameVar = JavacTreeUtils.defVar(0x200000000L, "fieldName", objectType);
        JCTree.JCVariableDecl featuresVar = JavacTreeUtils.defVar(0x200000000L, "features", JavacTreeUtils.type(TypeTag.LONG));
        JCTree.JCReturn nullReturn = JavacTreeUtils.defReturn(JavacTreeUtils.defNull());
        ListBuffer<JCTree.JCStatement> readObjectBody = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCMethodInvocation nextIfNullMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfNull"));
        readObjectBody.append(JavacTreeUtils.defIf(nextIfNullMethod, JavacTreeUtils.block(nullReturn), null));
        readObjectBody.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfObjectStart"))));
        JCTree.JCVariableDecl features2Var = JavacTreeUtils.defVar(0x200000000L, "features2", JavacTreeUtils.type(TypeTag.LONG), JavacTreeUtils.binary(JCTree.Tag.BITOR, JavacTreeUtils.ident("features"), JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "features")));
        readObjectBody.append(features2Var);
        JCTree.JCVariableDecl objectVar = JavacTreeUtils.defVar(0x200000000L, "object", beanType, beanNew);
        JCTree.JCIdent objectIdent = JavacTreeUtils.ident(objectVar.name);
        readObjectBody.append(objectVar);
        int fieldsSize = attributeInfos.size();
        JCTree.JCLabeledStatement loopLabel = JavacTreeUtils.label("_while", null);
        JCTree.JCWhileLoop loopHead = JavacTreeUtils.whileLoop(JavacTreeUtils.unary(JCTree.Tag.NOT, JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfObjectEnd"))), null);
        ListBuffer<JCTree.JCStatement> loopBody = new ListBuffer<JCTree.JCStatement>();
        boolean switchGen = false;
        if (fieldNameLengthMin >= 2 && fieldNameLengthMax <= 43) {
            loopBody.appendList(this.genRead243(attributeInfos, jsonReaderIdent, structInfo, loopLabel, objectIdent, jsonb));
            switchGen = true;
        }
        JCTree.JCFieldAccess readFieldNameHashCode = JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "readFieldNameHashCode");
        JCTree.JCVariableDecl hashCode64Var = JavacTreeUtils.defVar(0x200000000L, "hashCode64", JavacTreeUtils.type(TypeTag.LONG), JavacTreeUtils.method(readFieldNameHashCode));
        JCTree.JCIdent hashCode64 = JavacTreeUtils.ident(hashCode64Var.name);
        loopBody.append(hashCode64Var);
        if (switchGen && !jsonb) {
            loopBody.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "readFieldValue"), List.of(hashCode64, jsonReaderIdent, JavacTreeUtils.ident(features2Var.name), new JCTree.JCExpression[]{JavacTreeUtils.ident(objectVar.name)}))));
        } else {
            if (fieldsSize <= 6) {
                for (int i = 0; i < fieldsSize; ++i) {
                    AttributeInfo attributeInfo = attributeInfos.get(i);
                    List<JCTree.JCStatement> readFieldValueStmts = this.genReadFieldValue(attributeInfo, jsonReaderIdent, i, structInfo, loopLabel, objectIdent, jsonb);
                    loopBody.appendList(List.of(JavacTreeUtils.defIf(JavacTreeUtils.binary(JCTree.Tag.EQ, JavacTreeUtils.literal(TypeTag.LONG, attributeInfo.nameHashCode), hashCode64), JavacTreeUtils.block(readFieldValueStmts), null)));
                }
            } else {
                TreeMap<Integer, java.util.List> map = new TreeMap<Integer, java.util.List>();
                TreeMap<Long, AttributeInfo> mapping = new TreeMap<Long, AttributeInfo>();
                TreeMap<Long, Integer> mappingIndex = new TreeMap<Long, Integer>();
                for (int i = 0; i < fieldsSize; ++i) {
                    AttributeInfo attr = attributeInfos.get(i);
                    long fieldNameHash = attr.nameHashCode;
                    int hashCode32 = (int)(fieldNameHash ^ fieldNameHash >>> 32);
                    java.util.List hashCode64List = map.computeIfAbsent(hashCode32, k -> new ArrayList());
                    hashCode64List.add(fieldNameHash);
                    mapping.put(fieldNameHash, attr);
                    mappingIndex.put(fieldNameHash, i);
                }
                int[] hashCode32Keys = new int[map.size()];
                int off = 0;
                for (Integer key : map.keySet()) {
                    hashCode32Keys[off++] = key;
                }
                Arrays.sort(hashCode32Keys);
                JCTree.JCVariableDecl hashCode32Var = this.getHashCode32Var(hashCode64);
                loopBody.append(hashCode32Var);
                JCTree.JCIdent hashCode32 = JavacTreeUtils.ident(hashCode32Var.name);
                JCTree.JCLabeledStatement switchLabel = JavacTreeUtils.label("_switch", null);
                ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
                for (int i = 0; i < hashCode32Keys.length; ++i) {
                    java.util.List hashCode64Array = (java.util.List)map.get(hashCode32Keys[i]);
                    List<JCTree.JCStatement> stmts = List.nil();
                    Long fieldNameHash = null;
                    if (hashCode64Array.size() == 1 && (Long)hashCode64Array.get(0) == (long)hashCode32Keys[i]) {
                        fieldNameHash = (Long)hashCode64Array.get(0);
                        int index = (Integer)mappingIndex.get(fieldNameHash);
                        AttributeInfo attributeInfo = (AttributeInfo)mapping.get(fieldNameHash);
                        stmts = stmts.appendList(this.genReadFieldValue(attributeInfo, jsonReaderIdent, index, structInfo, loopLabel, objectIdent, jsonb));
                        stmts.append(JavacTreeUtils.defContinue(loopLabel));
                    } else {
                        for (int j = 0; j < hashCode64Array.size(); ++j) {
                            fieldNameHash = (Long)hashCode64Array.get(j);
                            int index = (Integer)mappingIndex.get(fieldNameHash);
                            AttributeInfo field = (AttributeInfo)mapping.get(fieldNameHash);
                            List<JCTree.JCStatement> stmtsIf = this.genReadFieldValue(field, jsonReaderIdent, index, structInfo, loopLabel, objectIdent, jsonb);
                            stmts = stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.binary(JCTree.Tag.EQ, hashCode64, JavacTreeUtils.literal(fieldNameHash)), JavacTreeUtils.block(stmtsIf), null));
                            stmts.append(JavacTreeUtils.defContinue(loopLabel));
                        }
                        stmts.append(JavacTreeUtils.defBreak(switchLabel));
                    }
                    cases.append(JavacTreeUtils.defCase(this.getHashCode32Var(JavacTreeUtils.literal(fieldNameHash)).getInitializer(), stmts));
                }
                switchLabel.body = JavacTreeUtils.defSwitch(hashCode32, cases.toList());
                loopBody.append(switchLabel);
            }
            loopBody.append(JavacTreeUtils.defIf(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "readFieldValueWithLCase"), List.of(jsonReaderIdent, objectIdent, JavacTreeUtils.ident(hashCode64Var.name), new JCTree.JCExpression[]{JavacTreeUtils.ident(features2Var.name)})), JavacTreeUtils.block(JavacTreeUtils.defContinue(loopLabel)), null));
            JCTree.JCFieldAccess processExtraField = JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), "processExtra");
            loopBody.append(JavacTreeUtils.exec(JavacTreeUtils.method(processExtraField, List.of(jsonReaderIdent, objectIdent, JavacTreeUtils.ident(features2Var.name)))));
        }
        loopHead.body = JavacTreeUtils.block(loopBody.toList());
        loopLabel.body = loopHead;
        readObjectBody.append(loopLabel);
        if (!jsonb) {
            readObjectBody.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfComma"))));
        }
        readObjectBody.append(JavacTreeUtils.defReturn(objectIdent));
        return JavacTreeUtils.defMethod(1L, jsonb ? "readJSONBObject" : "readObject", (JCTree.JCExpression)objectType, null, List.of(jsonReaderVar, fieldTypeVar, fieldNameVar, new JCTree.JCVariableDecl[]{featuresVar}), null, JavacTreeUtils.block(readObjectBody.toList()), null);
    }

    private JCTree.JCVariableDecl getHashCode32Var(JCTree.JCExpression hashCode64) {
        JCTree.JCBinary usrBinary = JavacTreeUtils.binary(JCTree.Tag.USR, hashCode64, JavacTreeUtils.literal(TypeTag.INT, 32));
        JCTree.JCPrimitiveTypeTree intType = JavacTreeUtils.type(TypeTag.INT);
        JCTree.JCTypeCast hashCode32Cast = JavacTreeUtils.cast(intType, JavacTreeUtils.binary(JCTree.Tag.BITXOR, hashCode64, JavacTreeUtils.parens(usrBinary)));
        return JavacTreeUtils.defVar(0x200000000L, "hashCode32", intType, hashCode32Cast);
    }

    private List<JCTree.JCStatement> genReadFieldValue(AttributeInfo attributeInfo, JCTree.JCIdent jsonReaderIdent, int i, StructInfo structInfo, JCTree.JCLabeledStatement loopLabel, JCTree.JCIdent objectIdent, boolean jsonb) {
        String readDirectMethod;
        JCTree.JCExpression valueExpr = null;
        ListBuffer<JCTree.JCStatement> stmts = new ListBuffer<JCTree.JCStatement>();
        String type = attributeInfo.type.toString();
        boolean referenceDetect = structInfo.referenceDetect;
        if (referenceDetect) {
            referenceDetect = CodeGenUtils.isReference(type);
        }
        JCTree.JCFieldAccess fieldReaderField = JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), CodeGenUtils.fieldReader(i));
        if (referenceDetect) {
            ListBuffer<JCTree.JCStatement> thenStmts = new ListBuffer<JCTree.JCStatement>();
            JCTree.JCMethodInvocation readReferenceMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "readReference"));
            JCTree.JCVariableDecl refVar = JavacTreeUtils.defVar(0x200000000L, "ref", JavacTreeUtils.ident("String"), readReferenceMethod);
            thenStmts.append(refVar);
            JCTree.JCMethodInvocation addResolveTaskMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)fieldReaderField, "addResolveTask"), List.of(jsonReaderIdent, objectIdent, JavacTreeUtils.ident(refVar.name)));
            thenStmts.append(JavacTreeUtils.exec(addResolveTaskMethod));
            thenStmts.append(JavacTreeUtils.defContinue(loopLabel));
            stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "isReference")), JavacTreeUtils.block(thenStmts.toList()), null));
        }
        if ((readDirectMethod = CodeGenUtils.getReadDirectMethod(type)) != null) {
            valueExpr = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, readDirectMethod));
        } else {
            JCTree.JCExpression fieldValueType = this.getFieldValueType(type);
            JCTree.JCVariableDecl fieldValueVar = JavacTreeUtils.defVar(0x200000000L, attributeInfo.name, fieldValueType);
            stmts.append(fieldValueVar);
            if (type.startsWith("java.util.List<")) {
                valueExpr = this.genFieldValueList(type, attributeInfo, jsonReaderIdent, fieldValueVar, loopLabel, stmts, i, referenceDetect, fieldReaderField, jsonb);
            } else if (type.startsWith("java.util.Map<java.lang.String,")) {
                valueExpr = this.genFieldValueMap(type, attributeInfo, jsonReaderIdent, fieldValueVar, loopLabel, stmts, i, referenceDetect, jsonb);
            }
            if (valueExpr == null) {
                JCTree.JCIdent objectReaderIdent = JavacTreeUtils.ident(CodeGenUtils.fieldObjectReader(i));
                JCTree.JCMethodInvocation getObjectReaderMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)fieldReaderField, "getObjectReader"), List.of(jsonReaderIdent));
                JCTree.JCAssign objectReaderAssign = JavacTreeUtils.assign(objectReaderIdent, getObjectReaderMethod);
                stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.binary(JCTree.Tag.EQ, objectReaderIdent, JavacTreeUtils.defNull()), JavacTreeUtils.block(JavacTreeUtils.exec(objectReaderAssign)), null));
                JCTree.JCMethodInvocation objectMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(this.names._this), CodeGenUtils.fieldObjectReader(i)), jsonb ? "readJSONBObject" : "readObject"), List.of(jsonReaderIdent, JavacTreeUtils.field((JCTree.JCExpression)fieldReaderField, "fieldType"), JavacTreeUtils.literal(attributeInfo.name), new JCTree.JCExpression[]{JavacTreeUtils.literal(TypeTag.LONG, 0L)}));
                stmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.ident(fieldValueVar.name), JavacTreeUtils.cast(fieldValueType, objectMethod))));
                valueExpr = JavacTreeUtils.ident(fieldValueVar.name);
            }
        }
        if (attributeInfo.setMethod != null) {
            stmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)objectIdent, attributeInfo.setMethod.getSimpleName().toString()), List.of(valueExpr))));
        } else if (attributeInfo.field != null) {
            stmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.field((JCTree.JCExpression)objectIdent, attributeInfo.field.getSimpleName().toString()), valueExpr)));
        } else {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "not implemented yet");
        }
        stmts.append(JavacTreeUtils.defContinue(loopLabel));
        return stmts.toList();
    }

    private List<JCTree.JCStatement> genRead243(java.util.List<AttributeInfo> attributeInfos, JCTree.JCIdent jsonReaderIdent, StructInfo structInfo, JCTree.JCLabeledStatement loopLabel, JCTree.JCIdent objectIdent, boolean jsonb) {
        IdentityHashMap<AttributeInfo, Integer> readerIndexMap = new IdentityHashMap<AttributeInfo, Integer>();
        TreeMap<Integer, ArrayList<AttributeInfo>> name0Map = new TreeMap<Integer, ArrayList<AttributeInfo>>();
        for (int i = 0; i < attributeInfos.size(); ++i) {
            AttributeInfo field = attributeInfos.get(i);
            readerIndexMap.put(field, i);
            byte[] fieldName = field.name.getBytes(StandardCharsets.UTF_8);
            byte[] name0Bytes = new byte[4];
            name0Bytes[0] = 34;
            if (fieldName.length == 2) {
                System.arraycopy(fieldName, 0, name0Bytes, 1, 2);
                name0Bytes[3] = 34;
            } else {
                System.arraycopy(fieldName, 0, name0Bytes, 1, 3);
            }
            int name0 = JDKUtils.UNSAFE.getInt(name0Bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
            ArrayList<AttributeInfo> fieldReaders = (ArrayList<AttributeInfo>)name0Map.get(name0);
            if (fieldReaders == null) {
                fieldReaders = new ArrayList<AttributeInfo>();
                name0Map.put(name0, fieldReaders);
            }
            fieldReaders.add(field);
        }
        int[] switchKeys = new int[name0Map.size()];
        Label[] labels = new Label[name0Map.size()];
        Iterator it = name0Map.keySet().iterator();
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = new Label();
            switchKeys[i] = (Integer)it.next();
        }
        List<JCTree.JCStatement> stmts = List.nil();
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        JCTree.JCLabeledStatement switchLabel = JavacTreeUtils.label("_switch2", null);
        for (int i = 0; i < labels.length; ++i) {
            int name0 = switchKeys[i];
            java.util.List fieldReaders = (java.util.List)name0Map.get(name0);
            ListBuffer<JCTree.JCStatement> caseStmts = new ListBuffer<JCTree.JCStatement>();
            for (int j = 0; j < fieldReaders.size(); ++j) {
                JCTree.JCMethodInvocation nextIfMethod;
                AttributeInfo fieldReader = (AttributeInfo)fieldReaders.get(j);
                int fieldReaderIndex = (Integer)readerIndexMap.get(fieldReader);
                byte[] fieldName = fieldReader.name.getBytes(StandardCharsets.UTF_8);
                int fieldNameLength = fieldName.length;
                switch (fieldNameLength) {
                    case 2: {
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match2"));
                        break;
                    }
                    case 3: {
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match3"));
                        break;
                    }
                    case 4: {
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match4"), List.of(JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[3]))));
                        break;
                    }
                    case 5: {
                        byte[] bytes4 = new byte[]{fieldName[3], fieldName[4], 34, 58};
                        int name1 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match5"), List.of(JavacTreeUtils.literal(name1)));
                        break;
                    }
                    case 6: {
                        byte[] bytes4 = new byte[]{fieldName[3], fieldName[4], fieldName[5], 34};
                        int name1 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match6"), List.of(JavacTreeUtils.literal(name1)));
                        break;
                    }
                    case 7: {
                        int name1 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match7"), List.of(JavacTreeUtils.literal(name1)));
                        break;
                    }
                    case 8: {
                        int name1 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match8"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[7]))));
                        break;
                    }
                    case 9: {
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 3, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name1 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match9"), List.of(JavacTreeUtils.literal(name1)));
                        break;
                    }
                    case 10: {
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 3, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name1 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match10"), List.of(JavacTreeUtils.literal(name1)));
                        break;
                    }
                    case 11: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match11"), List.of(JavacTreeUtils.literal(name1)));
                        break;
                    }
                    case 12: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match12"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[11]))));
                        break;
                    }
                    case 13: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        byte[] bytes4 = new byte[]{fieldName[11], fieldName[12], 34, 58};
                        int name2 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match13"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2)));
                        break;
                    }
                    case 14: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        byte[] bytes4 = new byte[]{fieldName[11], fieldName[12], fieldName[13], 34};
                        int name2 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match14"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2)));
                        break;
                    }
                    case 15: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        int name2 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match15"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2)));
                        break;
                    }
                    case 16: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        int name2 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match16"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[15]))));
                        break;
                    }
                    case 17: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 11, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name2 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match17"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2)));
                        break;
                    }
                    case 18: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 11, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name2 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match18"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2)));
                        break;
                    }
                    case 19: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match19"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2)));
                        break;
                    }
                    case 20: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match20"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[19]))));
                        break;
                    }
                    case 21: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        byte[] bytes4 = new byte[]{fieldName[19], fieldName[20], 34, 58};
                        int name3 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match21"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3)));
                        break;
                    }
                    case 22: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        byte[] bytes4 = new byte[]{fieldName[19], fieldName[20], fieldName[21], 34};
                        int name3 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match22"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3)));
                        break;
                    }
                    case 23: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        int name3 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match23"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3)));
                        break;
                    }
                    case 24: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        int name3 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match24"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[23]))}));
                        break;
                    }
                    case 25: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 19, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name3 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match25"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3)));
                        break;
                    }
                    case 26: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 19, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name3 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match26"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3)));
                        break;
                    }
                    case 27: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match27"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3)));
                        break;
                    }
                    case 28: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match28"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[27]))}));
                        break;
                    }
                    case 29: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        byte[] bytes4 = new byte[]{fieldName[27], fieldName[28], 34, 58};
                        int name4 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match29"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4)}));
                        break;
                    }
                    case 30: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        byte[] bytes4 = new byte[]{fieldName[27], fieldName[28], fieldName[29], 34};
                        int name4 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match30"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4)}));
                        break;
                    }
                    case 31: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        int name4 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match31"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4)}));
                        break;
                    }
                    case 32: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        int name4 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match32"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4), JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[31]))}));
                        break;
                    }
                    case 33: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 27, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name4 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match33"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4)}));
                        break;
                    }
                    case 34: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 27, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name4 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match34"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4)}));
                        break;
                    }
                    case 35: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match35"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4)}));
                        break;
                    }
                    case 36: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match36"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4), JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[35]))}));
                        break;
                    }
                    case 37: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        byte[] bytes4 = new byte[]{fieldName[35], fieldName[36], 34, 58};
                        int name5 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match37"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4), JavacTreeUtils.literal(name5)}));
                        break;
                    }
                    case 38: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        byte[] bytes4 = new byte[]{fieldName[35], fieldName[36], fieldName[37], 34};
                        int name5 = JDKUtils.UNSAFE.getInt(bytes4, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match38"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4), JavacTreeUtils.literal(name5)}));
                        break;
                    }
                    case 39: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        int name5 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 35L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match39"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4), JavacTreeUtils.literal(name5)}));
                        break;
                    }
                    case 40: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        int name5 = JDKUtils.UNSAFE.getInt(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 35L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match40"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4), JavacTreeUtils.literal(name5), JavacTreeUtils.cast(JavacTreeUtils.type(TypeTag.BYTE), JavacTreeUtils.literal(TypeTag.INT, fieldName[39]))}));
                        break;
                    }
                    case 41: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 35, bytes8, 0, 6);
                        bytes8[6] = 34;
                        bytes8[7] = 58;
                        long name5 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match41"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4), JavacTreeUtils.literal(name5)}));
                        break;
                    }
                    case 42: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        byte[] bytes8 = new byte[8];
                        System.arraycopy(fieldName, 35, bytes8, 0, 7);
                        bytes8[7] = 34;
                        long name5 = JDKUtils.UNSAFE.getLong(bytes8, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match42"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4), JavacTreeUtils.literal(name5)}));
                        break;
                    }
                    case 43: {
                        long name1 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 3L);
                        long name2 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 11L);
                        long name3 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 19L);
                        long name4 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 27L);
                        long name5 = JDKUtils.UNSAFE.getLong(fieldName, JDKUtils.ARRAY_BYTE_BASE_OFFSET + 35L);
                        nextIfMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfName4Match43"), List.of(JavacTreeUtils.literal(name1), JavacTreeUtils.literal(name2), JavacTreeUtils.literal(name3), new JCTree.JCExpression[]{JavacTreeUtils.literal(name4), JavacTreeUtils.literal(name5)}));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("fieldNameLength " + fieldNameLength);
                    }
                }
                List<JCTree.JCStatement> readFieldValueStmts = this.genReadFieldValue(fieldReader, jsonReaderIdent, fieldReaderIndex, structInfo, loopLabel, objectIdent, jsonb);
                caseStmts.append(JavacTreeUtils.defIf(nextIfMethod, JavacTreeUtils.block(readFieldValueStmts), null));
            }
            caseStmts.append(JavacTreeUtils.defBreak(switchLabel));
            cases.append(JavacTreeUtils.defCase(JavacTreeUtils.literal(name0), caseStmts.toList()));
        }
        switchLabel.body = JavacTreeUtils.defSwitch(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "getRawInt")), cases.toList());
        stmts = stmts.append(switchLabel);
        return stmts;
    }

    private JCTree.JCExpression genFieldValueList(String type, AttributeInfo attributeInfo, JCTree.JCIdent jsonReaderIdent, JCTree.JCVariableDecl fieldValueVar, JCTree.JCLabeledStatement loopLabel, ListBuffer<JCTree.JCStatement> stmts, int i, boolean referenceDetect, JCTree.JCFieldAccess fieldReaderField, boolean jsonb) {
        boolean itemTypeIsClass;
        String itemType = type.substring(15, type.length() - 1);
        boolean bl = itemTypeIsClass = itemType.indexOf(60) == -1;
        if (itemTypeIsClass) {
            JCTree.JCMethodInvocation nextIfNullMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfNull"));
            stmts.append(JavacTreeUtils.defIf(nextIfNullMethod, JavacTreeUtils.block(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.ident(fieldValueVar.name), JavacTreeUtils.defNull()))), JavacTreeUtils.block(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.ident(fieldValueVar.name), JavacTreeUtils.newClass(null, null, JavacTreeUtils.qualIdent("java.util.ArrayList"), null, null))))));
            String readDirectMethod = CodeGenUtils.getReadDirectMethod(itemType);
            JCTree.JCIdent itemReaderIdent = JavacTreeUtils.ident(CodeGenUtils.fieldItemObjectReader(i));
            if (readDirectMethod == null) {
                JCTree.JCFieldAccess getItemObjectReaderField = JavacTreeUtils.field((JCTree.JCExpression)fieldReaderField, "getItemObjectReader");
                JCTree.JCExpressionStatement getItemObjectReaderExec = JavacTreeUtils.exec(JavacTreeUtils.assign(itemReaderIdent, JavacTreeUtils.method(getItemObjectReaderField, List.of(jsonReaderIdent))));
                stmts.append(JavacTreeUtils.defIf(JavacTreeUtils.binary(JCTree.Tag.EQ, itemReaderIdent, JavacTreeUtils.defNull()), JavacTreeUtils.block(getItemObjectReaderExec), null));
            }
            if (referenceDetect) {
                referenceDetect = CodeGenUtils.isReference(itemType);
            }
            JCTree.JCVariableDecl for_iVar = "i".equals(attributeInfo.name) ? JavacTreeUtils.defVar(0x200000000L, "j", JavacTreeUtils.type(TypeTag.INT), JavacTreeUtils.literal(0)) : JavacTreeUtils.defVar(0x200000000L, "i", JavacTreeUtils.type(TypeTag.INT), JavacTreeUtils.literal(0));
            JCTree.JCMethodInvocation nextIfArrayStartMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfArrayStart"));
            JCTree.JCMethodInvocation nextIfArrayEndMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfArrayEnd"));
            ListBuffer<JCTree.JCStatement> whileStmts = new ListBuffer<JCTree.JCStatement>();
            JCTree.JCExpression item = readDirectMethod != null ? JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, readDirectMethod)) : JavacTreeUtils.cast(JavacTreeUtils.qualIdent(itemType), JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)itemReaderIdent, jsonb ? "readJSONBObject" : "readObject"), List.of(jsonReaderIdent, JavacTreeUtils.defNull(), JavacTreeUtils.defNull(), new JCTree.JCExpression[]{JavacTreeUtils.literal(TypeTag.LONG, 0L)})));
            if (referenceDetect) {
                JCTree.JCVariableDecl listItemVar = JavacTreeUtils.defVar(0x200000000L, attributeInfo.name + "_item", this.getFieldValueType(itemType), item);
                ListBuffer<JCTree.JCStatement> isReferenceStmts = new ListBuffer<JCTree.JCStatement>();
                JCTree.JCMethodInvocation readReferenceMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "readReference"));
                JCTree.JCVariableDecl refVar = JavacTreeUtils.defVar(0x200000000L, "ref", JavacTreeUtils.ident("String"), readReferenceMethod);
                isReferenceStmts.append(refVar);
                JCTree.JCMethodInvocation addResolveTaskMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "addResolveTask"), List.of(JavacTreeUtils.ident(fieldValueVar.name), JavacTreeUtils.ident(for_iVar.name), JavacTreeUtils.method(JavacTreeUtils.field(JavacTreeUtils.qualIdent("com.alibaba.fastjson2.JSONPath"), "of"), List.of(JavacTreeUtils.ident(refVar.name)))));
                isReferenceStmts.append(JavacTreeUtils.exec(addResolveTaskMethod));
                isReferenceStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(fieldValueVar.name), "add"), List.of(JavacTreeUtils.defNull()))));
                isReferenceStmts.append(JavacTreeUtils.defContinue(loopLabel));
                whileStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "isReference")), JavacTreeUtils.block(isReferenceStmts.toList()), null));
                whileStmts.append(listItemVar);
                item = JavacTreeUtils.ident(listItemVar.name);
            }
            whileStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(fieldValueVar.name), "add"), List.of(item))));
            ListBuffer<JCTree.JCStatement> condStmts = new ListBuffer<JCTree.JCStatement>();
            if (referenceDetect) {
                condStmts.append(JavacTreeUtils.forLoop(List.of(for_iVar), JavacTreeUtils.unary(JCTree.Tag.NOT, nextIfArrayEndMethod), List.of(JavacTreeUtils.exec(JavacTreeUtils.unary(JCTree.Tag.PREINC, JavacTreeUtils.ident(for_iVar.name)))), JavacTreeUtils.block(whileStmts.toList())));
            } else {
                condStmts.append(JavacTreeUtils.whileLoop(JavacTreeUtils.unary(JCTree.Tag.NOT, nextIfArrayEndMethod), JavacTreeUtils.block(whileStmts.toList())));
            }
            stmts.append(JavacTreeUtils.defIf(nextIfArrayStartMethod, JavacTreeUtils.block(condStmts.toList()), null));
            return JavacTreeUtils.ident(fieldValueVar.name);
        }
        return null;
    }

    private JCTree.JCExpression genFieldValueMap(String type, AttributeInfo attributeInfo, JCTree.JCIdent jsonReaderIdent, JCTree.JCVariableDecl fieldValueVar, JCTree.JCLabeledStatement loopLabel, ListBuffer<JCTree.JCStatement> stmts, int i, boolean referenceDetect, boolean jsonb) {
        String itemType = type.substring(31, type.length() - 1);
        JCTree.JCMethodInvocation nextIfNullMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfNull"));
        boolean readDirect = CodeGenUtils.supportReadDirect(itemType);
        ListBuffer<JCTree.JCStatement> elseStmts = new ListBuffer<JCTree.JCStatement>();
        JCTree.JCIdent itemReaderIdent = JavacTreeUtils.ident(CodeGenUtils.fieldItemObjectReader(i));
        if (!readDirect) {
            JCTree.JCFieldAccess getObjectReaderField = JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "getObjectReader");
            JCTree.JCExpressionStatement getItemObjectReaderExec = JavacTreeUtils.exec(JavacTreeUtils.assign(itemReaderIdent, JavacTreeUtils.method(getObjectReaderField, List.of(JavacTreeUtils.field(JavacTreeUtils.qualIdent(itemType), this.names._class)))));
            elseStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.binary(JCTree.Tag.EQ, itemReaderIdent, JavacTreeUtils.defNull()), JavacTreeUtils.block(getItemObjectReaderExec), null));
        }
        elseStmts.append(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.ident(fieldValueVar.name), JavacTreeUtils.newClass(null, null, JavacTreeUtils.qualIdent("java.util.HashMap"), null, null))));
        JCTree.JCMethodInvocation nextIfObjectStartMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfObjectStart"));
        elseStmts.append(JavacTreeUtils.exec(nextIfObjectStartMethod));
        JCTree.JCMethodInvocation nextIfObjectEndMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfObjectEnd"));
        ListBuffer<JCTree.JCStatement> whileStmts = new ListBuffer<JCTree.JCStatement>();
        if (referenceDetect) {
            referenceDetect = CodeGenUtils.isReference(itemType);
        }
        JCTree.JCTypeCast mapEntryValueExpr = readDirect ? JavacTreeUtils.cast(JavacTreeUtils.qualIdent(itemType), JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, CodeGenUtils.getReadDirectMethod(itemType)))) : JavacTreeUtils.cast(JavacTreeUtils.qualIdent(itemType), JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)itemReaderIdent, jsonb ? "readJSONBObject" : "readObject"), List.of(jsonReaderIdent, JavacTreeUtils.field(JavacTreeUtils.qualIdent(itemType), this.names._class), JavacTreeUtils.literal(attributeInfo.name), new JCTree.JCExpression[]{JavacTreeUtils.ident("features")})));
        JCTree.JCMethodInvocation mapEntryKeyExpr = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "readFieldName"));
        if (referenceDetect) {
            JCTree.JCVariableDecl mapKey = JavacTreeUtils.defVar(0x200000000L, attributeInfo.name + "_key", JavacTreeUtils.ident("String"), mapEntryKeyExpr);
            whileStmts.append(mapKey);
            JCTree.JCVariableDecl mapValue = JavacTreeUtils.defVar(0x200000000L, attributeInfo.name + "_value", JavacTreeUtils.ident("String"));
            whileStmts.append(mapValue);
            ListBuffer<JCTree.JCStatement> isReferenceStmts = new ListBuffer<JCTree.JCStatement>();
            JCTree.JCMethodInvocation readReferenceMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "readReference"));
            JCTree.JCVariableDecl refVar = JavacTreeUtils.defVar(0x200000000L, "ref", JavacTreeUtils.ident("String"), readReferenceMethod);
            isReferenceStmts.append(refVar);
            JCTree.JCMethodInvocation addResolveTaskMethod = JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "addResolveTask"), List.of(JavacTreeUtils.ident(fieldValueVar.name), JavacTreeUtils.ident(mapKey.name), JavacTreeUtils.method(JavacTreeUtils.field(JavacTreeUtils.qualIdent("com.alibaba.fastjson2.JSONPath"), "of"), List.of(JavacTreeUtils.ident(refVar.name)))));
            isReferenceStmts.append(JavacTreeUtils.exec(addResolveTaskMethod));
            whileStmts.append(JavacTreeUtils.defIf(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "isReference")), JavacTreeUtils.block(isReferenceStmts.toList()), JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(fieldValueVar.name), "put"), List.of(mapEntryKeyExpr, mapEntryValueExpr)))));
        } else {
            whileStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)JavacTreeUtils.ident(fieldValueVar.name), "put"), List.of(mapEntryKeyExpr, mapEntryValueExpr))));
        }
        elseStmts.append(JavacTreeUtils.whileLoop(JavacTreeUtils.unary(JCTree.Tag.NOT, nextIfObjectEndMethod), JavacTreeUtils.block(whileStmts.toList())));
        elseStmts.append(JavacTreeUtils.exec(JavacTreeUtils.method(JavacTreeUtils.field((JCTree.JCExpression)jsonReaderIdent, "nextIfComma"))));
        stmts.append(JavacTreeUtils.defIf(nextIfNullMethod, JavacTreeUtils.block(JavacTreeUtils.exec(JavacTreeUtils.assign(JavacTreeUtils.ident(fieldValueVar.name), JavacTreeUtils.defNull()))), JavacTreeUtils.block(elseStmts.toList())));
        return JavacTreeUtils.ident(fieldValueVar.name);
    }

    private void genSource(String fullQualifiedName, StructInfo structInfo, JCTree.JCClassDecl innerClass) {
        try {
            JavaFileObject converterFile = this.processingEnv.getFiler().createSourceFile(fullQualifiedName, structInfo.element);
            try (Writer writer = converterFile.openWriter();){
                int idx = fullQualifiedName.lastIndexOf(".");
                if (idx != -1) {
                    String pkgPath = fullQualifiedName.substring(0, idx);
                    writer.write("package " + pkgPath + ";");
                    writer.write(System.lineSeparator());
                }
                String str = innerClass.toString().replaceFirst("public static class ", "public class ");
                Formatter formatter = new Formatter();
                writer.write(formatter.formatSource(str));
            }
            catch (Exception e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed saving compiled json serialization file " + fullQualifiedName + e.getMessage());
            }
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed creating compiled json serialization file " + fullQualifiedName + e.getMessage());
        }
    }

    private JCTree.JCExpression getFieldValueType(String type) {
        if (type.indexOf("[") != -1) {
            return JavacTreeUtils.arrayIdent(type);
        }
        if (type.indexOf("<") != -1) {
            return JavacTreeUtils.collectionIdent(type);
        }
        return JavacTreeUtils.qualIdent(type);
    }

    private String findConverterName(StructInfo structInfo) {
        int dotIndex = structInfo.binaryName.lastIndexOf(36);
        if (dotIndex != -1) {
            dotIndex = structInfo.binaryName.lastIndexOf(46);
        }
        String className = structInfo.binaryName.substring(dotIndex + 1);
        if (dotIndex == -1) {
            return className + "_FASTJSONReader";
        }
        String packageName = structInfo.binaryName.substring(0, dotIndex);
        return packageName + '.' + className + "_FASTJSONReader";
    }
}

