/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay.gen;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.benchmark.eishay.EishayForyWriteNoneCache;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.DynamicClassLoader;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class EishayClassGen {
    public Class genMedia(DynamicClassLoader classLoader, String packageName) throws Exception {
        classLoader.definePackage(packageName.replace('/', '.'));
        LinkedHashMap<String, byte[]> codes = new LinkedHashMap<String, byte[]>();
        LinkedHashMap classes = new LinkedHashMap();
        this.genCode(packageName, codes);
        codes.forEach((name, code) -> {
            Class clazz = classLoader.loadClass(name, code, 0, ((byte[])code).length);
            classes.put(name, clazz);
        });
        String mediaContentClassName = packageName.replace('/', '.') + ".MediaContent";
        return (Class)classes.get(mediaContentClassName);
    }

    public void genCode(String packageName, Map<String, byte[]> classBytes) {
        String playerType = packageName + "/Media$Player";
        String playerClassName = playerType.replace('/', '.');
        byte[] playerCode = this.genEnum(playerType, "JAVA", "FLASH");
        classBytes.put(playerClassName, playerCode);
        String mediaType = packageName + "/Media";
        String mediaClassName = mediaType.replace('/', '.');
        byte[] mediaCode = this.genClass(mediaType, new FieldInfo("bitrate", Long.TYPE), new FieldInfo("duration", Long.TYPE), new FieldInfo("format", (Type)((Object)String.class)), new FieldInfo("height", Integer.TYPE), new FieldInfo("persons", TypeReference.collectionType(List.class, String.class)), new FieldInfo("player", "L" + playerType + ";", null), new FieldInfo("size", Long.TYPE), new FieldInfo("title", (Type)((Object)String.class)), new FieldInfo("uri", (Type)((Object)String.class)), new FieldInfo("width", Integer.TYPE), new FieldInfo("copyright", (Type)((Object)String.class)));
        classBytes.put(mediaClassName, mediaCode);
        String sizeType = packageName + "/Image$Size";
        String sizeClassName = sizeType.replace('/', '.');
        byte[] sizeCode = this.genEnum(sizeType, "SMALL", "LARGE");
        classBytes.put(sizeClassName, sizeCode);
        String imageType = packageName + "/Image";
        String imageClassName = imageType.replace('/', '.');
        byte[] imageCode = this.genClass(imageType, new FieldInfo("height", Integer.TYPE), new FieldInfo("size", "L" + sizeType + ";", null), new FieldInfo("title", (Type)((Object)String.class)), new FieldInfo("uri", (Type)((Object)String.class)), new FieldInfo("width", Integer.TYPE));
        classBytes.put(imageClassName, imageCode);
        String mediaContentType = packageName + "/MediaContent";
        String mediaContentClassName = mediaContentType.replace('/', '.');
        byte[] mediaContentCode = this.genClass(mediaContentType, new FieldInfo("media", "L" + mediaType + ";", null), new FieldInfo("images", "Ljava/util/List;", "Ljava/util/List<L" + imageType + ";>;"));
        classBytes.put(mediaContentClassName, mediaContentCode);
    }

    static String getSignature(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] arguments = paramType.getActualTypeArguments();
            if (rawType == List.class) {
                Class itemType = (Class)arguments[0];
                String signature = "Ljava/util/List<" + org.objectweb.asm.Type.getType((Class)itemType) + ">;";
                return signature;
            }
        }
        return null;
    }

    public byte[] genClass(String type, FieldInfo ... fields) {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(52, 33, type, null, "java/lang/Object", new String[]{"java/io/Serializable"});
        for (FieldInfo field : fields) {
            FieldVisitor fv = cw.visitField(1, field.name, field.desc, field.signature, null);
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", "()V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    public byte[] genEnum(String type, String ... values) {
        int i;
        ClassWriter cw = new ClassWriter(1);
        String desc = "L" + type + ";";
        cw.visit(52, 16433, type, "Ljava/lang/Enum<L" + type + ";>;", "java/lang/Enum", null);
        for (String value : values) {
            FieldVisitor fv = cw.visitField(16409, value, desc, null, null);
            fv.visitEnd();
        }
        FieldVisitor fv = cw.visitField(4122, "$VALUES", "[" + desc, null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(2, "<init>", "(Ljava/lang/String;I)V", "()V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(183, "java/lang/Enum", "<init>", "(Ljava/lang/String;I)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(25, "values", "()[" + desc, null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, type, "$VALUES", "[" + desc);
        mv.visitMethodInsn(182, "[" + desc, "clone", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, "[" + desc);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(9, "valueOf", "(Ljava/lang/String;)" + desc, null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)desc));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
        mv.visitTypeInsn(192, type);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (i = 0; i < values.length; ++i) {
            String value = values[i];
            mv.visitTypeInsn(187, type);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)value);
            mv.visitLdcInsn((Object)i);
            mv.visitMethodInsn(183, type, "<init>", "(Ljava/lang/String;I)V");
            mv.visitFieldInsn(179, type, value, desc);
        }
        mv.visitLdcInsn((Object)values.length);
        mv.visitTypeInsn(189, type);
        for (i = 0; i < values.length; ++i) {
            String value = values[i];
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitFieldInsn(178, type, value, desc);
            mv.visitInsn(83);
        }
        mv.visitFieldInsn(179, type, "$VALUES", "[" + desc);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    public byte[][] genFastjsonJSONBBytes(int count, JSONWriter.Feature[] writerFeatures) throws Exception {
        try (InputStream is = EishayForyWriteNoneCache.class.getClassLoader().getResourceAsStream("data/eishay.json");){
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            DynamicClassLoader classLoader = new DynamicClassLoader();
            byte[][] bytes = new byte[count][];
            EishayClassGen gen = new EishayClassGen();
            for (int i = 0; i < count; ++i) {
                String packageName = "com/alibaba/fastjson2/benchmark/eishay" + i;
                Class objectClass = gen.genMedia(classLoader, packageName);
                ObjectReaderProvider provider = new ObjectReaderProvider();
                Object object = JSONReader.of((String)str, (JSONReader.Context)JSONFactory.createReadContext((ObjectReaderProvider)provider, (JSONReader.Feature[])new JSONReader.Feature[0])).read(objectClass);
                ObjectWriterProvider writerProvider = new ObjectWriterProvider();
                bytes[i] = JSONB.toBytes((Object)object, (JSONWriter.Context)JSONFactory.createWriteContext((ObjectWriterProvider)writerProvider, (JSONWriter.Feature[])writerFeatures));
            }
            byte[][] byArrayArray = bytes;
            return byArrayArray;
        }
    }

    public LinkedHashMap<String, byte[]> genCodes(int count) throws Exception {
        LinkedHashMap<String, byte[]> codeMap = new LinkedHashMap<String, byte[]>();
        EishayClassGen gen = new EishayClassGen();
        for (int i = 0; i < count; ++i) {
            String packageName = "com/alibaba/fastjson2/benchmark/eishay" + i;
            gen.genCode(packageName, codeMap);
        }
        return codeMap;
    }

    public byte[][] genForyBytes(int count) throws Exception {
        throw new JSONException("TODO");
    }

    static class FieldInfo {
        final String name;
        final String desc;
        final String signature;

        FieldInfo(String name, Type type) {
            this.name = name;
            Class fieldClass = TypeUtils.getClass((Type)type);
            this.desc = org.objectweb.asm.Type.getDescriptor((Class)fieldClass);
            this.signature = EishayClassGen.getSignature(type);
        }

        FieldInfo(String name, String desc, String signature) {
            this.name = name;
            this.desc = desc;
            this.signature = signature;
        }
    }
}

