/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.fory.Fory;
import org.apache.fory.ThreadSafeFory;
import org.apache.fory.config.Language;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayForyWrite {
    static MediaContent object;
    static ThreadSafeFory fory;
    static JSONWriter.Feature[] features;
    static JSONWriter.Context context;

    @Benchmark
    public void jsonb(Blackhole bh) {
        byte[] bytes = JSONB.toBytes((Object)object, (JSONWriter.Context)context);
        bh.consume((Object)bytes);
    }

    @Benchmark
    public void fory(Blackhole bh) {
        byte[] bytes = fory.serialize((Object)object);
        bh.consume((Object)bytes);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayForyWrite.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(16).build();
        new Runner(options).run();
    }

    static {
        fory = Fory.builder().withLanguage(Language.JAVA).requireClassRegistration(false).withRefTracking(true).buildThreadSafeFory();
        features = new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName, JSONWriter.Feature.IgnoreNoneSerializable, JSONWriter.Feature.FieldBased, JSONWriter.Feature.ReferenceDetection, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NotWriteDefaultValue, JSONWriter.Feature.NotWriteHashMapArrayListClassName, JSONWriter.Feature.BeanToArray};
        context = new JSONWriter.Context(JSONFactory.getDefaultObjectWriterProvider(), features);
        try {
            InputStream is = EishayForyWrite.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            object = (MediaContent)JSONReader.of((String)str).read(MediaContent.class);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

