/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wycst.wast.json.options.WriteOption;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayWriteUTF8BytesTree {
    static JSONObject mc;
    static final ObjectMapper mapper;

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.toJSONBytes((Object)mc));
    }

    public void fastjson2_ReferenceDetection(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)mc, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection}));
    }

    public void fastjson2_jsonb(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)mc));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsBytes((Object)mc));
    }

    public void wastjson(Blackhole bh) throws Exception {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonBytes((Object)mc, (WriteOption[])new WriteOption[0]));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayWriteUTF8BytesTree.class.getName()).mode(Mode.Throughput).warmupIterations(3).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(16).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        try {
            InputStream is = EishayWriteUTF8BytesTree.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            mc = (JSONObject)JSONReader.of((String)str).readAny();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

