/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.wast;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.benchmark.wast.SimpleBean;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wycst.wast.json.options.ReadOption;
import io.github.wycst.wast.json.options.WriteOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class SimpleBeanWriteCase {
    private static String result;
    static ObjectMapper mapper;
    private static Object simpleBean;

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)simpleBean));
    }

    @Benchmark
    public void wastjson(Blackhole bh) {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonString((Object)simpleBean));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsString(simpleBean));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(SimpleBeanWriteCase.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        HashMap<String, Object> simpleMap = new HashMap<String, Object>();
        simpleMap.put("id", 1);
        simpleMap.put("date", new Date());
        simpleMap.put("name", "simple");
        simpleMap.put("percent", 12.34);
        simpleMap.put("version", System.currentTimeMillis());
        HashMap<String, String> mapType = new HashMap<String, String>();
        mapType.put("v1", "v1 helldsdsd ");
        mapType.put("v2", "v2 helldsdsd ");
        simpleMap.put("mapInstance", mapType);
        ArrayList<String> versions = new ArrayList<String>();
        versions.add("v0.0.1");
        versions.add("v0.0.2");
        versions.add("v0.0.3");
        simpleMap.put("versions", versions);
        result = io.github.wycst.wast.json.JSON.toJsonString(simpleMap, (WriteOption[])new WriteOption[]{WriteOption.FormatOut});
        simpleBean = io.github.wycst.wast.json.JSON.parseObject((String)result, SimpleBean.class, (ReadOption[])new ReadOption[0]);
        System.out.println(JSON.toJSONString((Object)simpleBean));
        System.out.println(io.github.wycst.wast.json.JSON.toJsonString((Object)simpleBean));
        try {
            System.out.println(mapper.writeValueAsString(simpleBean));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

