/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EncodeUTF8Benchmark {
    static String STR = "01234567890ABCDEFGHIJKLMNOPQRSTUVWZYZabcdefghijklmnopqrstuvwzyz\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341";
    static byte[] out = new byte[STR.length() * 3];
    static long valueFieldOffset;

    @Benchmark
    public int unsafeEncodeUTF8() throws Exception {
        char[] chars = (char[])JDKUtils.UNSAFE.getObject(STR, valueFieldOffset);
        return IOUtils.encodeUTF8((char[])chars, (int)0, (int)chars.length, (byte[])out, (int)0);
    }

    @Benchmark
    public byte[] getBytesUTF8() throws Exception {
        byte[] bytes = STR.getBytes(StandardCharsets.UTF_8);
        System.arraycopy(bytes, 0, out, 0, bytes.length);
        return out;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EncodeUTF8Benchmark.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        try {
            Field valueField = String.class.getDeclaredField("value");
            valueFieldOffset = JDKUtils.UNSAFE.objectFieldOffset(valueField);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

